/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.manager.EaseVoiceRecorder;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowVoicePlayer;

public class EaseVoiceRecorderView
extends RelativeLayout {
    protected Context context;
    protected LayoutInflater inflater;
    protected Drawable[] micImages;
    protected EaseVoiceRecorder voiceRecorder;
    protected PowerManager.WakeLock wakeLock;
    protected ImageView ivIcon;
    protected ImageView micImage;
    protected TextView recordingHint;
    protected Handler micImageHandler = new Handler(){

        public void handleMessage(Message msg) {
            int index = msg.what;
            if (index < 0 || index > EaseVoiceRecorderView.this.micImages.length - 1) {
                return;
            }
            EaseVoiceRecorderView.this.micImage.setImageDrawable(EaseVoiceRecorderView.this.micImages[index]);
        }
    };

    public EaseVoiceRecorderView(Context context) {
        super(context);
        this.init(context);
    }

    public EaseVoiceRecorderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EaseVoiceRecorderView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.ease_widget_voice_recorder, (ViewGroup)this);
        this.ivIcon = (ImageView)this.findViewById(R.id.iv_icon);
        this.micImage = (ImageView)this.findViewById(R.id.mic_image);
        this.recordingHint = (TextView)this.findViewById(R.id.recording_hint);
        this.voiceRecorder = new EaseVoiceRecorder(this.micImageHandler);
        this.micImages = new Drawable[]{this.getResources().getDrawable(R.drawable.ease_record_animate_01), this.getResources().getDrawable(R.drawable.ease_record_animate_02), this.getResources().getDrawable(R.drawable.ease_record_animate_03), this.getResources().getDrawable(R.drawable.ease_record_animate_04)};
        this.wakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(6, "demo");
    }

    public boolean onPressToSpeakBtnTouch(View v, MotionEvent event, EaseVoiceRecorderCallback recorderCallback) {
        switch (event.getAction()) {
            case 0: {
                try {
                    EaseChatRowVoicePlayer voicePlayer = EaseChatRowVoicePlayer.getInstance(this.context);
                    if (voicePlayer.isPlaying()) {
                        voicePlayer.stop();
                    }
                    v.setPressed(true);
                    this.setTextContent(v, true);
                    this.startRecording();
                }
                catch (Exception e) {
                    v.setPressed(false);
                }
                return true;
            }
            case 2: {
                if (event.getY() < EaseVoiceRecorderView.dip2px(this.getContext(), 10.0f)) {
                    this.setTextContent(v, false);
                    this.showReleaseToCancelHint();
                } else {
                    this.setTextContent(v, true);
                    this.showMoveUpToCancelHint();
                }
                return true;
            }
            case 1: {
                v.setPressed(false);
                this.setTextContent(v, false);
                if (event.getY() < 0.0f) {
                    this.discardRecording();
                } else {
                    try {
                        int length = this.stopRecoding();
                        if (length > 0) {
                            if (recorderCallback != null) {
                                recorderCallback.onVoiceRecordComplete(this.getVoiceFilePath(), length);
                            }
                        } else if (length == 401) {
                            Toast.makeText((Context)this.context, (int)R.string.Recording_without_permission, (int)0).show();
                        } else {
                            Toast.makeText((Context)this.context, (int)R.string.The_recording_time_is_too_short, (int)0).show();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Toast.makeText((Context)this.context, (int)R.string.send_failure_please, (int)0).show();
                    }
                }
                return true;
            }
        }
        this.discardRecording();
        return false;
    }

    private void setTextContent(View view, boolean pressed) {
        View child;
        if (view instanceof ViewGroup && ((ViewGroup)view).getChildCount() > 0 && (child = ((ViewGroup)view).getChildAt(0)) instanceof TextView) {
            ((TextView)child).setText((CharSequence)this.getContext().getString(pressed ? R.string.button_pushtotalk_pressed : R.string.button_pushtotalk));
        }
    }

    public void startRecording() {
        if (!EaseCommonUtils.isSdcardExist()) {
            Toast.makeText((Context)this.context, (int)R.string.Send_voice_need_sdcard_support, (int)0).show();
            return;
        }
        try {
            this.wakeLock.acquire();
            this.setVisibility(0);
            this.recordingHint.setText((CharSequence)this.context.getString(R.string.move_up_to_cancel));
            this.recordingHint.setBackgroundColor(0);
            this.ivIcon.setImageResource(R.drawable.ease_record_icon);
            this.micImage.setVisibility(0);
            this.voiceRecorder.startRecording(this.context);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.wakeLock.isHeld()) {
                this.wakeLock.release();
            }
            if (this.voiceRecorder != null) {
                this.voiceRecorder.discardRecording();
            }
            this.setVisibility(4);
            Toast.makeText((Context)this.context, (int)R.string.recoding_fail, (int)0).show();
            return;
        }
    }

    public void showReleaseToCancelHint() {
        this.recordingHint.setText((CharSequence)this.context.getString(R.string.release_to_cancel));
        this.ivIcon.setImageResource(R.drawable.ease_record_cancel);
        this.micImage.setVisibility(8);
    }

    public void showMoveUpToCancelHint() {
        this.recordingHint.setText((CharSequence)this.context.getString(R.string.move_up_to_cancel));
        this.recordingHint.setBackgroundColor(0);
        this.ivIcon.setImageResource(R.drawable.ease_record_icon);
        this.micImage.setVisibility(0);
    }

    public void discardRecording() {
        if (this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
        try {
            if (this.voiceRecorder.isRecording()) {
                this.voiceRecorder.discardRecording();
                this.setVisibility(4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int stopRecoding() {
        this.setVisibility(4);
        if (this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
        return this.voiceRecorder.stopRecoding();
    }

    public String getVoiceFilePath() {
        return this.voiceRecorder.getVoiceFilePath();
    }

    public String getVoiceFileName() {
        return this.voiceRecorder.getVoiceFileName();
    }

    public boolean isRecording() {
        return this.voiceRecorder.isRecording();
    }

    public static float dip2px(Context context, float value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static interface EaseVoiceRecorderCallback {
        public void onVoiceRecordComplete(String var1, int var2);
    }
}

