/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import com.hyphenate.easeui.R;

public class EaseTitleBar
extends RelativeLayout
implements View.OnClickListener {
    private Context context;
    private Toolbar toolbar;
    protected RelativeLayout leftLayout;
    protected ImageView leftImage;
    protected RelativeLayout rightLayout;
    protected ImageView rightImage;
    protected TextView titleView;
    protected RelativeLayout titleLayout;
    private TextView titleMenu;
    private OnBackPressListener mBackPressListener;
    private OnRightClickListener mOnRightClickListener;
    private int mArrowColorId;
    private int mArrowColor;
    private int mTitleTextColor;
    private int mWidth;
    private int mHeight;
    private boolean mDisplayHomeAsUpEnabled;

    public EaseTitleBar(Context context) {
        this(context, null);
    }

    public EaseTitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseTitleBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.init(context, attrs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.initLayout();
    }

    private void initLayout() {
        ViewGroup.LayoutParams params = this.titleLayout.getLayoutParams();
        params.height = this.mHeight;
        params.width = this.mWidth;
        this.requestLayout();
    }

    private void init(Context context, AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.ease_widget_title_bar, (ViewGroup)this);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.leftLayout = (RelativeLayout)this.findViewById(R.id.left_layout);
        this.leftImage = (ImageView)this.findViewById(R.id.left_image);
        this.rightLayout = (RelativeLayout)this.findViewById(R.id.right_layout);
        this.rightImage = (ImageView)this.findViewById(R.id.right_image);
        this.titleView = (TextView)this.findViewById(R.id.title);
        this.titleLayout = (RelativeLayout)this.findViewById(R.id.root);
        this.titleMenu = (TextView)this.findViewById(R.id.right_menu);
        this.parseStyle(context, attrs);
        this.initToolbar();
    }

    private void parseStyle(Context context, AttributeSet attrs) {
        if (attrs != null) {
            int rightTitleId;
            Drawable rightDrawable;
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.EaseTitleBar);
            int titleId = ta.getResourceId(R.styleable.EaseTitleBar_titleBarTitle, -1);
            if (titleId != -1) {
                this.titleView.setText(titleId);
            } else {
                String title = ta.getString(R.styleable.EaseTitleBar_titleBarTitle);
                this.titleView.setText((CharSequence)title);
            }
            Drawable leftDrawable = ta.getDrawable(R.styleable.EaseTitleBar_titleBarLeftImage);
            if (null != leftDrawable) {
                this.leftImage.setImageDrawable(leftDrawable);
            }
            if (null != (rightDrawable = ta.getDrawable(R.styleable.EaseTitleBar_titleBarRightImage))) {
                this.rightImage.setImageDrawable(rightDrawable);
            }
            this.mArrowColorId = ta.getResourceId(R.styleable.EaseTitleBar_titleBarArrowColor, -1);
            this.mArrowColor = ta.getColor(R.styleable.EaseTitleBar_titleBarArrowColor, -16777216);
            Drawable menuDrawable = ta.getDrawable(R.styleable.EaseTitleBar_titleBarMenuResource);
            if (menuDrawable != null) {
                this.toolbar.setOverflowIcon(menuDrawable);
            }
            if ((rightTitleId = ta.getResourceId(R.styleable.EaseTitleBar_titleBarRightTitle, -1)) != -1) {
                this.titleMenu.setText(rightTitleId);
            } else {
                String rightTitle = ta.getString(R.styleable.EaseTitleBar_titleBarRightTitle);
                this.titleMenu.setText((CharSequence)rightTitle);
            }
            boolean rightVisible = ta.getBoolean(R.styleable.EaseTitleBar_titleBarRightVisible, false);
            this.rightLayout.setVisibility(rightVisible ? 0 : 8);
            this.mDisplayHomeAsUpEnabled = ta.getBoolean(R.styleable.EaseTitleBar_titleBarDisplayHomeAsUpEnabled, true);
            int titlePosition = ta.getInteger(R.styleable.EaseTitleBar_titleBarTitlePosition, 0);
            this.setTitlePosition(titlePosition);
            float titleTextSize = ta.getDimension(R.styleable.EaseTitleBar_titleBarTitleTextSize, (float)((int)EaseTitleBar.sp2px(this.getContext(), 18.0f)));
            this.titleView.setTextSize(0, titleTextSize);
            int titleTextColor = ta.getResourceId(R.styleable.EaseTitleBar_titleBarTitleTextColor, -1);
            this.mTitleTextColor = titleTextColor != -1 ? ContextCompat.getColor((Context)this.getContext(), (int)titleTextColor) : ta.getColor(R.styleable.EaseTitleBar_titleBarTitleTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.em_toolbar_color_title));
            this.titleView.setTextColor(this.mTitleTextColor);
            ta.recycle();
        }
    }

    private void setTitlePosition(int titlePosition) {
        ViewGroup.LayoutParams params = this.titleView.getLayoutParams();
        if (params instanceof RelativeLayout.LayoutParams) {
            if (titlePosition == 0) {
                ((RelativeLayout.LayoutParams)params).addRule(13);
            } else if (titlePosition == 1) {
                ((RelativeLayout.LayoutParams)params).addRule(9);
                ((RelativeLayout.LayoutParams)params).addRule(15);
                ((RelativeLayout.LayoutParams)params).addRule(1, this.leftLayout.getId());
            } else {
                ((RelativeLayout.LayoutParams)params).addRule(11);
                ((RelativeLayout.LayoutParams)params).addRule(15);
                ((RelativeLayout.LayoutParams)params).addRule(0, this.rightLayout.getId());
                ((RelativeLayout.LayoutParams)params).setMargins(0, 0, (int)EaseTitleBar.dip2px(this.getContext(), 60.0f), 0);
            }
        }
    }

    private void initToolbar() {
        this.rightLayout.setOnClickListener((View.OnClickListener)this);
        if (this.leftImage.getDrawable() != null) {
            this.leftImage.setVisibility(this.mDisplayHomeAsUpEnabled ? 0 : 8);
            this.leftLayout.setOnClickListener((View.OnClickListener)this);
        } else if (this.getContext() instanceof AppCompatActivity) {
            AppCompatActivity activity = (AppCompatActivity)this.getContext();
            activity.setSupportActionBar(this.toolbar);
            if (activity.getSupportActionBar() != null) {
                activity.getSupportActionBar().setDisplayHomeAsUpEnabled(this.mDisplayHomeAsUpEnabled);
                activity.getSupportActionBar().setDisplayShowTitleEnabled(false);
            }
            this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (EaseTitleBar.this.mBackPressListener != null) {
                        EaseTitleBar.this.mBackPressListener.onBackPress(v);
                    }
                }
            });
            if (this.mArrowColorId != -1) {
                this.setToolbarCustomColor(this.mArrowColorId);
            } else {
                this.setToolbarCustomColorDefault(this.mArrowColor);
            }
        }
    }

    public void setToolbarCustomColor(@ColorRes int colorId) {
        this.setToolbarCustomColorDefault(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
    }

    public void setToolbarCustomColorDefault(@ColorInt int colorId) {
        Drawable leftArrow = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.abc_ic_ab_back_material);
        if (leftArrow != null) {
            leftArrow.setColorFilter(colorId, PorterDuff.Mode.SRC_ATOP);
            if (this.getContext() instanceof AppCompatActivity && ((AppCompatActivity)this.getContext()).getSupportActionBar() != null) {
                ((AppCompatActivity)this.getContext()).getSupportActionBar().setHomeAsUpIndicator(leftArrow);
            }
        }
    }

    public void setLeftImageResource(int resId) {
        this.leftImage.setImageResource(resId);
    }

    public void setRightImageResource(int resId) {
        this.rightImage.setImageResource(resId);
        this.rightLayout.setVisibility(0);
    }

    public void setRightTitleResource(@StringRes int title) {
        this.titleMenu.setText((CharSequence)this.getResources().getString(title));
        this.rightLayout.setVisibility(0);
    }

    public void setRightTitle(String title) {
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.titleMenu.setText((CharSequence)title);
            this.rightLayout.setVisibility(0);
        }
    }

    public void setTitlePosition(TitlePosition position) {
        int pos = position == TitlePosition.Center ? 0 : (position == TitlePosition.Left ? 1 : 2);
        this.setTitlePosition(pos);
    }

    public void setLeftLayoutClickListener(View.OnClickListener listener) {
        this.leftLayout.setOnClickListener(listener);
    }

    public void setRightLayoutClickListener(View.OnClickListener listener) {
        this.rightLayout.setOnClickListener(listener);
    }

    public void setLeftLayoutVisibility(int visibility) {
        this.leftLayout.setVisibility(visibility);
    }

    public void setRightLayoutVisibility(int visibility) {
        this.rightLayout.setVisibility(visibility);
    }

    public void setTitle(String title) {
        this.titleView.setText((CharSequence)title);
    }

    public TextView getTitle() {
        return this.titleView;
    }

    public void setBackgroundColor(int color2) {
        this.titleLayout.setBackgroundColor(color2);
    }

    public RelativeLayout getLeftLayout() {
        return this.leftLayout;
    }

    public RelativeLayout getRightLayout() {
        return this.rightLayout;
    }

    public ImageView getRightImage() {
        return this.rightImage;
    }

    public TextView getRightText() {
        return this.titleMenu;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.left_layout) {
            if (this.mBackPressListener != null) {
                this.mBackPressListener.onBackPress(v);
            }
        } else if (v.getId() == R.id.right_layout && this.mOnRightClickListener != null) {
            this.mOnRightClickListener.onRightClick(v);
        }
    }

    public void setOnBackPressListener(OnBackPressListener listener) {
        this.mBackPressListener = listener;
    }

    public void setOnRightClickListener(OnRightClickListener listener) {
        this.mOnRightClickListener = listener;
    }

    public static float dip2px(Context context, float value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float sp2px(Context context, float value) {
        return TypedValue.applyDimension((int)2, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static enum TitlePosition {
        Center,
        Left,
        Right;

    }

    public static interface OnRightClickListener {
        public void onRightClick(View var1);
    }

    public static interface OnBackPressListener {
        public void onBackPress(View var1);
    }
}

