/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.hyphenate.easeui.R;
import java.lang.reflect.Method;

public class EaseRoundImageView
extends AppCompatImageView {
    private Context context;
    private Paint paint;
    private int roundWidth = 20;
    private int roundHeight = 20;
    private Paint paint2;

    public EaseRoundImageView(Context context) {
        this(context, null);
    }

    public EaseRoundImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseRoundImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        if (attrs != null) {
            TypedArray array2 = context.obtainStyledAttributes(attrs, R.styleable.EaseRoundImageView);
            this.roundWidth = array2.getDimensionPixelSize(R.styleable.EaseRoundImageView_roundWidth, this.roundWidth);
            this.roundHeight = array2.getDimensionPixelSize(R.styleable.EaseRoundImageView_roundHeight, this.roundHeight);
            array2.recycle();
        }
        this.paint = new Paint();
        this.paint.setColor(-1);
        this.paint.setAntiAlias(true);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        this.paint = new Paint();
        this.paint.setColor(-1);
        this.paint.setAntiAlias(true);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        this.paint2 = new Paint();
        this.paint2.setXfermode(null);
    }

    protected void onDraw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        super.draw(canvas2);
        this.drawLiftUp(canvas2);
        this.drawLiftDown(canvas2);
        this.drawRightUp(canvas2);
        this.drawRightDown(canvas2);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.paint2);
        bitmap.recycle();
    }

    private void drawLiftUp(Canvas canvas) {
        Path path = new Path();
        path.moveTo(0.0f, (float)this.roundHeight);
        path.lineTo(0.0f, 0.0f);
        path.lineTo((float)this.roundWidth, 0.0f);
        path.arcTo(new RectF(0.0f, 0.0f, (float)(this.roundWidth * 2), (float)(this.roundHeight * 2)), -90.0f, -90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }

    private void drawLiftDown(Canvas canvas) {
        Path path = new Path();
        path.moveTo(0.0f, (float)(this.getHeight() - this.roundHeight));
        path.lineTo(0.0f, (float)this.getHeight());
        path.lineTo((float)this.roundWidth, (float)this.getHeight());
        path.arcTo(new RectF(0.0f, (float)(this.getHeight() - this.roundHeight * 2), (float)(this.roundWidth * 2), (float)this.getHeight()), 90.0f, 90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }

    private void drawRightDown(Canvas canvas) {
        Path path = new Path();
        path.moveTo((float)(this.getWidth() - this.roundWidth), (float)this.getHeight());
        path.lineTo((float)this.getWidth(), (float)this.getHeight());
        path.lineTo((float)this.getWidth(), (float)(this.getHeight() - this.roundHeight));
        path.arcTo(new RectF((float)(this.getWidth() - this.roundWidth * 2), (float)(this.getHeight() - this.roundHeight * 2), (float)this.getWidth(), (float)this.getHeight()), 0.0f, 90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }

    private void drawRightUp(Canvas canvas) {
        Path path = new Path();
        path.moveTo((float)this.getWidth(), (float)this.roundHeight);
        path.lineTo((float)this.getWidth(), 0.0f);
        path.lineTo((float)(this.getWidth() - this.roundWidth), 0.0f);
        path.arcTo(new RectF((float)(this.getWidth() - this.roundWidth * 2), 0.0f, (float)this.getWidth(), (float)(0 + this.roundHeight * 2)), -90.0f, 90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }

    public static class CanvasLegacy {
        static final int MATRIX_SAVE_FLAG;
        static final int CLIP_SAVE_FLAG;
        static final int HAS_ALPHA_LAYER_SAVE_FLAG;
        static final int FULL_COLOR_LAYER_SAVE_FLAG;
        static final int CLIP_TO_LAYER_SAVE_FLAG;
        private static final Method SAVE;

        static void saveLayer(Canvas canvas, float left, float top, float right, float bottom, @Nullable Paint paint, int saveFlags) {
            try {
                SAVE.invoke((Object)canvas, Float.valueOf(left), Float.valueOf(top), Float.valueOf(right), Float.valueOf(bottom), paint, saveFlags);
            }
            catch (Throwable e) {
                throw CanvasLegacy.sneakyThrow(e);
            }
        }

        private static RuntimeException sneakyThrow(Throwable t) {
            if (t == null) {
                throw new NullPointerException("t");
            }
            return (RuntimeException)CanvasLegacy.sneakyThrow0(t);
        }

        private static <T extends Throwable> T sneakyThrow0(Throwable t) throws T {
            throw t;
        }

        static {
            try {
                MATRIX_SAVE_FLAG = (Integer)Canvas.class.getField("MATRIX_SAVE_FLAG").get(null);
                CLIP_SAVE_FLAG = (Integer)Canvas.class.getField("CLIP_SAVE_FLAG").get(null);
                HAS_ALPHA_LAYER_SAVE_FLAG = (Integer)Canvas.class.getField("HAS_ALPHA_LAYER_SAVE_FLAG").get(null);
                FULL_COLOR_LAYER_SAVE_FLAG = (Integer)Canvas.class.getField("FULL_COLOR_LAYER_SAVE_FLAG").get(null);
                CLIP_TO_LAYER_SAVE_FLAG = (Integer)Canvas.class.getField("CLIP_TO_LAYER_SAVE_FLAG").get(null);
                SAVE = Canvas.class.getMethod("saveLayer", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Paint.class, Integer.TYPE);
            }
            catch (Throwable e) {
                throw CanvasLegacy.sneakyThrow(e);
            }
        }
    }
}

