/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.UriUtils;
import com.hyphenate.util.VersionUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class EaseFileUtils {
    private static final String TAG = EaseFileUtils.class.getSimpleName();

    public static void deleteFile(Context context, Uri uri) {
        if (UriUtils.isFileExistByUri((Context)context, (Uri)uri)) {
            String filePath = EaseFileUtils.getFilePath(context, uri);
            if (!TextUtils.isEmpty((CharSequence)filePath)) {
                File file = new File(filePath);
                if (file != null && file.exists() && file.isFile()) {
                    file.delete();
                }
            } else {
                try {
                    context.getContentResolver().delete(uri, null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getFileNameByUri(Context context, Uri fileUri) {
        if (fileUri == null) {
            return "";
        }
        if (!VersionUtils.isTargetQ((Context)context)) {
            String filePath = EaseFileUtils.getFilePath(context, fileUri);
            if (!TextUtils.isEmpty((CharSequence)filePath) && new File(filePath).exists()) {
                return new File(filePath).getName();
            }
            return "";
        }
        if (EaseFileUtils.uriStartWithFile(fileUri)) {
            File file = new File(fileUri.getPath());
            return file.exists() ? file.getName() : "";
        }
        if (!EaseFileUtils.uriStartWithContent(fileUri)) {
            if (fileUri.toString().startsWith("/") && new File(fileUri.toString()).exists()) {
                return new File(fileUri.toString()).getName();
            }
            return "";
        }
        return UriUtils.getFilenameByDocument((Context)context, (Uri)fileUri);
    }

    public static String getFilePath(Context context, Uri uri) {
        boolean isKitKat;
        if (uri == null) {
            return "";
        }
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (!VersionUtils.isTargetQ((Context)context)) {
            if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
                if (EaseFileUtils.isExternalStorageDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    if ("primary".equalsIgnoreCase(type)) {
                        return Environment.getExternalStorageDirectory() + "/" + split[1];
                    }
                } else {
                    if (EaseFileUtils.isDownloadsDocument(uri)) {
                        String id2 = DocumentsContract.getDocumentId((Uri)uri);
                        Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                        return EaseFileUtils.getDataColumn(context, contentUri, null, null);
                    }
                    if (EaseFileUtils.isMediaDocument(uri)) {
                        String docId = DocumentsContract.getDocumentId((Uri)uri);
                        String[] split = docId.split(":");
                        String type = split[0];
                        Uri contentUri = null;
                        if ("image".equals(type)) {
                            contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        } else if ("video".equals(type)) {
                            contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        } else if ("audio".equals(type)) {
                            contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                        }
                        String selection = "_id=?";
                        String[] selectionArgs = new String[]{split[1]};
                        return EaseFileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                    }
                }
            } else {
                if (EaseFileUtils.isFileProvider(context, uri)) {
                    return EaseFileUtils.getFPUriToPath(context, uri);
                }
                if (EaseFileUtils.isOtherFileProvider(context, uri)) {
                    return EaseFileUtils.copyFileProviderUri(context, uri);
                }
                if (EaseFileUtils.uriStartWithContent(uri)) {
                    return EaseFileUtils.getDataColumn(context, uri, null, null);
                }
                if (EaseFileUtils.uriStartWithFile(uri)) {
                    return uri.getPath();
                }
                if (uri.toString().startsWith("/")) {
                    return uri.toString();
                }
            }
        } else {
            if (EaseFileUtils.uriStartWithFile(uri)) {
                return uri.getPath();
            }
            if (uri.toString().startsWith("/")) {
                return uri.toString();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String copyFileProviderUri(Context context, Uri uri) {
        String[] subs = uri.toString().split("/");
        String filename = null;
        if (subs.length <= 0) {
            return "";
        }
        filename = subs[subs.length - 1];
        String filePath = PathUtil.getInstance().getFilePath() + File.separator + filename;
        if (new File(filePath).exists()) {
            return filePath;
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            in = context.getContentResolver().openInputStream(uri);
            out = new FileOutputStream(filePath);
            EaseFileUtils.copy(in, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new File(filePath).exists() ? filePath : "";
    }

    public static long copy(@NonNull InputStream in, @NonNull OutputStream out) {
        long sum = 0L;
        try {
            int l;
            byte[] tmp = new byte[2048];
            while ((l = in.read(tmp)) != -1) {
                out.write(tmp, 0, l);
                sum += (long)l;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sum;
    }

    public static boolean uriStartWithFile(Uri fileUri) {
        return "file".equalsIgnoreCase(fileUri.getScheme()) && fileUri.toString().length() > 7;
    }

    public static boolean uriStartWithContent(Uri fileUri) {
        return "content".equalsIgnoreCase(fileUri.getScheme());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    private static String getFPUriToPath(Context context, Uri uri) {
        try {
            List packs = context.getPackageManager().getInstalledPackages(8);
            if (packs != null) {
                String fileProviderClassName = FileProvider.class.getName();
                block7: for (PackageInfo pack : packs) {
                    ProviderInfo[] providers = pack.providers;
                    if (providers == null) continue;
                    for (ProviderInfo provider : providers) {
                        if (!uri.getAuthority().equals(provider.authority)) continue;
                        if (!provider.name.equalsIgnoreCase(fileProviderClassName)) continue block7;
                        Class<FileProvider> fileProviderClass = FileProvider.class;
                        try {
                            Method getPathStrategy = fileProviderClass.getDeclaredMethod("getPathStrategy", Context.class, String.class);
                            getPathStrategy.setAccessible(true);
                            Object invoke = getPathStrategy.invoke(null, context, uri.getAuthority());
                            if (invoke == null) continue block7;
                            String PathStrategyStringClass = FileProvider.class.getName() + "$PathStrategy";
                            Class<?> PathStrategy = Class.forName(PathStrategyStringClass);
                            Method getFileForUri = PathStrategy.getDeclaredMethod("getFileForUri", Uri.class);
                            getFileForUri.setAccessible(true);
                            Object invoke1 = getFileForUri.invoke(invoke, uri);
                            if (!(invoke1 instanceof File)) continue block7;
                            String filePath = ((File)invoke1).getAbsolutePath();
                            return filePath;
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                            continue block7;
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                            continue block7;
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                            continue block7;
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                            continue block7;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isFileProvider(Context context, Uri uri) {
        return (context.getApplicationInfo().packageName + ".fileProvider").equalsIgnoreCase(uri.getAuthority());
    }

    public static boolean isOtherFileProvider(Context context, Uri uri) {
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        if (TextUtils.isEmpty((CharSequence)scheme) || TextUtils.isEmpty((CharSequence)authority)) {
            return false;
        }
        return !(context.getApplicationInfo().packageName + ".fileProvider").equalsIgnoreCase(uri.getAuthority()) && "content".equalsIgnoreCase(uri.getScheme()) && authority.contains(".fileProvider".toLowerCase());
    }
}

