/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.widget.EditText;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.hyphenate.easeui.R;
import com.hyphenate.util.EMLog;

public class EaseEditTextUtils {
    public static void changePwdDrawableRight(EditText editText, Drawable eyeOpen, Drawable eyeClose, Drawable left, Drawable top, Drawable bottom) {
        boolean[] canBeSeen = new boolean[]{false};
        editText.setOnTouchListener((v, event) -> {
            Drawable drawable2 = editText.getCompoundDrawables()[2];
            if (drawable2 == null) {
                return false;
            }
            if (event.getAction() != 1) {
                return false;
            }
            if (event.getX() > (float)(editText.getWidth() - editText.getPaddingRight() - drawable2.getIntrinsicWidth())) {
                if (canBeSeen[0]) {
                    editText.setInputType(129);
                    editText.setCompoundDrawablesWithIntrinsicBounds(left, top, eyeOpen, bottom);
                    canBeSeen[0] = false;
                } else {
                    editText.setInputType(1);
                    editText.setCompoundDrawablesWithIntrinsicBounds(left, top, eyeClose, bottom);
                    canBeSeen[0] = true;
                }
                editText.setSelection(editText.getText().toString().length());
                editText.setFocusable(true);
                editText.setFocusableInTouchMode(true);
                editText.requestFocus();
                return true;
            }
            return false;
        });
    }

    public static void showRightDrawable(EditText editText, Drawable right) {
        String content = editText.getText().toString().trim();
        editText.setCompoundDrawablesWithIntrinsicBounds(null, null, TextUtils.isEmpty((CharSequence)content) ? null : right, null);
    }

    public static void clearEditTextListener(EditText editText) {
        editText.setOnTouchListener((v, event) -> {
            Drawable drawable2 = editText.getCompoundDrawables()[2];
            if (drawable2 == null) {
                return false;
            }
            if (event.getAction() != 1) {
                return false;
            }
            if (event.getX() > (float)(editText.getWidth() - editText.getPaddingRight() - drawable2.getIntrinsicWidth())) {
                editText.setText((CharSequence)"");
                return true;
            }
            return false;
        });
    }

    public static String ellipsizeString(TextView textView, String str, String keyword, int width) {
        if (TextUtils.isEmpty((CharSequence)keyword)) {
            return str;
        }
        TextPaint paint = textView.getPaint();
        if (paint.measureText(str) < (float)width) {
            return str;
        }
        int count = paint.breakText((CharSequence)str, 0, str.length(), true, (float)width, null);
        int index = str.indexOf(keyword);
        if (index + keyword.length() < count) {
            return str;
        }
        if (str.length() - index <= count - 3) {
            String end = str.substring(str.length() - count);
            end = "..." + end.substring(3);
            return end;
        }
        int subCount = (count - keyword.length()) / 2;
        String middle = str.substring(index - subCount, index + keyword.length() + subCount);
        middle = "..." + middle.substring(3);
        middle = middle.substring(0, middle.length() - 3) + "...";
        return middle;
    }

    public static SpannableStringBuilder highLightKeyword(Context context, String str, String keyword) {
        if (TextUtils.isEmpty((CharSequence)str) || TextUtils.isEmpty((CharSequence)keyword) || !str.contains(keyword)) {
            return null;
        }
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)str);
        builder.setSpan((Object)new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.em_color_brand)), str.indexOf(keyword), str.indexOf(keyword) + keyword.length(), 33);
        return builder;
    }

    public static String ellipsizeMiddleString(TextView textView, String str, int num, int width) {
        textView.setMaxLines(num);
        textView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
        TextPaint paint = textView.getPaint();
        if (TextUtils.isEmpty((CharSequence)str) || width <= 0 || paint.measureText(str) < (float)width) {
            return str;
        }
        int startIndex = 0;
        int maxNum = 0;
        for (int i = 0; i < num; ++i) {
            if (startIndex >= str.length()) continue;
            startIndex = (maxNum += paint.breakText((CharSequence)str, startIndex, str.length(), true, (float)width, null)) - 1;
        }
        if (str.length() < maxNum) {
            return str;
        }
        int maxCount = 0;
        try {
            maxCount = textView.getLayout().getLineEnd(num - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
        if (str.length() < maxCount) {
            return str;
        }
        if (str.contains(".")) {
            int lastIndex = str.lastIndexOf(".");
            String suffix = "..." + str.substring(lastIndex - 5);
            float requestWidth = paint.measureText(suffix);
            String reverse = new StringBuilder(str.substring(0, maxCount)).reverse().toString();
            int takeUpCount = paint.breakText((CharSequence)reverse, 0, reverse.length(), true, requestWidth, null);
            takeUpCount = EaseEditTextUtils.getTakeUpCount((Paint)paint, reverse, takeUpCount, requestWidth);
            str = str.substring(0, maxCount - takeUpCount) + suffix;
            EMLog.i((String)"EaseEditTextUtils", (String)("last str = " + str));
        }
        return str;
    }

    private static int getTakeUpCount(Paint paint, String reverse, int takeUpCount, float requestWidth) {
        float measureWidth = paint.measureText(reverse.substring(0, takeUpCount));
        if (measureWidth <= requestWidth) {
            return EaseEditTextUtils.getTakeUpCount(paint, reverse, takeUpCount + 1, requestWidth);
        }
        return takeUpCount + 1;
    }
}

