/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.WindowManager;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.HanziToPinyin;
import java.util.ArrayList;
import java.util.List;

public class EaseCommonUtils {
    private static final String TAG = "CommonUtils";

    public static boolean isNetWorkConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mNetworkInfo;
        if (context != null && (mNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            return mNetworkInfo.isAvailable() && mNetworkInfo.isConnected();
        }
        return false;
    }

    public static boolean isSdcardExist() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static EMMessage createExpressionMessage(String toChatUsername, String expressioName, String identityCode) {
        EMMessage message = EMMessage.createTxtSendMessage((String)("[" + expressioName + "]"), (String)toChatUsername);
        if (identityCode != null) {
            message.setAttribute("em_expression_id", identityCode);
        }
        message.setAttribute("em_is_big_expression", true);
        return message;
    }

    public static String getMessageDigest(EMMessage message, Context context) {
        String digest = "";
        switch (message.getType()) {
            case LOCATION: {
                if (message.direct() == EMMessage.Direct.RECEIVE) {
                    digest = EaseCommonUtils.getString(context, R.string.location_recv);
                    digest = String.format(digest, message.getFrom());
                    return digest;
                }
                digest = EaseCommonUtils.getString(context, R.string.location_prefix);
                break;
            }
            case IMAGE: {
                digest = EaseCommonUtils.getString(context, R.string.picture);
                break;
            }
            case VOICE: {
                digest = EaseCommonUtils.getString(context, R.string.voice_prefix);
                break;
            }
            case VIDEO: {
                digest = EaseCommonUtils.getString(context, R.string.video);
                break;
            }
            case CUSTOM: {
                digest = EaseCommonUtils.getString(context, R.string.custom);
                break;
            }
            case TXT: {
                EMTextMessageBody txtBody = (EMTextMessageBody)message.getBody();
                if (message.getBooleanAttribute("is_voice_call", false)) {
                    digest = EaseCommonUtils.getString(context, R.string.voice_call) + txtBody.getMessage();
                    break;
                }
                if (message.getBooleanAttribute("is_video_call", false)) {
                    digest = EaseCommonUtils.getString(context, R.string.video_call) + txtBody.getMessage();
                    break;
                }
                if (message.getBooleanAttribute("em_is_big_expression", false)) {
                    if (!TextUtils.isEmpty((CharSequence)txtBody.getMessage())) {
                        digest = txtBody.getMessage();
                        break;
                    }
                    digest = EaseCommonUtils.getString(context, R.string.dynamic_expression);
                    break;
                }
                digest = txtBody.getMessage();
                break;
            }
            case FILE: {
                digest = EaseCommonUtils.getString(context, R.string.file);
                break;
            }
            default: {
                EMLog.e((String)TAG, (String)"error, unknow type");
                return "";
            }
        }
        Log.e((String)"TAG", (String)("message text = " + digest));
        return digest;
    }

    static String getString(Context context, int resId) {
        return context.getResources().getString(resId);
    }

    public static String getTopActivity(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List runningTaskInfos = manager.getRunningTasks(1);
        if (runningTaskInfos != null) {
            return ((ActivityManager.RunningTaskInfo)runningTaskInfos.get((int)0)).topActivity.getClassName();
        }
        return "";
    }

    public static void setUserInitialLetter(EaseUser user) {
        final class GetInitialLetter {
            GetInitialLetter() {
            }

            String getLetter(String name) {
                if (TextUtils.isEmpty((CharSequence)name)) {
                    return "#";
                }
                char char0 = name.toLowerCase().charAt(0);
                if (Character.isDigit(char0)) {
                    return "#";
                }
                ArrayList l = HanziToPinyin.getInstance().get(name.substring(0, 1));
                if (l != null && l.size() > 0 && ((HanziToPinyin.Token)l.get((int)0)).target.length() > 0) {
                    HanziToPinyin.Token token = (HanziToPinyin.Token)l.get(0);
                    String letter = token.target.substring(0, 1).toUpperCase();
                    char c = letter.charAt(0);
                    if (c < 'A' || c > 'Z') {
                        return "#";
                    }
                    return letter;
                }
                return "#";
            }
        }
        String DefaultLetter = "#";
        String letter = "#";
        if (!TextUtils.isEmpty((CharSequence)user.getNickname())) {
            letter = new GetInitialLetter().getLetter(user.getNickname());
            user.setInitialLetter(letter);
            return;
        }
        if (letter.equals("#") && !TextUtils.isEmpty((CharSequence)user.getUsername())) {
            letter = new GetInitialLetter().getLetter(user.getUsername());
        }
        user.setInitialLetter(letter);
    }

    public static EMConversation.EMConversationType getConversationType(int chatType) {
        if (chatType == 1) {
            return EMConversation.EMConversationType.Chat;
        }
        if (chatType == 2) {
            return EMConversation.EMConversationType.GroupChat;
        }
        return EMConversation.EMConversationType.ChatRoom;
    }

    public static int getChatType(EMConversation conversation) {
        if (conversation.isGroup()) {
            if (conversation.getType() == EMConversation.EMConversationType.ChatRoom) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public static boolean isSilentMessage(EMMessage message) {
        return message.getBooleanAttribute("em_ignore_notification", false);
    }

    public static float[] getScreenInfo(Context context) {
        WindowManager manager = (WindowManager)context.getSystemService("window");
        float[] info = new float[5];
        if (manager != null) {
            DisplayMetrics dm = new DisplayMetrics();
            manager.getDefaultDisplay().getMetrics(dm);
            info[0] = dm.widthPixels;
            info[1] = dm.heightPixels;
            info[2] = dm.densityDpi;
            info[3] = dm.density;
            info[4] = dm.scaledDensity;
        }
        return info;
    }

    public static float dip2px(Context context, float value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float sp2px(Context context, float value) {
        return TypedValue.applyDimension((int)2, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static boolean isTimestamp(String time) {
        if (TextUtils.isEmpty((CharSequence)time)) {
            return false;
        }
        long timestamp = 0L;
        try {
            timestamp = Long.parseLong(time);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return timestamp > 0L;
    }

    public static String getLetter(String name) {
        return new GetInitialLetter().getLetter(name);
    }

    private static class GetInitialLetter {
        private String defaultLetter = "#";

        private GetInitialLetter() {
        }

        public String getLetter(String name) {
            if (TextUtils.isEmpty((CharSequence)name)) {
                return this.defaultLetter;
            }
            char char0 = name.toLowerCase().charAt(0);
            if (Character.isDigit(char0)) {
                return this.defaultLetter;
            }
            ArrayList l = HanziToPinyin.getInstance().get(name.substring(0, 1));
            if (l != null && !l.isEmpty() && ((HanziToPinyin.Token)l.get((int)0)).target.length() > 0) {
                HanziToPinyin.Token token = (HanziToPinyin.Token)l.get(0);
                String letter = token.target.substring(0, 1).toUpperCase();
                char c = letter.charAt(0);
                if (c < 'A' || c > 'Z') {
                    return this.defaultLetter;
                }
                return letter;
            }
            return this.defaultLetter;
        }
    }
}

