/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.ui.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.ColorRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.utils.StatusBarCompat;

public class EaseBaseActivity
extends AppCompatActivity {
    protected InputMethodManager inputMethodManager;

    protected void onCreate(Bundle arg0) {
        super.onCreate(arg0);
        if (!this.isTaskRoot()) {
            Intent intent = this.getIntent();
            String action = intent.getAction();
            if (intent.hasCategory("android.intent.category.LAUNCHER") && action.equals("android.intent.action.MAIN")) {
                this.finish();
                return;
            }
        }
        this.inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
    }

    protected void onResume() {
        super.onResume();
    }

    protected void hideSoftKeyboard() {
        if (this.getWindow().getAttributes().softInputMode != 2 && this.getCurrentFocus() != null) {
            this.inputMethodManager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 2);
        }
    }

    public void back(View view) {
        this.finish();
    }

    public void setFitSystemForTheme(boolean fitSystemForTheme) {
        this.setFitSystemForTheme(fitSystemForTheme, R.color.white, true);
    }

    public void setFitSystemForTheme(boolean fitSystemForTheme, @ColorRes int colorId, boolean isDark) {
        this.setFitSystem(fitSystemForTheme);
        StatusBarCompat.compat((Activity)this, ContextCompat.getColor((Context)this, (int)colorId));
        StatusBarCompat.setLightStatusBar((Activity)this, isDark);
    }

    private void setFitSystem(boolean fitSystemForTheme) {
        ViewGroup contentFrameLayout;
        View parentView;
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            this.getWindow().addFlags(0x4000000);
        }
        if (fitSystemForTheme && (parentView = (contentFrameLayout = (ViewGroup)this.findViewById(0x1020002)).getChildAt(0)) != null && Build.VERSION.SDK_INT >= 14) {
            parentView.setFitsSystemWindows(true);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1280);
            window.addFlags(Integer.MIN_VALUE);
        }
    }
}

