/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.ui;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.player.EasyVideoCallback;
import com.hyphenate.easeui.player.EasyVideoPlayer;
import com.hyphenate.easeui.ui.base.EaseBaseActivity;

public class EaseShowLocalVideoActivity
extends EaseBaseActivity
implements EasyVideoCallback {
    private EasyVideoPlayer evpPlayer;
    private Uri uri;

    public static void actionStart(Context context, String path) {
        Intent intent = new Intent(context, EaseShowLocalVideoActivity.class);
        intent.putExtra("path", path);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle arg0) {
        super.onCreate(arg0);
        this.setContentView(R.layout.ease_activity_show_local_video);
        this.setFitSystemForTheme(false, R.color.transparent, false);
        this.initIntent(this.getIntent());
        this.initView();
        this.initListener();
        this.initData();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.initIntent(intent);
        if (this.uri != null) {
            this.evpPlayer.setSource(this.uri);
        }
    }

    public void initIntent(Intent intent) {
        String path = intent.getStringExtra("path");
        if (!TextUtils.isEmpty((CharSequence)path)) {
            this.uri = Uri.parse((String)path);
        }
        if (this.uri == null) {
            this.finish();
        }
    }

    public void initView() {
        this.evpPlayer = (EasyVideoPlayer)this.findViewById(R.id.evp_player);
    }

    public void initListener() {
        this.evpPlayer.setCallback(this);
    }

    public void initData() {
        this.evpPlayer.setAutoPlay(true);
        if (this.uri != null) {
            this.evpPlayer.setSource(this.uri);
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.evpPlayer != null) {
            this.evpPlayer.pause();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.evpPlayer != null) {
            this.evpPlayer.release();
            this.evpPlayer = null;
        }
    }

    @Override
    public void onStarted(EasyVideoPlayer player) {
    }

    @Override
    public void onPaused(EasyVideoPlayer player) {
    }

    @Override
    public void onPreparing(EasyVideoPlayer player) {
    }

    @Override
    public void onPrepared(EasyVideoPlayer player) {
    }

    @Override
    public void onBuffering(int percent) {
    }

    @Override
    public void onError(EasyVideoPlayer player, Exception e) {
    }

    @Override
    public void onCompletion(EasyVideoPlayer player) {
        this.finish();
    }

    @Override
    public void onClickVideoFrame(EasyVideoPlayer player) {
    }
}

