/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.player;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import androidx.annotation.AttrRes;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

class Util {
    Util() {
    }

    static String getDurationString(long durationMs, boolean negativePrefix) {
        return String.format(Locale.getDefault(), "%s%02d:%02d", negativePrefix ? "-" : "", TimeUnit.MILLISECONDS.toMinutes(durationMs), TimeUnit.MILLISECONDS.toSeconds(durationMs) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(durationMs)));
    }

    static boolean isColorDark(int color2) {
        double darkness = 1.0 - (0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2)) / 255.0;
        return darkness >= 0.5;
    }

    static int adjustAlpha(int color2, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color2) * factor);
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    static int resolveColor(Context context, @AttrRes int attr2) {
        return Util.resolveColor(context, attr2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int resolveColor(Context context, @AttrRes int attr2, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getColor(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }
}

