/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.conversation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.PopupMenu;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleObserver;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseAdapterDelegate;
import com.hyphenate.easeui.adapter.EaseBaseRecyclerViewAdapter;
import com.hyphenate.easeui.interfaces.OnItemClickListener;
import com.hyphenate.easeui.interfaces.OnItemLongClickListener;
import com.hyphenate.easeui.modules.EaseBaseLayout;
import com.hyphenate.easeui.modules.conversation.adapter.EaseConversationListAdapter;
import com.hyphenate.easeui.modules.conversation.delegate.EaseBaseConversationDelegate;
import com.hyphenate.easeui.modules.conversation.delegate.EaseConversationDelegate;
import com.hyphenate.easeui.modules.conversation.delegate.EaseSystemMsgDelegate;
import com.hyphenate.easeui.modules.conversation.interfaces.IConversationListLayout;
import com.hyphenate.easeui.modules.conversation.interfaces.IConversationStyle;
import com.hyphenate.easeui.modules.conversation.interfaces.OnConversationChangeListener;
import com.hyphenate.easeui.modules.conversation.interfaces.OnConversationLoadListener;
import com.hyphenate.easeui.modules.conversation.model.EaseConversationInfo;
import com.hyphenate.easeui.modules.conversation.model.EaseConversationSetStyle;
import com.hyphenate.easeui.modules.conversation.presenter.EaseConversationPresenter;
import com.hyphenate.easeui.modules.conversation.presenter.EaseConversationPresenterImpl;
import com.hyphenate.easeui.modules.conversation.presenter.IEaseConversationListView;
import com.hyphenate.easeui.modules.interfaces.IPopupMenu;
import com.hyphenate.easeui.modules.menu.EasePopupMenuHelper;
import com.hyphenate.easeui.modules.menu.OnPopupMenuDismissListener;
import com.hyphenate.easeui.modules.menu.OnPopupMenuItemClickListener;
import com.hyphenate.easeui.modules.menu.OnPopupMenuPreShowListener;
import com.hyphenate.easeui.widget.EaseImageView;
import com.hyphenate.easeui.widget.EaseRecyclerView;
import java.util.ArrayList;
import java.util.List;

public class EaseConversationListLayout
extends EaseBaseLayout
implements IConversationListLayout,
IConversationStyle,
IEaseConversationListView,
IPopupMenu {
    private EaseRecyclerView rvConversationList;
    private ConcatAdapter adapter;
    private EaseConversationListAdapter listAdapter;
    private OnItemClickListener itemListener;
    private OnItemLongClickListener itemLongListener;
    private OnPopupMenuItemClickListener popupMenuItemClickListener;
    private OnPopupMenuDismissListener dismissListener;
    private OnPopupMenuPreShowListener menuPreShowListener;
    private EaseConversationSetStyle setModel = new EaseConversationSetStyle();
    private EaseConversationPresenter presenter;
    private float touchX;
    private float touchY;
    private EasePopupMenuHelper menuHelper;
    private boolean showDefaultMenu = true;
    private OnConversationChangeListener conversationChangeListener;
    private OnConversationLoadListener loadListener;

    public EaseConversationListLayout(Context context) {
        this(context, null);
    }

    public EaseConversationListLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseConversationListLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.ease_conversation_list, (ViewGroup)this);
        this.presenter = new EaseConversationPresenterImpl();
        if (context instanceof AppCompatActivity) {
            ((AppCompatActivity)context).getLifecycle().addObserver((LifecycleObserver)this.presenter);
        }
        this.initAttrs(context, attrs);
        this.initViews();
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EaseConversationListLayout);
            float titleTextSize = a.getDimension(R.styleable.EaseConversationListLayout_ease_con_item_title_text_size, EaseConversationListLayout.sp2px(context, 16.0f));
            this.setModel.setTitleTextSize(titleTextSize);
            int titleTextColorRes = a.getResourceId(R.styleable.EaseConversationListLayout_ease_con_item_title_text_color, -1);
            int titleTextColor = titleTextColorRes != -1 ? ContextCompat.getColor((Context)context, (int)titleTextColorRes) : a.getColor(R.styleable.EaseConversationListLayout_ease_con_item_title_text_color, ContextCompat.getColor((Context)context, (int)R.color.ease_conversation_color_item_name));
            this.setModel.setTitleTextColor(titleTextColor);
            float contentTextSize = a.getDimension(R.styleable.EaseConversationListLayout_ease_con_item_content_text_size, EaseConversationListLayout.sp2px(context, 14.0f));
            this.setModel.setContentTextSize(contentTextSize);
            int contentTextColorRes = a.getResourceId(R.styleable.EaseConversationListLayout_ease_con_item_content_text_color, -1);
            int contentTextColor = contentTextColorRes != -1 ? ContextCompat.getColor((Context)context, (int)contentTextColorRes) : a.getColor(R.styleable.EaseConversationListLayout_ease_con_item_content_text_color, ContextCompat.getColor((Context)context, (int)R.color.ease_conversation_color_item_message));
            this.setModel.setContentTextColor(contentTextColor);
            float dateTextSize = a.getDimension(R.styleable.EaseConversationListLayout_ease_con_item_date_text_size, EaseConversationListLayout.sp2px(context, 13.0f));
            this.setModel.setDateTextSize(dateTextSize);
            int dateTextColorRes = a.getResourceId(R.styleable.EaseConversationListLayout_ease_con_item_date_text_color, -1);
            int dateTextColor = dateTextColorRes != -1 ? ContextCompat.getColor((Context)context, (int)dateTextColorRes) : a.getColor(R.styleable.EaseConversationListLayout_ease_con_item_date_text_color, ContextCompat.getColor((Context)context, (int)R.color.ease_conversation_color_item_time));
            this.setModel.setDateTextColor(dateTextColor);
            float mentionTextSize = a.getDimension(R.styleable.EaseConversationListLayout_ease_con_item_mention_text_size, EaseConversationListLayout.sp2px(context, 14.0f));
            this.setModel.setMentionTextSize(mentionTextSize);
            int mentionTextColorRes = a.getResourceId(R.styleable.EaseConversationListLayout_ease_con_item_mention_text_color, -1);
            int mentionTextColor = mentionTextColorRes != -1 ? ContextCompat.getColor((Context)context, (int)mentionTextColorRes) : a.getColor(R.styleable.EaseConversationListLayout_ease_con_item_mention_text_color, ContextCompat.getColor((Context)context, (int)R.color.ease_conversation_color_item_mention));
            this.setModel.setMentionTextColor(mentionTextColor);
            float avatarSize = a.getDimension(R.styleable.EaseConversationListLayout_ease_con_item_avatar_size, 0.0f);
            int shapeType = a.getInteger(R.styleable.EaseConversationListLayout_ease_con_item_avatar_shape_type, -1);
            float avatarRadius = a.getDimension(R.styleable.EaseConversationListLayout_ease_con_item_avatar_radius, EaseConversationListLayout.dip2px(context, 50.0f));
            float borderWidth = a.getDimension(R.styleable.EaseConversationListLayout_ease_con_item_avatar_border_width, 0.0f);
            int borderColorRes = a.getResourceId(R.styleable.EaseConversationListLayout_ease_con_item_avatar_border_color, -1);
            int borderColor = borderColorRes != -1 ? ContextCompat.getColor((Context)context, (int)borderColorRes) : a.getColor(R.styleable.EaseConversationListLayout_ease_con_item_avatar_border_color, 0);
            this.setModel.setAvatarSize(avatarSize);
            this.setModel.setShapeType(shapeType);
            this.setModel.setAvatarRadius(avatarRadius);
            this.setModel.setBorderWidth(borderWidth);
            this.setModel.setBorderColor(borderColor);
            float itemHeight = a.getDimension(R.styleable.EaseConversationListLayout_ease_con_item_height, EaseConversationListLayout.dip2px(context, 75.0f));
            Drawable bgDrawable = a.getDrawable(R.styleable.EaseConversationListLayout_ease_con_item_background);
            this.setModel.setItemHeight(itemHeight);
            this.setModel.setBgDrawable(bgDrawable);
            int unreadDotPosition = a.getInteger(R.styleable.EaseConversationListLayout_ease_con_item_unread_dot_position, 0);
            this.setModel.setUnreadDotPosition(unreadDotPosition == 0 ? EaseConversationSetStyle.UnreadDotPosition.LEFT : EaseConversationSetStyle.UnreadDotPosition.RIGHT);
            boolean showSystemMessage = a.getBoolean(R.styleable.EaseConversationListLayout_ease_con_item_show_system_message, true);
            this.setModel.setShowSystemMessage(showSystemMessage);
            this.presenter.setShowSystemMessage(showSystemMessage);
            a.recycle();
        }
    }

    private void initViews() {
        this.presenter.attachView(this);
        this.rvConversationList = (EaseRecyclerView)this.findViewById(R.id.rv_conversation_list);
        this.rvConversationList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.adapter = new ConcatAdapter(new RecyclerView.Adapter[0]);
        this.listAdapter = new EaseConversationListAdapter();
        this.adapter.addAdapter((RecyclerView.Adapter)this.listAdapter);
        this.menuHelper = new EasePopupMenuHelper();
        this.initListener();
    }

    private void initListener() {
        this.listAdapter.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                if (EaseConversationListLayout.this.itemListener != null) {
                    EaseConversationListLayout.this.itemListener.onItemClick(view, position);
                }
            }
        });
        this.listAdapter.setOnItemLongClickListener(new OnItemLongClickListener(){

            @Override
            public boolean onItemLongClick(View view, int position) {
                ((EaseConversationInfo)EaseConversationListLayout.this.listAdapter.getItem(position)).setSelected(true);
                if (EaseConversationListLayout.this.itemLongListener != null) {
                    return EaseConversationListLayout.this.itemLongListener.onItemLongClick(view, position);
                }
                if (EaseConversationListLayout.this.showDefaultMenu) {
                    EaseConversationListLayout.this.showDefaultMenu(view, position, (EaseConversationInfo)EaseConversationListLayout.this.listAdapter.getItem(position));
                    return true;
                }
                return false;
            }
        });
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.touchX = ev.getX();
        this.touchY = ev.getY();
        return super.dispatchTouchEvent(ev);
    }

    public void init() {
        this.listAdapter.addDelegate(new EaseSystemMsgDelegate(this.setModel));
        this.listAdapter.addDelegate(new EaseConversationDelegate(this.setModel));
        this.rvConversationList.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    public void loadDefaultData() {
        this.presenter.loadData();
    }

    public void setData(List<EaseConversationInfo> data) {
        this.presenter.sortData(data);
    }

    public void addData(List<EaseConversationInfo> data) {
        if (data != null) {
            List<EaseConversationInfo> infos = this.listAdapter.getData();
            infos.addAll(data);
            this.presenter.sortData(infos);
        }
    }

    public void notifyDataSetChanged() {
        if (this.listAdapter != null) {
            List<EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder>> delegates = this.listAdapter.getAllDelegate();
            if (delegates != null && !delegates.isEmpty()) {
                for (int i = 0; i < delegates.size(); ++i) {
                    EaseBaseConversationDelegate delegate = (EaseBaseConversationDelegate)delegates.get(i);
                    delegate.setSetModel(this.setModel);
                }
            }
            this.listAdapter.notifyDataSetChanged();
        }
    }

    public float getTouchX() {
        return this.touchX;
    }

    public float getTouchY() {
        return this.touchY;
    }

    private void showDefaultMenu(View view, final int position, final EaseConversationInfo info) {
        this.menuHelper.addItemMenu(0, R.id.action_con_make_read, 0, this.getContext().getString(R.string.ease_conversation_menu_make_read));
        this.menuHelper.addItemMenu(0, R.id.action_con_make_top, 1, this.getContext().getString(R.string.ease_conversation_menu_make_top));
        this.menuHelper.addItemMenu(0, R.id.action_con_cancel_top, 2, this.getContext().getString(R.string.ease_conversation_menu_cancel_top));
        this.menuHelper.addItemMenu(0, R.id.action_con_delete, 3, this.getContext().getString(R.string.ease_conversation_menu_delete));
        this.menuHelper.initMenu(view);
        this.menuHelper.findItemVisible(R.id.action_con_make_top, !info.isTop());
        this.menuHelper.findItemVisible(R.id.action_con_cancel_top, info.isTop());
        if (info.getInfo() instanceof EMConversation) {
            this.menuHelper.findItemVisible(R.id.action_con_make_read, ((EMConversation)info.getInfo()).getUnreadMsgCount() > 0);
        }
        this.menuHelper.findItemVisible(R.id.action_con_make_read, false);
        if (this.menuPreShowListener != null) {
            this.menuPreShowListener.onMenuPreShow(this.menuHelper, position);
        }
        this.menuHelper.setOnPopupMenuItemClickListener(new OnPopupMenuItemClickListener(){

            @Override
            public boolean onMenuItemClick(MenuItem item, int menuPos) {
                if (EaseConversationListLayout.this.popupMenuItemClickListener != null && EaseConversationListLayout.this.popupMenuItemClickListener.onMenuItemClick(item, position)) {
                    return true;
                }
                int itemId = item.getItemId();
                if (itemId == R.id.action_con_make_read) {
                    EaseConversationListLayout.this.presenter.makeConversionRead(position, info);
                    return true;
                }
                if (itemId == R.id.action_con_make_top) {
                    EaseConversationListLayout.this.presenter.makeConversationTop(position, info);
                    return true;
                }
                if (itemId == R.id.action_con_cancel_top) {
                    EaseConversationListLayout.this.presenter.cancelConversationTop(position, info);
                    return true;
                }
                if (itemId == R.id.action_con_delete) {
                    EaseConversationListLayout.this.presenter.deleteConversation(position, info);
                    return true;
                }
                return false;
            }
        });
        this.menuHelper.setOnPopupMenuDismissListener(new OnPopupMenuDismissListener(){

            @Override
            public void onDismiss(PopupMenu menu) {
                info.setSelected(false);
                if (EaseConversationListLayout.this.dismissListener != null) {
                    EaseConversationListLayout.this.dismissListener.onDismiss(menu);
                }
            }
        });
        this.menuHelper.show((int)this.getTouchX(), 0);
    }

    @Override
    public void addHeaderAdapter(RecyclerView.Adapter adapter) {
        this.adapter.addAdapter(0, adapter);
    }

    @Override
    public void addFooterAdapter(RecyclerView.Adapter adapter) {
        this.adapter.addAdapter(adapter);
    }

    @Override
    public void removeAdapter(RecyclerView.Adapter adapter) {
        this.adapter.removeAdapter(adapter);
    }

    @Override
    public void addRVItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.rvConversationList.addItemDecoration(decor);
    }

    @Override
    public void removeRVItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.rvConversationList.removeItemDecoration(decor);
    }

    @Override
    public void setPresenter(EaseConversationPresenter presenter) {
        this.presenter = presenter;
        if (this.getContext() instanceof AppCompatActivity) {
            ((AppCompatActivity)this.getContext()).getLifecycle().addObserver((LifecycleObserver)presenter);
        }
        this.presenter.setShowSystemMessage(this.setModel.isShowSystemMessage());
        this.presenter.attachView(this);
    }

    @Override
    public void showItemDefaultMenu(boolean showDefault) {
        this.showDefaultMenu = showDefault;
    }

    @Override
    public void setOnItemClickListener(OnItemClickListener listener) {
        this.itemListener = listener;
    }

    @Override
    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        this.itemLongListener = listener;
    }

    @Override
    public void setItemBackGround(Drawable backGround) {
        this.setModel.setBgDrawable(backGround);
        this.notifyDataSetChanged();
    }

    @Override
    public void setItemHeight(int height) {
        this.setModel.setItemHeight(height);
        this.notifyDataSetChanged();
    }

    @Override
    public void hideUnreadDot(boolean hide) {
        this.setModel.setHideUnreadDot(hide);
        this.notifyDataSetChanged();
    }

    @Override
    public void showSystemMessage(boolean show) {
        this.setModel.setShowSystemMessage(show);
        this.presenter.setShowSystemMessage(show);
        this.notifyDataSetChanged();
    }

    @Override
    public void showUnreadDotPosition(EaseConversationSetStyle.UnreadDotPosition position) {
        this.setModel.setUnreadDotPosition(position);
        this.notifyDataSetChanged();
    }

    @Override
    public void setTitleTextSize(int textSize) {
        this.setModel.setTitleTextSize(textSize);
        this.notifyDataSetChanged();
    }

    @Override
    public void setTitleTextColor(int textColor) {
        this.setModel.setTitleTextColor(textColor);
        this.notifyDataSetChanged();
    }

    @Override
    public void setContentTextSize(int textSize) {
        this.setModel.setContentTextSize(textSize);
        this.notifyDataSetChanged();
    }

    @Override
    public void setContentTextColor(int textColor) {
        this.setModel.setContentTextColor(textColor);
        this.notifyDataSetChanged();
    }

    @Override
    public void setDateTextSize(int textSize) {
        this.setModel.setDateTextSize(textSize);
        this.notifyDataSetChanged();
    }

    @Override
    public void setDateTextColor(int textColor) {
        this.setModel.setDateTextColor(textColor);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarSize(float avatarSize) {
        this.setModel.setAvatarSize(avatarSize);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarShapeType(EaseImageView.ShapeType shapeType) {
        this.setModel.setShapeType(shapeType);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarRadius(int radius) {
        this.setModel.setAvatarRadius(radius);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarBorderWidth(int borderWidth) {
        this.setModel.setBorderWidth(borderWidth);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarBorderColor(int borderColor) {
        this.setModel.setBorderColor(borderColor);
        this.notifyDataSetChanged();
    }

    @Override
    public void loadConversationListSuccess(List<EaseConversationInfo> data) {
        this.presenter.sortData(data);
    }

    @Override
    public void loadConversationListNoData() {
        if (this.loadListener != null) {
            this.loadListener.loadDataFinish(new ArrayList<EaseConversationInfo>());
        }
    }

    @Override
    public void loadConversationListFail(String message) {
        if (this.loadListener != null) {
            this.loadListener.loadDataFail(message);
        }
    }

    @Override
    public void sortConversationListSuccess(List<EaseConversationInfo> data) {
        if (this.loadListener != null) {
            this.loadListener.loadDataFinish(data);
        }
        this.listAdapter.setData(data);
    }

    @Override
    public void refreshList() {
        if (this.conversationChangeListener != null) {
            this.conversationChangeListener.notifyAllChange();
        }
        this.presenter.sortData(this.listAdapter.getData());
    }

    @Override
    public void refreshList(int position) {
        if (this.conversationChangeListener != null) {
            this.conversationChangeListener.notifyItemChange(position);
        }
        this.listAdapter.notifyItemChanged(position);
    }

    @Override
    public void deleteItem(int position) {
        if (this.listAdapter.getData() == null) {
            return;
        }
        if (this.conversationChangeListener != null) {
            this.conversationChangeListener.notifyItemRemove(position);
        }
        try {
            this.listAdapter.getData().remove(position);
            this.listAdapter.notifyItemRemoved(position);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteItemFail(int position, String message) {
        Toast.makeText((Context)this.getContext(), (int)R.string.ease_conversation_delete_item_fail, (int)0).show();
    }

    @Override
    public EaseConversationListAdapter getListAdapter() {
        return this.listAdapter;
    }

    @Override
    public EaseConversationInfo getItem(int position) {
        if (position >= this.listAdapter.getData().size()) {
            throw new ArrayIndexOutOfBoundsException(position);
        }
        return (EaseConversationInfo)this.listAdapter.getItem(position);
    }

    @Override
    public void makeConversionRead(int position, EaseConversationInfo info) {
        this.presenter.makeConversionRead(position, info);
    }

    @Override
    public void makeConversationTop(int position, EaseConversationInfo info) {
        this.presenter.makeConversationTop(position, info);
    }

    @Override
    public void cancelConversationTop(int position, EaseConversationInfo info) {
        this.presenter.cancelConversationTop(position, info);
    }

    @Override
    public void deleteConversation(int position, EaseConversationInfo info) {
        this.presenter.deleteConversation(position, info);
    }

    @Override
    public void setOnConversationChangeListener(OnConversationChangeListener listener) {
        this.conversationChangeListener = listener;
    }

    @Override
    public void setOnConversationLoadListener(OnConversationLoadListener loadListener) {
        this.loadListener = loadListener;
    }

    @Override
    public void clearMenu() {
        this.menuHelper.clear();
    }

    @Override
    public void addItemMenu(int groupId, int itemId, int order, String title) {
        this.menuHelper.addItemMenu(groupId, itemId, order, title);
    }

    @Override
    public void findItemVisible(int id2, boolean visible) {
        this.menuHelper.findItemVisible(id2, visible);
    }

    @Override
    public void setOnPopupMenuPreShowListener(OnPopupMenuPreShowListener preShowListener) {
        this.menuPreShowListener = preShowListener;
    }

    @Override
    public void setOnPopupMenuItemClickListener(OnPopupMenuItemClickListener listener) {
        this.popupMenuItemClickListener = listener;
    }

    @Override
    public void setOnPopupMenuDismissListener(OnPopupMenuDismissListener listener) {
        this.dismissListener = listener;
    }

    @Override
    public EasePopupMenuHelper getMenuHelper() {
        return this.menuHelper;
    }

    @Override
    public Context context() {
        return this.getContext();
    }
}

