/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.conversation;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.interfaces.OnItemClickListener;
import com.hyphenate.easeui.modules.conversation.EaseConversationListLayout;
import com.hyphenate.easeui.modules.conversation.interfaces.OnConversationChangeListener;
import com.hyphenate.easeui.modules.conversation.interfaces.OnConversationLoadListener;
import com.hyphenate.easeui.modules.conversation.model.EaseConversationInfo;
import com.hyphenate.easeui.modules.menu.EasePopupMenuHelper;
import com.hyphenate.easeui.modules.menu.OnPopupMenuItemClickListener;
import com.hyphenate.easeui.modules.menu.OnPopupMenuPreShowListener;
import com.hyphenate.easeui.ui.base.EaseBaseFragment;
import com.hyphenate.util.EMLog;
import java.util.List;

public class EaseConversationListFragment
extends EaseBaseFragment
implements OnItemClickListener,
OnPopupMenuItemClickListener,
OnPopupMenuPreShowListener,
SwipeRefreshLayout.OnRefreshListener,
OnConversationLoadListener,
OnConversationChangeListener {
    private static final String TAG = EaseConversationListFragment.class.getSimpleName();
    public LinearLayout llRoot;
    public EaseConversationListLayout conversationListLayout;
    public SwipeRefreshLayout srlRefresh;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(this.getLayoutId(), null);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(savedInstanceState);
        this.initListener();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.initData();
    }

    public int getLayoutId() {
        return R.layout.ease_fragment_conversations;
    }

    public void initView(Bundle savedInstanceState) {
        this.llRoot = (LinearLayout)this.findViewById(R.id.ll_root);
        this.srlRefresh = (SwipeRefreshLayout)this.findViewById(R.id.srl_refresh);
        this.conversationListLayout = (EaseConversationListLayout)this.findViewById(R.id.list_conversation);
        this.conversationListLayout.init();
    }

    public void initListener() {
        this.conversationListLayout.setOnItemClickListener(this);
        this.conversationListLayout.setOnPopupMenuItemClickListener(this);
        this.conversationListLayout.setOnPopupMenuPreShowListener(this);
        this.conversationListLayout.setOnConversationLoadListener(this);
        this.conversationListLayout.setOnConversationChangeListener(this);
        this.srlRefresh.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
    }

    public void initData() {
        this.conversationListLayout.loadDefaultData();
    }

    @Override
    public void onItemClick(View view, int position) {
    }

    @Override
    public boolean onMenuItemClick(MenuItem item, int position) {
        EMLog.i((String)TAG, (String)("click menu position = " + position));
        return false;
    }

    @Override
    public void onMenuPreShow(EasePopupMenuHelper menuHelper, int position) {
    }

    public void onRefresh() {
        this.conversationListLayout.loadDefaultData();
    }

    @Override
    public void loadDataFinish(List<EaseConversationInfo> data) {
        this.finishRefresh();
    }

    @Override
    public void loadDataFail(String message) {
        this.finishRefresh();
    }

    public void finishRefresh() {
        if (!this.mContext.isFinishing() && this.srlRefresh != null) {
            this.runOnUiThread(() -> this.srlRefresh.setRefreshing(false));
        }
    }

    @Override
    public void notifyItemChange(int position) {
    }

    @Override
    public void notifyAllChange() {
    }

    @Override
    public void notifyItemRemove(int position) {
    }
}

