/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.chat.presenter;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMGroup;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.manager.EaseAtMessageHelper;
import com.hyphenate.easeui.modules.chat.EaseChatLayout;
import com.hyphenate.easeui.modules.chat.presenter.EaseHandleMessagePresenter;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.UriUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class EaseHandleMessagePresenterImpl
extends EaseHandleMessagePresenter {
    private static final String TAG = EaseChatLayout.class.getSimpleName();

    @Override
    public void sendTextMessage(String content) {
        this.sendTextMessage(content, false);
    }

    @Override
    public void sendTextMessage(String content, boolean isNeedGroupAck) {
        if (EaseAtMessageHelper.get().containsAtUsername(content)) {
            this.sendAtMessage(content);
            return;
        }
        EMMessage message = EMMessage.createTxtSendMessage((String)content, (String)this.toChatUsername);
        message.setIsNeedGroupAck(isNeedGroupAck);
        this.sendMessage(message);
    }

    @Override
    public void sendAtMessage(String content) {
        if (!this.isGroupChat()) {
            EMLog.e((String)TAG, (String)"only support group chat message");
            if (this.isActive()) {
                this.runOnUI(() -> this.mView.sendMessageFail("only support group chat message"));
            }
            return;
        }
        EMMessage message = EMMessage.createTxtSendMessage((String)content, (String)this.toChatUsername);
        EMGroup group = EMClient.getInstance().groupManager().getGroup(this.toChatUsername);
        if (EMClient.getInstance().getCurrentUser().equals(group.getOwner()) && EaseAtMessageHelper.get().containsAtAll(content)) {
            message.setAttribute("em_at_list", "ALL");
        } else {
            message.setAttribute("em_at_list", EaseAtMessageHelper.get().atListToJsonArray(EaseAtMessageHelper.get().getAtMessageUsernames(content)));
        }
        this.sendMessage(message);
    }

    @Override
    public void sendBigExpressionMessage(String name, String identityCode) {
        EMMessage message = EaseCommonUtils.createExpressionMessage(this.toChatUsername, name, identityCode);
        this.sendMessage(message);
    }

    @Override
    public void sendVoiceMessage(Uri filePath, int length) {
        EMMessage message = EMMessage.createVoiceSendMessage((Uri)filePath, (int)length, (String)this.toChatUsername);
        this.sendMessage(message);
    }

    @Override
    public void sendImageMessage(Uri imageUri) {
        this.sendImageMessage(imageUri, false);
    }

    @Override
    public void sendImageMessage(Uri imageUri, boolean sendOriginalImage) {
        EMMessage message = EMMessage.createImageSendMessage((Uri)imageUri, (boolean)sendOriginalImage, (String)this.toChatUsername);
        this.sendMessage(message);
    }

    @Override
    public void sendLocationMessage(double latitude, double longitude, String locationAddress) {
        EMMessage message = EMMessage.createLocationSendMessage((double)latitude, (double)longitude, (String)locationAddress, (String)this.toChatUsername);
        EMLog.i((String)TAG, (String)("current = " + EMClient.getInstance().getCurrentUser() + " to = " + this.toChatUsername));
        EMMessageBody body = message.getBody();
        String msgId = message.getMsgId();
        String from = message.getFrom();
        EMLog.i((String)TAG, (String)("body = " + body));
        EMLog.i((String)TAG, (String)("msgId = " + msgId + " from = " + from));
        this.sendMessage(message);
    }

    @Override
    public void sendVideoMessage(Uri videoUri, int videoLength) {
        String thumbPath = this.getThumbPath(videoUri);
        EMMessage message = EMMessage.createVideoSendMessage((Uri)videoUri, (String)thumbPath, (int)videoLength, (String)this.toChatUsername);
        this.sendMessage(message);
    }

    @Override
    public void sendFileMessage(Uri fileUri) {
        EMMessage message = EMMessage.createFileSendMessage((Uri)fileUri, (String)this.toChatUsername);
        this.sendMessage(message);
    }

    @Override
    public void addMessageAttributes(EMMessage message) {
        this.mView.addMsgAttrBeforeSend(message);
    }

    @Override
    public void sendMessage(EMMessage message) {
        if (message == null) {
            if (this.isActive()) {
                this.runOnUI(() -> this.mView.sendMessageFail("message is null!"));
            }
            return;
        }
        this.addMessageAttributes(message);
        if (this.chatType == 2) {
            message.setChatType(EMMessage.ChatType.GroupChat);
        } else if (this.chatType == 3) {
            message.setChatType(EMMessage.ChatType.ChatRoom);
        }
        EMClient.getInstance().chatManager().sendMessage(message);
        if (this.isActive()) {
            this.runOnUI(() -> this.mView.sendMessageFinish(message));
        }
    }

    @Override
    public void sendCmdMessage(String action) {
        EMMessage beginMsg = EMMessage.createSendMessage((EMMessage.Type)EMMessage.Type.CMD);
        EMCmdMessageBody body = new EMCmdMessageBody(action);
        body.deliverOnlineOnly(true);
        beginMsg.addBody((EMMessageBody)body);
        beginMsg.setTo(this.toChatUsername);
        EMClient.getInstance().chatManager().sendMessage(beginMsg);
    }

    @Override
    public void resendMessage(EMMessage message) {
        message.setStatus(EMMessage.Status.CREATE);
        this.sendMessage(message);
    }

    @Override
    public void deleteMessage(EMMessage message) {
        this.conversation.removeMessage(message.getMsgId());
        if (this.isActive()) {
            this.runOnUI(() -> this.mView.deleteLocalMessageSuccess(message));
        }
    }

    @Override
    public void recallMessage(EMMessage message) {
        block3: {
            try {
                EMMessage msgNotification = EMMessage.createSendMessage((EMMessage.Type)EMMessage.Type.TXT);
                EMTextMessageBody txtBody = new EMTextMessageBody(this.mView.context().getResources().getString(R.string.msg_recall_by_self));
                msgNotification.addBody((EMMessageBody)txtBody);
                msgNotification.setTo(message.getTo());
                msgNotification.setMsgTime(message.getMsgTime());
                msgNotification.setLocalTime(message.getMsgTime());
                msgNotification.setAttribute("message_recall", true);
                msgNotification.setStatus(EMMessage.Status.SUCCESS);
                EMClient.getInstance().chatManager().recallMessage(message);
                EMClient.getInstance().chatManager().saveMessage(msgNotification);
                if (this.isActive()) {
                    this.runOnUI(() -> this.mView.recallMessageFinish(msgNotification));
                }
            }
            catch (HyphenateException e) {
                e.printStackTrace();
                if (!this.isActive()) break block3;
                this.runOnUI(() -> this.mView.recallMessageFail(e.getErrorCode(), e.getDescription()));
            }
        }
    }

    private String getThumbPath(Uri videoUri) {
        if (!UriUtils.isFileExistByUri((Context)this.mView.context(), (Uri)videoUri)) {
            return "";
        }
        String filePath = UriUtils.getFilePath((Context)this.mView.context(), (Uri)videoUri);
        File file = new File(PathUtil.getInstance().getVideoPath(), "thvideo" + System.currentTimeMillis() + ".jpeg");
        boolean createSuccess = true;
        if (!TextUtils.isEmpty((CharSequence)filePath) && new File(filePath).exists()) {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                Bitmap ThumbBitmap = ThumbnailUtils.createVideoThumbnail((String)filePath, (int)3);
                ThumbBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                EMLog.e((String)TAG, (String)e.getMessage());
                if (this.isActive()) {
                    this.runOnUI(() -> this.mView.createThumbFileFail(e.getMessage()));
                }
                createSuccess = false;
            }
        } else {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                MediaMetadataRetriever media = new MediaMetadataRetriever();
                media.setDataSource(this.mView.context(), videoUri);
                Bitmap frameAtTime = media.getFrameAtTime();
                frameAtTime.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                EMLog.e((String)TAG, (String)e.getMessage());
                if (this.isActive()) {
                    this.runOnUI(() -> this.mView.createThumbFileFail(e.getMessage()));
                }
                createSuccess = false;
            }
        }
        return createSuccess ? file.getAbsolutePath() : "";
    }
}

