/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.chat;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseEmojicon;
import com.hyphenate.easeui.domain.EaseEmojiconGroupEntity;
import com.hyphenate.easeui.model.EaseDefaultEmojiconDatas;
import com.hyphenate.easeui.modules.chat.interfaces.EaseEmojiconMenuListener;
import com.hyphenate.easeui.modules.chat.interfaces.IChatEmojiconMenu;
import com.hyphenate.easeui.widget.emojicon.EaseEmojiconIndicatorView;
import com.hyphenate.easeui.widget.emojicon.EaseEmojiconPagerView;
import com.hyphenate.easeui.widget.emojicon.EaseEmojiconScrollTabBar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EaseEmojiconMenu
extends LinearLayout
implements IChatEmojiconMenu {
    private int emojiconColumns;
    private int bigEmojiconColumns;
    private EaseEmojiconScrollTabBar tabBar;
    private EaseEmojiconIndicatorView indicatorView;
    private EaseEmojiconPagerView pagerView;
    private List<EaseEmojiconGroupEntity> emojiconGroupList = new ArrayList<EaseEmojiconGroupEntity>();
    private EaseEmojiconMenuListener listener;
    private static final int defaultColumns = 7;
    private static final int defaultBigColumns = 4;

    public EaseEmojiconMenu(Context context) {
        this(context, null);
    }

    public EaseEmojiconMenu(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseEmojiconMenu(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.ease_widget_emojicon, (ViewGroup)this);
        this.pagerView = (EaseEmojiconPagerView)this.findViewById(R.id.pager_view);
        this.indicatorView = (EaseEmojiconIndicatorView)this.findViewById(R.id.indicator_view);
        this.tabBar = (EaseEmojiconScrollTabBar)this.findViewById(R.id.tab_bar);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.EaseEmojiconMenu);
        this.emojiconColumns = ta.getInt(R.styleable.EaseEmojiconMenu_emojiconColumns, 7);
        this.bigEmojiconColumns = ta.getInt(R.styleable.EaseEmojiconMenu_bigEmojiconRows, 4);
        ta.recycle();
    }

    public void init() {
        this.init(null);
    }

    public void init(List<EaseEmojiconGroupEntity> groupEntities) {
        if (groupEntities == null || groupEntities.size() == 0) {
            groupEntities = new ArrayList<EaseEmojiconGroupEntity>();
            groupEntities.add(new EaseEmojiconGroupEntity(R.drawable.ee_1, Arrays.asList(EaseDefaultEmojiconDatas.getData())));
        }
        for (EaseEmojiconGroupEntity groupEntity : groupEntities) {
            this.emojiconGroupList.add(groupEntity);
            this.tabBar.addTab(groupEntity.getIcon());
        }
        this.pagerView.setPagerViewListener(new EmojiconPagerViewListener());
        this.pagerView.init(this.emojiconGroupList, this.emojiconColumns, this.bigEmojiconColumns);
        this.tabBar.setTabBarItemClickListener(new EaseEmojiconScrollTabBar.EaseScrollTabBarItemClickListener(){

            @Override
            public void onItemClick(int position) {
                EaseEmojiconMenu.this.pagerView.setGroupPostion(position);
            }
        });
    }

    @Override
    public void addEmojiconGroup(EaseEmojiconGroupEntity groupEntity) {
        this.emojiconGroupList.add(groupEntity);
        this.pagerView.addEmojiconGroup(groupEntity, true);
        this.tabBar.addTab(groupEntity.getIcon());
    }

    @Override
    public void addEmojiconGroup(List<EaseEmojiconGroupEntity> groupEntitieList) {
        for (int i = 0; i < groupEntitieList.size(); ++i) {
            EaseEmojiconGroupEntity groupEntity = groupEntitieList.get(i);
            this.emojiconGroupList.add(groupEntity);
            this.pagerView.addEmojiconGroup(groupEntity, i == groupEntitieList.size() - 1);
            this.tabBar.addTab(groupEntity.getIcon());
        }
    }

    @Override
    public void removeEmojiconGroup(int position) {
        this.emojiconGroupList.remove(position);
        this.pagerView.removeEmojiconGroup(position);
        this.tabBar.removeTab(position);
    }

    @Override
    public void setTabBarVisibility(boolean isVisible) {
        if (!isVisible) {
            this.tabBar.setVisibility(8);
        } else {
            this.tabBar.setVisibility(0);
        }
    }

    @Override
    public void setEmojiconMenuListener(EaseEmojiconMenuListener listener) {
        this.listener = listener;
    }

    private class EmojiconPagerViewListener
    implements EaseEmojiconPagerView.EaseEmojiconPagerViewListener {
        private EmojiconPagerViewListener() {
        }

        @Override
        public void onPagerViewInited(int groupMaxPageSize, int firstGroupPageSize) {
            EaseEmojiconMenu.this.indicatorView.init(groupMaxPageSize);
            EaseEmojiconMenu.this.indicatorView.updateIndicator(firstGroupPageSize);
            EaseEmojiconMenu.this.tabBar.selectedTo(0);
        }

        @Override
        public void onGroupPositionChanged(int groupPosition, int pagerSizeOfGroup) {
            EaseEmojiconMenu.this.indicatorView.updateIndicator(pagerSizeOfGroup);
            EaseEmojiconMenu.this.tabBar.selectedTo(groupPosition);
        }

        @Override
        public void onGroupInnerPagePostionChanged(int oldPosition, int newPosition) {
            EaseEmojiconMenu.this.indicatorView.selectTo(oldPosition, newPosition);
        }

        @Override
        public void onGroupPagePostionChangedTo(int position) {
            EaseEmojiconMenu.this.indicatorView.selectTo(position);
        }

        @Override
        public void onGroupMaxPageSizeChanged(int maxCount) {
            EaseEmojiconMenu.this.indicatorView.updateIndicator(maxCount);
        }

        @Override
        public void onDeleteImageClicked() {
            if (EaseEmojiconMenu.this.listener != null) {
                EaseEmojiconMenu.this.listener.onDeleteImageClicked();
            }
        }

        @Override
        public void onExpressionClicked(EaseEmojicon emojicon) {
            if (EaseEmojiconMenu.this.listener != null) {
                EaseEmojiconMenu.this.listener.onExpressionClicked(emojicon);
            }
        }
    }
}

