/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.model;

import android.text.TextUtils;
import java.io.Serializable;

public class EaseEvent
implements Serializable {
    public boolean refresh;
    public String event;
    public TYPE type;
    public String message;

    public EaseEvent() {
    }

    public EaseEvent(String event, TYPE type, boolean refresh) {
        this.refresh = refresh;
        this.event = event;
        this.type = type;
    }

    public EaseEvent(String event, TYPE type) {
        this.refresh = true;
        this.event = event;
        this.type = type;
    }

    public static EaseEvent create(String event, TYPE type) {
        return new EaseEvent(event, type);
    }

    public static EaseEvent create(String event, TYPE type, String message) {
        EaseEvent easeEvent = new EaseEvent(event, type);
        easeEvent.message = message;
        return easeEvent;
    }

    public static EaseEvent create(String event, TYPE type, boolean refresh) {
        return new EaseEvent(event, type, refresh);
    }

    public boolean isMessageChange() {
        return this.type == TYPE.MESSAGE;
    }

    public boolean isGroupChange() {
        return this.type == TYPE.GROUP;
    }

    public boolean isGroupLeave() {
        return this.type == TYPE.GROUP_LEAVE || TextUtils.equals((CharSequence)this.event, (CharSequence)"group_leave");
    }

    public boolean isChatRoomLeave() {
        return this.type == TYPE.CHAT_ROOM_LEAVE;
    }

    public boolean isContactChange() {
        return this.type == TYPE.CONTACT;
    }

    public boolean isNotifyChange() {
        return this.type == TYPE.NOTIFY;
    }

    public boolean isAccountChange() {
        return this.type == TYPE.ACCOUNT;
    }

    public static enum TYPE {
        GROUP,
        GROUP_LEAVE,
        CONTACT,
        MESSAGE,
        NOTIFY,
        CHAT_ROOM,
        CHAT_ROOM_LEAVE,
        ACCOUNT;

    }
}

