/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.manager;

import android.text.TextUtils;
import android.view.MotionEvent;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hyphenate.easeui.adapter.EaseBaseRecyclerViewAdapter;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.widget.EaseSidebar;
import java.util.List;

public class SidebarPresenter
implements EaseSidebar.OnTouchEventListener {
    private TextView mFloatingHeader;
    private RecyclerView mRecyclerView;
    private RecyclerView.Adapter mAdapter;

    public void setupWithRecyclerView(RecyclerView recyclerView, RecyclerView.Adapter adapter, TextView floatingHeader) {
        this.mRecyclerView = recyclerView;
        this.mAdapter = adapter;
        this.mFloatingHeader = floatingHeader;
    }

    @Override
    public void onActionDown(MotionEvent event, String pointer) {
        this.showFloatingHeader(pointer);
        this.moveToRecyclerItem(pointer);
    }

    @Override
    public void onActionMove(MotionEvent event, String pointer) {
        this.showFloatingHeader(pointer);
        this.moveToRecyclerItem(pointer);
    }

    @Override
    public void onActionUp(MotionEvent event) {
        this.hideFloatingHeader();
    }

    private void moveToRecyclerItem(String pointer) {
        if (this.mAdapter == null) {
            return;
        }
        if (!(this.mAdapter instanceof EaseBaseRecyclerViewAdapter)) {
            return;
        }
        List data = ((EaseBaseRecyclerViewAdapter)this.mAdapter).getData();
        if (data == null || data.isEmpty()) {
            return;
        }
        Object object = data.get(0);
        if (!(object instanceof EaseUser)) {
            return;
        }
        for (int i = 0; i < data.size(); ++i) {
            LinearLayoutManager manager;
            EaseUser item = (EaseUser)data.get(i);
            if (!TextUtils.equals((CharSequence)item.getInitialLetter(), (CharSequence)pointer) || (manager = (LinearLayoutManager)this.mRecyclerView.getLayoutManager()) == null) continue;
            manager.scrollToPositionWithOffset(i, 0);
        }
    }

    private void showFloatingHeader(String pointer) {
        if (TextUtils.isEmpty((CharSequence)pointer)) {
            this.hideFloatingHeader();
            return;
        }
        this.mFloatingHeader.setText((CharSequence)pointer);
        this.mFloatingHeader.setVisibility(0);
    }

    private void hideFloatingHeader() {
        this.mFloatingHeader.setVisibility(8);
    }
}

