/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.manager;

import android.content.Context;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PhoneStateManager {
    private static final String TAG = "PhoneStateManager";
    private static PhoneStateManager INSTANCE = null;
    private TelephonyManager telephonyManager;
    private List<PhoneStateCallback> stateCallbacks = null;
    private PhoneStateListener phoneStateListener = new PhoneStateListener(){

        public void onCallStateChanged(int state, String incomingNumber) {
            super.onCallStateChanged(state, incomingNumber);
            for (PhoneStateCallback callback : PhoneStateManager.this.stateCallbacks) {
                callback.onCallStateChanged(state, incomingNumber);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PhoneStateManager get(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<PhoneStateManager> clazz = PhoneStateManager.class;
        synchronized (PhoneStateManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new PhoneStateManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    protected void finalize() throws Throwable {
        if (this.telephonyManager != null) {
            this.telephonyManager.listen(this.phoneStateListener, 0);
        }
        super.finalize();
    }

    public void addStateCallback(PhoneStateCallback callback) {
        if (!this.stateCallbacks.contains(callback)) {
            this.stateCallbacks.add(callback);
        }
    }

    public void removeStateCallback(PhoneStateCallback callback) {
        if (this.stateCallbacks.contains(callback)) {
            this.stateCallbacks.remove(callback);
        }
    }

    private PhoneStateManager(Context context) {
        Context appContext = context.getApplicationContext();
        this.telephonyManager = (TelephonyManager)appContext.getSystemService("phone");
        if (this.telephonyManager != null) {
            this.telephonyManager.listen(this.phoneStateListener, 32);
        }
        this.stateCallbacks = new CopyOnWriteArrayList<PhoneStateCallback>();
    }

    public static interface PhoneStateCallback {
        public void onCallStateChanged(int var1, String var2);
    }
}

