/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.manager;

import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.EMTextMessageBody;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EaseSystemMsgManager {
    private static EaseSystemMsgManager instance;

    private EaseSystemMsgManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseSystemMsgManager getInstance() {
        if (instance != null) return instance;
        Class<EaseSystemMsgManager> clazz = EaseSystemMsgManager.class;
        synchronized (EaseSystemMsgManager.class) {
            if (instance != null) return instance;
            instance = new EaseSystemMsgManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public EMMessage createMessage(String message, Map<String, Object> ext) {
        EMMessage emMessage = EMMessage.createReceiveMessage((EMMessage.Type)EMMessage.Type.TXT);
        emMessage.setFrom("em_system");
        emMessage.setMsgId(UUID.randomUUID().toString());
        emMessage.setStatus(EMMessage.Status.SUCCESS);
        emMessage.addBody((EMMessageBody)new EMTextMessageBody(message));
        if (ext != null && !ext.isEmpty()) {
            for (String key : ext.keySet()) {
                Object value = ext.get(key);
                this.putObject(emMessage, key, value);
            }
        }
        emMessage.setUnread(true);
        EMClient.getInstance().chatManager().saveMessage(emMessage);
        return emMessage;
    }

    private void putObject(EMMessage message, String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (value instanceof String) {
            message.setAttribute(key, (String)value);
        } else if (value instanceof Byte) {
            message.setAttribute(key, ((Integer)value).intValue());
        } else if (value instanceof Character) {
            message.setAttribute(key, ((Integer)value).intValue());
        } else if (value instanceof Short) {
            message.setAttribute(key, ((Integer)value).intValue());
        } else if (value instanceof Integer) {
            message.setAttribute(key, ((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            message.setAttribute(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            message.setAttribute(key, ((Long)value).longValue());
        } else if (value instanceof Float) {
            JSONObject object = new JSONObject();
            try {
                object.put(key, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            message.setAttribute(key, object);
        } else if (value instanceof Double) {
            JSONObject object = new JSONObject();
            try {
                object.put(key, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            message.setAttribute(key, object);
        } else if (value instanceof JSONObject) {
            message.setAttribute(key, (JSONObject)value);
        } else if (value instanceof JSONArray) {
            message.setAttribute(key, (JSONArray)value);
        } else {
            JSONObject object = new JSONObject();
            try {
                object.put(key, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            message.setAttribute(key, object);
        }
    }

    public Map<String, Object> createMsgExt() {
        return new HashMap<String, Object>();
    }

    public EMMessage getLastMessageByConversation(EMConversation con) {
        if (con == null) {
            return null;
        }
        return con.getLastMessage();
    }

    public EMConversation getConversation() {
        return this.getConversation(true);
    }

    public EMConversation getConversation(boolean createIfNotExists) {
        return EMClient.getInstance().chatManager().getConversation("em_system", EMConversation.EMConversationType.Chat, createIfNotExists);
    }

    public List<EMMessage> getAllMessages() {
        return this.getConversation().getAllMessages();
    }

    public boolean isSystemMessage(EMMessage message) {
        return message.getType() == EMMessage.Type.TXT && TextUtils.equals((CharSequence)message.getFrom(), (CharSequence)"em_system");
    }

    public boolean isSystemConversation(EMConversation conversation) {
        return conversation.getType() == EMConversation.EMConversationType.Chat && TextUtils.equals((CharSequence)conversation.conversationId(), (CharSequence)"em_system");
    }

    public String getMessageContent(EMMessage message) {
        return ((EMTextMessageBody)message.getBody()).getMessage();
    }

    public boolean updateMessage(EMMessage message) {
        if (message == null || !this.isSystemMessage(message)) {
            return false;
        }
        EMClient.getInstance().chatManager().updateMessage(message);
        return true;
    }

    public boolean removeMessage(EMMessage message) {
        if (message == null || !this.isSystemMessage(message)) {
            return false;
        }
        EMConversation conversation = EMClient.getInstance().chatManager().getConversation("em_system");
        conversation.removeMessage(message.getMsgId());
        return true;
    }

    public void markAllMessagesAsRead() {
        EMConversation conversation = EMClient.getInstance().chatManager().getConversation("em_system");
        conversation.markAllMessagesAsRead();
    }
}

