/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.manager;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMGroupReadAck;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.util.EMLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EaseDingMessageHelper {
    private static final String TAG = "EaseDingMessageHelper";
    static final int CACHE_SIZE_CONVERSATION = 5;
    static final int CACHE_SIZE_MESSAGE = 10;
    static final String KEY_DING = "EMDingMessage";
    static final String KEY_DING_ACK = "EMDingMessageAck";
    static final String KEY_CONVERSATION_ID = "EMConversationID";
    private static String NAME_PREFS = "group-ack-data-prefs";
    private static EaseDingMessageHelper instance;
    private Map<String, WeakReference<IAckUserUpdateListener>> listenerMap;
    private LruCache<String, LruCache<String, List<String>>> dataCache = new LruCache<String, LruCache<String, List<String>>>(5){

        protected int sizeOf(String key, LruCache<String, List<String>> value) {
            return 1;
        }
    };
    private SharedPreferences dataPrefs;
    private SharedPreferences.Editor prefsEditor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseDingMessageHelper get() {
        if (instance != null) return instance;
        Class<EaseDingMessageHelper> clazz = EaseDingMessageHelper.class;
        synchronized (EaseDingMessageHelper.class) {
            if (instance != null) return instance;
            instance = new EaseDingMessageHelper(EMClient.getInstance().getContext());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setUserUpdateListener(EMMessage msg, @Nullable IAckUserUpdateListener listener) {
        if (!this.validateMessage(msg)) {
            return;
        }
        String key = msg.getMsgId();
        if (listener == null) {
            this.listenerMap.remove(key);
        } else {
            this.listenerMap.put(key, new WeakReference<IAckUserUpdateListener>(listener));
        }
    }

    public boolean isDingMessage(EMMessage message) {
        return message.isNeedGroupAck();
    }

    public EMMessage createDingMessage(String to, String content) {
        EMMessage message = EMMessage.createTxtSendMessage((String)content, (String)to);
        message.setIsNeedGroupAck(true);
        return message;
    }

    public void sendAckMessage(EMMessage message) {
        if (!this.validateMessage(message)) {
            return;
        }
        if (message.isAcked()) {
            return;
        }
        if (EMClient.getInstance().getCurrentUser().equalsIgnoreCase(message.getFrom())) {
            return;
        }
        try {
            if (message.isNeedGroupAck() && !message.isUnread()) {
                String to = message.conversationId();
                String msgId = message.getMsgId();
                EMClient.getInstance().chatManager().ackGroupMessageRead(to, msgId, ((EMTextMessageBody)message.getBody()).getMessage());
                message.setUnread(false);
                EMLog.i((String)TAG, (String)"Send the group ack cmd-type message.");
            }
        }
        catch (Exception e) {
            EMLog.d((String)TAG, (String)e.getMessage());
        }
    }

    public void fetchGroupReadAck(EMMessage msg) {
        String msgId = msg.getMsgId();
        EMClient.getInstance().chatManager().asyncFetchGroupReadAcks(msgId, 20, "", (EMValueCallBack)new EMValueCallBack<EMCursorResult<EMGroupReadAck>>(){

            public void onSuccess(EMCursorResult<EMGroupReadAck> value) {
                EMLog.d((String)EaseDingMessageHelper.TAG, (String)"asyncFetchGroupReadAcks success");
                if (value.getData() != null && ((List)value.getData()).size() > 0) {
                    List acks = (List)value.getData();
                    for (EMGroupReadAck c : acks) {
                        EaseDingMessageHelper.this.handleGroupReadAck(c);
                    }
                } else {
                    EMLog.d((String)EaseDingMessageHelper.TAG, (String)"no data");
                }
            }

            public void onError(int error, String errorMsg) {
                EMLog.d((String)EaseDingMessageHelper.TAG, (String)("asyncFetchGroupReadAcks fail: " + error));
            }
        });
    }

    public void handleGroupReadAck(EMGroupReadAck ack) {
        WeakReference<IAckUserUpdateListener> listenerRefs;
        ArrayList<String> userList;
        if (ack == null) {
            return;
        }
        EMLog.d((String)TAG, (String)("handle group read ack: " + ack.getMsgId()));
        String username = ack.getFrom();
        String msgId = ack.getMsgId();
        String conversationId = EMClient.getInstance().chatManager().getMessage(msgId).conversationId();
        LruCache<String, List<String>> msgCache = (LruCache<String, List<String>>)this.dataCache.get((Object)conversationId);
        if (msgCache == null) {
            msgCache = this.createCache();
            this.dataCache.put((Object)conversationId, msgCache);
        }
        if ((userList = (ArrayList<String>)msgCache.get((Object)msgId)) == null) {
            userList = new ArrayList<String>();
            msgCache.put((Object)msgId, userList);
        }
        if (!userList.contains(username)) {
            userList.add(username);
        }
        if ((listenerRefs = this.listenerMap.get(msgId)) != null) {
            ((IAckUserUpdateListener)listenerRefs.get()).onUpdate(userList);
        }
        String key = this.generateKey(conversationId, msgId);
        HashSet<String> set = new HashSet<String>();
        set.addAll(userList);
        this.prefsEditor.putStringSet(key, set).commit();
    }

    public void delete(EMMessage message) {
        String key;
        if (!this.validateMessage(message)) {
            return;
        }
        String conversationId = message.getTo();
        String msgId = message.getMsgId();
        LruCache msgCache = (LruCache)this.dataCache.get((Object)conversationId);
        if (msgCache != null) {
            msgCache.remove((Object)msgId);
        }
        if (this.dataPrefs.contains(key = this.generateKey(conversationId, msgId))) {
            this.prefsEditor.remove(key).commit();
        }
    }

    public void delete(EMConversation conversation) {
        if (!conversation.isGroup()) {
            return;
        }
        String conversationId = conversation.conversationId();
        this.dataCache.remove((Object)conversationId);
        String keyPrefix = this.generateKey(conversationId, "");
        Map prefsMap = this.dataPrefs.getAll();
        Set keySet = prefsMap.keySet();
        for (String key : keySet) {
            if (!key.startsWith(keyPrefix)) continue;
            this.prefsEditor.remove(key);
        }
        this.prefsEditor.commit();
    }

    Map<String, WeakReference<IAckUserUpdateListener>> getListenerMap() {
        return this.listenerMap;
    }

    LruCache<String, LruCache<String, List<String>>> getDataCache() {
        return this.dataCache;
    }

    SharedPreferences getDataPrefs() {
        return this.dataPrefs;
    }

    EaseDingMessageHelper(Context context) {
        this.listenerMap = new HashMap<String, WeakReference<IAckUserUpdateListener>>();
        this.dataPrefs = context.getSharedPreferences(NAME_PREFS, 0);
        this.prefsEditor = this.dataPrefs.edit();
    }

    String generateKey(@NonNull String conversationId, @NonNull String originalMsgId) {
        return conversationId + "|" + originalMsgId;
    }

    private boolean validateMessage(EMMessage message) {
        if (message == null) {
            return false;
        }
        if (message.getChatType() != EMMessage.ChatType.GroupChat) {
            return false;
        }
        return this.isDingMessage(message);
    }

    private LruCache<String, List<String>> createCache() {
        return new LruCache<String, List<String>>(10){

            protected int sizeOf(String key, List<String> value) {
                return 1;
            }
        };
    }

    public static interface IAckUserUpdateListener {
        public void onUpdate(List<String> var1);
    }
}

