/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.manager;

import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.manager.EasePreferenceManager;
import com.hyphenate.easeui.utils.EaseUserUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;

public class EaseAtMessageHelper {
    private List<String> toAtUserList = new ArrayList<String>();
    private Set<String> atMeGroupList = EasePreferenceManager.getInstance().getAtMeGroups();
    private static EaseAtMessageHelper instance = null;

    public static synchronized EaseAtMessageHelper get() {
        if (instance == null) {
            instance = new EaseAtMessageHelper();
        }
        return instance;
    }

    private EaseAtMessageHelper() {
        if (this.atMeGroupList == null) {
            this.atMeGroupList = new HashSet<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtUser(String username) {
        List<String> list = this.toAtUserList;
        synchronized (list) {
            if (!this.toAtUserList.contains(username)) {
                this.toAtUserList.add(username);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAtUsername(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        List<String> list = this.toAtUserList;
        synchronized (list) {
            Iterator<String> iterator = this.toAtUserList.iterator();
            while (iterator.hasNext()) {
                EaseUser user;
                String username;
                String nick = username = iterator.next();
                if (EaseUserUtils.getUserInfo(username) != null && (user = EaseUserUtils.getUserInfo(username)) != null) {
                    nick = user.getNickname();
                }
                if (!content.contains(nick)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAtAll(String content) {
        String atAll = "@" + EaseIM.getInstance().getContext().getString(R.string.all_members);
        return content.contains(atAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAtMessageUsernames(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        List<String> list = this.toAtUserList;
        synchronized (list) {
            ArrayList<String> list2 = null;
            Iterator<String> iterator = this.toAtUserList.iterator();
            while (iterator.hasNext()) {
                EaseUser user;
                String username;
                String nick = username = iterator.next();
                if (EaseUserUtils.getUserInfo(username) != null && (user = EaseUserUtils.getUserInfo(username)) != null) {
                    nick = user.getNickname();
                }
                if (!content.contains(nick)) continue;
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                }
                list2.add(username);
            }
            return list2;
        }
    }

    public void parseMessages(List<EMMessage> messages) {
        EMMessage[] msgs;
        int size = this.atMeGroupList.size();
        for (EMMessage msg : msgs = messages.toArray(new EMMessage[messages.size()])) {
            block4: {
                if (msg.getChatType() != EMMessage.ChatType.GroupChat) continue;
                String groupId = msg.getTo();
                try {
                    JSONArray jsonArray = msg.getJSONArrayAttribute("em_at_list");
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String username = jsonArray.getString(i);
                        if (!EMClient.getInstance().getCurrentUser().equals(username) || this.atMeGroupList.contains(groupId)) continue;
                        this.atMeGroupList.add(groupId);
                        break;
                    }
                }
                catch (Exception e1) {
                    String usernameStr = msg.getStringAttribute("em_at_list", null);
                    if (usernameStr == null || !usernameStr.toUpperCase().equals("ALL") || this.atMeGroupList.contains(groupId)) break block4;
                    this.atMeGroupList.add(groupId);
                }
            }
            if (this.atMeGroupList.size() == size) continue;
            EasePreferenceManager.getInstance().setAtMeGroups(this.atMeGroupList);
        }
    }

    public Set<String> getAtMeGroups() {
        return this.atMeGroupList;
    }

    public void removeAtMeGroup(String groupId) {
        if (this.atMeGroupList.contains(groupId)) {
            this.atMeGroupList.remove(groupId);
            EasePreferenceManager.getInstance().setAtMeGroups(this.atMeGroupList);
        }
    }

    public boolean hasAtMeMsg(String groupId) {
        return this.atMeGroupList.contains(groupId);
    }

    public boolean isAtMeMsg(EMMessage message) {
        EaseUser user = EaseUserUtils.getUserInfo(message.getFrom());
        if (user != null) {
            try {
                JSONArray jsonArray = message.getJSONArrayAttribute("em_at_list");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String username = jsonArray.getString(i);
                    if (!username.equals(EMClient.getInstance().getCurrentUser())) continue;
                    return true;
                }
            }
            catch (Exception e) {
                String atUsername = message.getStringAttribute("em_at_list", null);
                return atUsername != null && atUsername.toUpperCase().equals("ALL");
            }
        }
        return false;
    }

    public JSONArray atListToJsonArray(List<String> atList) {
        JSONArray jArray = new JSONArray();
        int size = atList.size();
        for (int i = 0; i < size; ++i) {
            String username = atList.get(i);
            jArray.put((Object)username);
        }
        return jArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanToAtUserList() {
        List<String> list = this.toAtUserList;
        synchronized (list) {
            this.toAtUserList.clear();
        }
    }
}

