/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.domain;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.hyphenate.util.HanziToPinyin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EaseUser
implements Serializable {
    @NonNull
    private String username;
    private String nickname;
    private String initialLetter;
    private String avatar;
    private int contact;
    private long modifyNicknameTimestamp;
    private long modifyInitialLetterTimestamp;

    @NonNull
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@NonNull String username) {
        this.username = username;
    }

    public String getNickname() {
        return TextUtils.isEmpty((CharSequence)this.nickname) ? this.username : this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
        this.modifyNicknameTimestamp = System.currentTimeMillis();
    }

    public String getInitialLetter() {
        if (this.initialLetter == null || this.modifyNicknameTimestamp > this.modifyInitialLetterTimestamp) {
            if (!TextUtils.isEmpty((CharSequence)this.nickname)) {
                return this.getInitialLetter(this.nickname);
            }
            return this.getInitialLetter(this.username);
        }
        return this.initialLetter;
    }

    public void setInitialLetter(String initialLetter) {
        this.initialLetter = initialLetter;
        this.modifyInitialLetterTimestamp = System.currentTimeMillis();
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public int getContact() {
        return this.contact;
    }

    public void setContact(int contact) {
        this.contact = contact;
    }

    public String getInitialLetter(String name) {
        return new GetInitialLetter().getLetter(name);
    }

    public long getModifyNicknameTimestamp() {
        return this.modifyNicknameTimestamp;
    }

    public void setModifyNicknameTimestamp(long modifyNicknameTimestamp) {
        this.modifyNicknameTimestamp = modifyNicknameTimestamp;
    }

    public long getModifyInitialLetterTimestamp() {
        return this.modifyInitialLetterTimestamp;
    }

    public void setModifyInitialLetterTimestamp(long modifyInitialLetterTimestamp) {
        this.modifyInitialLetterTimestamp = modifyInitialLetterTimestamp;
    }

    public EaseUser() {
    }

    public EaseUser(@NonNull String username) {
        this.username = username;
    }

    public String toString() {
        return "EaseUser{username='" + this.username + '\'' + ", nickname='" + this.nickname + '\'' + ", initialLetter='" + this.initialLetter + '\'' + ", avatar='" + this.avatar + '\'' + ", contact=" + this.contact + '}';
    }

    public static List<EaseUser> parse(List<String> ids) {
        ArrayList<EaseUser> users = new ArrayList<EaseUser>();
        if (ids == null || ids.isEmpty()) {
            return users;
        }
        for (String id2 : ids) {
            EaseUser user = new EaseUser(id2);
            users.add(user);
        }
        return users;
    }

    public class GetInitialLetter {
        private String defaultLetter = "#";

        public String getLetter(String name) {
            if (TextUtils.isEmpty((CharSequence)name)) {
                return this.defaultLetter;
            }
            char char0 = name.toLowerCase().charAt(0);
            if (Character.isDigit(char0)) {
                return this.defaultLetter;
            }
            ArrayList l = HanziToPinyin.getInstance().get(name.substring(0, 1));
            if (l != null && !l.isEmpty() && ((HanziToPinyin.Token)l.get((int)0)).target.length() > 0) {
                HanziToPinyin.Token token = (HanziToPinyin.Token)l.get(0);
                String letter = token.target.substring(0, 1).toUpperCase();
                char c = letter.charAt(0);
                if (c < 'A' || c > 'Z') {
                    return this.defaultLetter;
                }
                return letter;
            }
            return this.defaultLetter;
        }
    }
}

