/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.delegate;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.hyphenate.chat.EMChatRoom;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMGroup;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseBaseDelegate;
import com.hyphenate.easeui.adapter.EaseBaseRecyclerViewAdapter;
import com.hyphenate.easeui.domain.EaseAvatarOptions;
import com.hyphenate.easeui.manager.EaseAtMessageHelper;
import com.hyphenate.easeui.manager.EasePreferenceManager;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.easeui.utils.EaseDateUtils;
import com.hyphenate.easeui.utils.EaseSmileUtils;
import com.hyphenate.easeui.widget.EaseImageView;
import java.util.Date;

public class ConversationDelegate
extends EaseBaseDelegate<EMConversation, ViewHolder> {
    @Override
    public boolean isForViewType(EMConversation item, int position) {
        return item != null;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.ease_item_row_chat_history;
    }

    @Override
    protected ViewHolder createViewHolder(View view) {
        return new ViewHolder(view);
    }

    public class ViewHolder
    extends EaseBaseRecyclerViewAdapter.ViewHolder<EMConversation> {
        private ConstraintLayout listIteaseLayout;
        private EaseImageView avatar;
        private TextView mUnreadMsgNumber;
        private TextView name;
        private TextView time;
        private ImageView mMsgState;
        private TextView mentioned;
        private TextView message;
        private Context mContext;

        public ViewHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void initView(View itemView) {
            this.mContext = itemView.getContext();
            this.listIteaseLayout = (ConstraintLayout)this.findViewById(R.id.list_itease_layout);
            this.avatar = (EaseImageView)((Object)this.findViewById(R.id.avatar));
            this.mUnreadMsgNumber = (TextView)this.findViewById(R.id.unread_msg_number);
            this.name = (TextView)this.findViewById(R.id.name);
            this.time = (TextView)this.findViewById(R.id.time);
            this.mMsgState = (ImageView)this.findViewById(R.id.msg_state);
            this.mentioned = (TextView)this.findViewById(R.id.mentioned);
            this.message = (TextView)this.findViewById(R.id.message);
            EaseAvatarOptions avatarOptions = EaseIM.getInstance().getAvatarOptions();
            if (avatarOptions != null) {
                this.avatar.setShapeType(avatarOptions.getAvatarShape());
            }
        }

        @Override
        public void setData(EMConversation object, int position) {
            String unSendMsg;
            EMConversation item = object;
            String username = item.conversationId();
            this.listIteaseLayout.setBackground(!TextUtils.isEmpty((CharSequence)item.getExtField()) ? ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.ease_conversation_top_bg) : null);
            this.mentioned.setVisibility(8);
            if (item.getType() == EMConversation.EMConversationType.GroupChat) {
                if (EaseAtMessageHelper.get().hasAtMeMsg(username)) {
                    this.mentioned.setText(R.string.were_mentioned);
                    this.mentioned.setVisibility(0);
                }
                this.avatar.setImageResource(R.drawable.ease_group_icon);
                EMGroup group = EMClient.getInstance().groupManager().getGroup(username);
                this.name.setText((CharSequence)(group != null ? group.getGroupName() : username));
            } else if (item.getType() == EMConversation.EMConversationType.ChatRoom) {
                this.avatar.setImageResource(R.drawable.ease_chat_room_icon);
                EMChatRoom chatRoom = EMClient.getInstance().chatroomManager().getChatRoom(username);
                this.name.setText((CharSequence)(chatRoom != null && !TextUtils.isEmpty((CharSequence)chatRoom.getName()) ? chatRoom.getName() : username));
            } else {
                this.avatar.setImageResource(R.drawable.ease_default_avatar);
                this.name.setText((CharSequence)username);
            }
            if (item.getUnreadMsgCount() > 0) {
                this.mUnreadMsgNumber.setText((CharSequence)String.valueOf(item.getUnreadMsgCount()));
                this.mUnreadMsgNumber.setVisibility(0);
            } else {
                this.mUnreadMsgNumber.setVisibility(8);
            }
            if (item.getAllMsgCount() != 0) {
                EMMessage lastMessage = item.getLastMessage();
                this.message.setText((CharSequence)EaseSmileUtils.getSmiledText(this.mContext, EaseCommonUtils.getMessageDigest(lastMessage, this.mContext)));
                this.time.setText((CharSequence)EaseDateUtils.getTimestampString(this.mContext, new Date(lastMessage.getMsgTime())));
                if (lastMessage.direct() == EMMessage.Direct.SEND && lastMessage.status() == EMMessage.Status.FAIL) {
                    this.mMsgState.setVisibility(0);
                } else {
                    this.mMsgState.setVisibility(8);
                }
            }
            if (this.mentioned.getVisibility() != 0 && !TextUtils.isEmpty((CharSequence)(unSendMsg = EasePreferenceManager.getInstance().getUnSendMsgInfo(username)))) {
                this.mentioned.setText(R.string.were_not_send_msg);
                this.message.setText((CharSequence)unSendMsg);
                this.mentioned.setVisibility(0);
            }
        }
    }
}

