/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseEmojicon;
import java.util.List;

public class EmojiconGridAdapter
extends ArrayAdapter<EaseEmojicon> {
    private EaseEmojicon.Type emojiconType;

    public EmojiconGridAdapter(Context context, int textViewResourceId, List<EaseEmojicon> objects, EaseEmojicon.Type emojiconType) {
        super(context, textViewResourceId, objects);
        this.emojiconType = emojiconType;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.emojiconType == EaseEmojicon.Type.BIG_EXPRESSION ? View.inflate((Context)this.getContext(), (int)R.layout.ease_row_big_expression, null) : View.inflate((Context)this.getContext(), (int)R.layout.ease_row_expression, null);
        }
        ImageView imageView = (ImageView)convertView.findViewById(R.id.iv_expression);
        TextView textView = (TextView)convertView.findViewById(R.id.tv_name);
        EaseEmojicon emojicon = (EaseEmojicon)this.getItem(position);
        if (textView != null && emojicon.getName() != null) {
            textView.setText((CharSequence)emojicon.getName());
        }
        if ("em_delete_delete_expression".equals(emojicon.getEmojiText())) {
            imageView.setImageResource(R.drawable.ease_delete_expression);
        } else if (emojicon.getIcon() != 0) {
            imageView.setImageResource(emojicon.getIcon());
        } else if (emojicon.getIconPath() != null) {
            Glide.with((Context)this.getContext()).load(emojicon.getIconPath()).apply((BaseRequestOptions)RequestOptions.placeholderOf((int)R.drawable.ease_default_expression)).into(imageView);
        }
        return convertView;
    }
}

