/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.adapter;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hyphenate.easeui.adapter.EaseAdapterDelegate;
import com.hyphenate.easeui.adapter.EaseAdapterDelegatesManager;
import com.hyphenate.easeui.adapter.EaseBaseRecyclerViewAdapter;
import java.util.List;

public abstract class EaseBaseDelegateAdapter<T>
extends EaseBaseRecyclerViewAdapter<T> {
    private static final String TAG = "adapter";
    private EaseAdapterDelegatesManager delegatesManager;

    public EaseBaseDelegateAdapter() {
        this.delegatesManager = new EaseAdapterDelegatesManager(false);
    }

    public EaseBaseDelegateAdapter(EaseAdapterDelegatesManager delegatesManager) {
        this.delegatesManager = delegatesManager;
    }

    public EaseBaseDelegateAdapter addDelegate(EaseAdapterDelegate delegate) {
        this.delegatesManager.addDelegate(delegate, delegate.getTag());
        this.notifyDataSetChanged();
        return this;
    }

    public EaseBaseDelegateAdapter addDelegate(EaseAdapterDelegate delegate, String tag) {
        delegate.setTag(tag);
        return this.addDelegate(delegate);
    }

    public int getDelegateViewType(EaseAdapterDelegate delegate) {
        return this.delegatesManager.getDelegateViewType(delegate);
    }

    public EaseBaseDelegateAdapter setFallbackDelegate(EaseAdapterDelegate delegate, String tag) {
        delegate.setTag(tag);
        return this.setFallbackDelegate(delegate);
    }

    public EaseBaseDelegateAdapter setFallbackDelegate(EaseAdapterDelegate delegate) {
        this.delegatesManager.fallbackDelegate = delegate;
        return this;
    }

    public EaseAdapterDelegate getAdapterDelegate(int viewType) {
        return this.delegatesManager.getDelegate(viewType);
    }

    public List<EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder>> getAllDelegate() {
        return this.delegatesManager.getAllDelegates();
    }

    @Override
    public int getItemViewType(int position) {
        int viewType = 0;
        try {
            viewType = this.delegatesManager.getItemViewType(this.getItem(position), position);
        }
        catch (Exception e) {
            return super.getItemViewType(position);
        }
        return viewType;
    }

    @Override
    public EaseBaseRecyclerViewAdapter.ViewHolder getViewHolder(ViewGroup parent, int viewType) {
        return this.delegatesManager.onCreateViewHolder(parent, viewType);
    }

    @Override
    public void onBindViewHolder(@NonNull EaseBaseRecyclerViewAdapter.ViewHolder holder, int position) {
        super.onBindViewHolder(holder, position);
        if (this.isEmptyViewType(position)) {
            return;
        }
        if (this.mData == null || this.mData.isEmpty()) {
            return;
        }
        if (!this.delegatesManager.getAllDelegates().isEmpty()) {
            this.delegatesManager.onBindViewHolder(holder, position, this.getItem(position));
        }
    }

    public void onBindViewHolder(@NonNull EaseBaseRecyclerViewAdapter.ViewHolder holder, int position, @NonNull List<Object> payloads) {
        super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        if (this.isEmptyViewType(position)) {
            return;
        }
        if (this.mData == null || this.mData.isEmpty()) {
            return;
        }
        if (!this.delegatesManager.getAllDelegates().isEmpty()) {
            this.delegatesManager.onBindViewHolder(holder, position, payloads, this.getItem(position));
        }
    }

    public void onViewRecycled(@NonNull EaseBaseRecyclerViewAdapter.ViewHolder holder) {
        this.delegatesManager.onViewRecycled(holder);
    }

    public boolean onFailedToRecycleView(@NonNull EaseBaseRecyclerViewAdapter.ViewHolder holder) {
        return this.delegatesManager.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(@NonNull EaseBaseRecyclerViewAdapter.ViewHolder holder) {
        this.delegatesManager.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NonNull EaseBaseRecyclerViewAdapter.ViewHolder holder) {
        this.delegatesManager.onViewDetachedFromWindow(holder);
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        this.delegatesManager.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        this.delegatesManager.onDetachedFromRecyclerView(recyclerView);
    }
}

