/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.adapter;

import android.text.TextUtils;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SparseArrayCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.adapter.EaseAdapterDelegate;
import com.hyphenate.easeui.adapter.EaseBaseRecyclerViewAdapter;
import com.hyphenate.easeui.delegate.EaseMessageAdapterDelegate;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class EaseAdapterDelegatesManager {
    private boolean hasConsistItemType;
    private SparseArrayCompat<String> dataTypeWithTags = new SparseArrayCompat();
    private SparseArrayCompat<EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder>> delegates = new SparseArrayCompat();
    public EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder> fallbackDelegate;

    public EaseAdapterDelegatesManager(boolean hasConsistItemType) {
        this.hasConsistItemType = hasConsistItemType;
    }

    public EaseAdapterDelegatesManager addDelegate(EaseAdapterDelegate<?, ?> delegate, String tag) {
        Type superclass = this.getParameterizedType(delegate.getClass());
        if (!(superclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException(String.format("Please set the correct generic parameters on %s.", delegate.getClass().getName()));
        }
        Class clazz = (Class)((ParameterizedType)superclass).getActualTypeArguments()[0];
        String typeWithTag = this.typeWithTag(clazz, tag);
        int viewType = this.hasConsistItemType ? delegate.getItemViewType() : this.delegates.size();
        this.delegates.put(viewType, delegate);
        this.dataTypeWithTags.put(viewType, (Object)typeWithTag);
        return this;
    }

    private Type getParameterizedType(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Type superclass = clazz.getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            return superclass;
        }
        if (clazz.getName().equals("java.lang.Object")) {
            return null;
        }
        return this.getParameterizedType(clazz.getSuperclass());
    }

    @Nullable
    public EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder> getDelegate(int viewType) {
        EaseAdapterDelegate delegate = (EaseAdapterDelegate)this.delegates.get(viewType);
        if (delegate == null) {
            return this.fallbackDelegate;
        }
        return delegate;
    }

    public List<EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder>> getAllDelegates() {
        ArrayList<EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder>> list = new ArrayList<EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder>>();
        if (!this.delegates.isEmpty()) {
            for (int i = 0; i < this.delegates.size(); ++i) {
                list.add((EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder>)this.delegates.valueAt(i));
            }
        }
        if (this.fallbackDelegate != null) {
            list.add(this.fallbackDelegate);
        }
        return list;
    }

    public EaseBaseRecyclerViewAdapter.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder> delegate = this.getDelegate(viewType);
        if (delegate == null) {
            throw new NullPointerException("No EaseAdapterDelegate added for ViewType " + viewType);
        }
        String tag = this.getTagByViewType(viewType);
        return delegate.onCreateViewHolder(parent, tag);
    }

    public void onBindViewHolder(@NonNull EaseBaseRecyclerViewAdapter.ViewHolder holder, int position, Object item) {
        int viewType = holder.getAdapter().getItemViewType(position);
        EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder> delegate = this.getDelegate(viewType);
        if (delegate == null) {
            throw new NullPointerException("No delegate found for item at position = " + position + " for viewType = " + viewType);
        }
        delegate.onBindViewHolder(holder, position, this.targetItem(item));
    }

    public void onBindViewHolder(@NonNull EaseBaseRecyclerViewAdapter.ViewHolder holder, int position, @NonNull List<Object> payloads, Object item) {
        int viewType = holder.getAdapter().getItemViewType(position);
        EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder> delegate = this.getDelegate(viewType);
        if (delegate == null) {
            throw new NullPointerException("No delegate found for item at position = " + position + " for viewType = " + viewType);
        }
        delegate.onBindViewHolder(holder, position, payloads, this.targetItem(item));
    }

    public int getItemViewType(Object item, int position) {
        Class<?> clazz = this.targetItem(item).getClass();
        String tag = this.targetTag(item);
        String typeWithTag = this.typeWithTag(clazz, tag);
        List<Integer> indexList = this.indexesOfValue(this.dataTypeWithTags, typeWithTag);
        for (int index : indexList) {
            EaseAdapterDelegate delegate = (EaseAdapterDelegate)this.delegates.get(index);
            if (delegate == null || !delegate.getTags().contains(tag) || !delegate.isForViewType(item, position)) continue;
            return this.hasConsistItemType ? delegate.getItemViewType() : index;
        }
        if (this.fallbackDelegate != null && this.fallbackDelegate.isForViewType(item, position)) {
            int index = 0;
            if (this.fallbackDelegate.getTags().contains(tag)) {
                index = this.fallbackDelegate.getTags().indexOf(tag);
            }
            return this.hasConsistItemType ? this.fallbackDelegate.getItemViewType() + index : this.delegates.size() + index;
        }
        throw new NullPointerException("No EaseAdapterDelegate added that matches position = " + position + " item = " + this.targetItem(item) + " in data source.");
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder> delegate = this.getDelegate(holder.getItemViewType());
        if (delegate != null) {
            delegate.onViewRecycled(holder);
        }
    }

    public boolean onFailedToRecycleView(@NonNull RecyclerView.ViewHolder holder) {
        EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder> delegate = this.getDelegate(holder.getItemViewType());
        return delegate != null && delegate.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder> delegate = this.getDelegate(holder.getItemViewType());
        if (delegate != null) {
            delegate.onViewAttachedToWindow(holder);
        }
    }

    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        EaseAdapterDelegate<Object, EaseBaseRecyclerViewAdapter.ViewHolder> delegate = this.getDelegate(holder.getItemViewType());
        if (delegate != null) {
            delegate.onViewDetachedFromWindow(holder);
        }
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        for (int i = 0; i < this.delegates.size(); ++i) {
            EaseAdapterDelegate delegate = (EaseAdapterDelegate)this.delegates.get(i);
            if (delegate == null) continue;
            delegate.onAttachedToRecyclerView(recyclerView);
        }
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        for (int i = 0; i < this.delegates.size(); ++i) {
            EaseAdapterDelegate delegate = (EaseAdapterDelegate)this.delegates.get(i);
            if (delegate == null) continue;
            delegate.onDetachedFromRecyclerView(recyclerView);
        }
    }

    public int getDelegateViewType(EaseAdapterDelegate delegate) {
        int index = this.delegates.indexOfValue((Object)delegate);
        return index > 0 ? this.delegates.keyAt(index) : -1;
    }

    private String getTagByViewType(int viewType) {
        int index;
        if (this.dataTypeWithTags.containsKey(viewType)) {
            String typeWithTag = (String)this.dataTypeWithTags.get(viewType);
            if (TextUtils.isEmpty((CharSequence)typeWithTag)) {
                return typeWithTag;
            }
            if (!typeWithTag.contains(":")) {
                return typeWithTag;
            }
            return typeWithTag.split(":")[1];
        }
        int n = index = this.hasConsistItemType ? viewType - this.fallbackDelegate.getItemViewType() : viewType - this.delegates.size();
        if (this.fallbackDelegate.getTags().size() <= index) {
            return null;
        }
        return this.fallbackDelegate.getTags().get(index);
    }

    private String typeWithTag(Class<?> clazz, String tag) {
        return TextUtils.isEmpty((CharSequence)tag) ? clazz.getName() : clazz.getName() + ":" + tag;
    }

    private Object targetItem(Object item) {
        return item;
    }

    private String targetTag(Object item) {
        if (item instanceof EMMessage) {
            if (!this.delegates.isEmpty()) {
                boolean isChat = true;
                for (int i = 0; i < this.delegates.size(); ++i) {
                    int key = this.delegates.indexOfKey(i);
                    EaseAdapterDelegate delegate = (EaseAdapterDelegate)this.delegates.get(key);
                    if (delegate instanceof EaseMessageAdapterDelegate) continue;
                    isChat = false;
                    break;
                }
                return isChat ? ((EMMessage)item).direct().toString() : "";
            }
            return "";
        }
        return "";
    }

    private List<Integer> indexesOfValue(SparseArrayCompat<String> array, String value) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < array.size(); ++i) {
            if (!TextUtils.equals((CharSequence)((CharSequence)array.valueAt(i)), (CharSequence)value)) continue;
            indexes.add(array.keyAt(i));
        }
        return indexes;
    }
}

