/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.video.VideoCodecProfile;
import io.agora.base.internal.video.VideoCodecType;
import java.nio.ByteBuffer;

public class CodecSpecificInfo {
    private final ByteBuffer metadata;
    private ByteBuffer compressed_alpha_buffer;
    public long elapsedRealtime;

    public CodecSpecificInfo() {
        this(null, null);
    }

    public VideoCodecType getVideoCodecType() {
        return VideoCodecType.UNKNOWN;
    }

    public VideoCodecProfile getVideoCodecProfile() {
        return VideoCodecProfile.UNKNOWN;
    }

    @CalledByNative
    public CodecSpecificInfo(ByteBuffer metadata, ByteBuffer compressed_alpha_buffer) {
        this.metadata = metadata;
        this.compressed_alpha_buffer = compressed_alpha_buffer;
    }

    public CodecSpecificInfo(ByteBuffer metadata, long elapsedRealtime) {
        this.metadata = metadata;
        this.elapsedRealtime = elapsedRealtime;
    }

    @CalledByNative
    public ByteBuffer getMetadata() {
        return this.metadata;
    }

    @CalledByNative
    public ByteBuffer getCompressedAlphadata() {
        return this.compressed_alpha_buffer;
    }

    public class CodecSpecificInfoHEVC
    extends CodecSpecificInfo {
        private VideoCodecProfile profile;

        public CodecSpecificInfoHEVC(VideoCodecProfile profile) {
            this.profile = profile;
        }

        @Override
        public VideoCodecType getVideoCodecType() {
            return VideoCodecType.H265;
        }

        @Override
        public VideoCodecProfile getVideoCodecProfile() {
            return this.profile;
        }
    }

    public static class CodecSpecificInfoH264
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP9
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP8
    extends CodecSpecificInfo {
    }
}

