/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest.utils;

import fr.bmartel.protocol.http.HttpFrame;
import fr.bmartel.protocol.http.states.HttpStates;
import fr.bmartel.speedtest.inter.ISpeedTestListener;
import fr.bmartel.speedtest.inter.ISpeedTestSocket;
import fr.bmartel.speedtest.model.SpeedTestError;
import fr.bmartel.speedtest.model.UploadStorageType;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;

public class SpeedTestUtils {
    private static SecureRandom random = new SecureRandom();

    public static String generateFileName() {
        return new BigInteger(130, random).toString(32);
    }

    public static void dispatchError(ISpeedTestSocket speedTestSocket, boolean forceCloseSocket, List<ISpeedTestListener> listenerList, String errorMessage) {
        if (!forceCloseSocket) {
            for (int i = 0; i < listenerList.size(); ++i) {
                listenerList.get(i).onError(SpeedTestError.CONNECTION_ERROR, errorMessage);
            }
        } else {
            for (int i = 0; i < listenerList.size(); ++i) {
                listenerList.get(i).onCompletion(speedTestSocket.getLiveReport());
            }
        }
    }

    public static void dispatchError(ISpeedTestSocket speedTestSocket, boolean forceCloseSocket, List<ISpeedTestListener> listenerList, SpeedTestError error, String errorMessage) {
        if (!forceCloseSocket) {
            for (int i = 0; i < listenerList.size(); ++i) {
                listenerList.get(i).onError(error, errorMessage);
            }
        } else {
            for (int i = 0; i < listenerList.size(); ++i) {
                listenerList.get(i).onCompletion(speedTestSocket.getLiveReport());
            }
        }
    }

    public static byte[] readUploadData(UploadStorageType storageType, byte[] body, RandomAccessFile uploadFile, int uploadTempFileSize, int chunkSize) throws IOException {
        byte[] data;
        if (storageType == UploadStorageType.RAM_STORAGE) {
            data = Arrays.copyOfRange(body, uploadTempFileSize, uploadTempFileSize + chunkSize);
        } else {
            data = new byte[chunkSize];
            uploadFile.seek(uploadTempFileSize);
            uploadFile.read(data);
        }
        return data;
    }

    public static void dispatchSocketTimeout(boolean forceCloseSocket, List<ISpeedTestListener> listenerList, String errorMessage) {
        if (!forceCloseSocket) {
            for (int i = 0; i < listenerList.size(); ++i) {
                listenerList.get(i).onError(SpeedTestError.SOCKET_TIMEOUT, errorMessage);
            }
        }
    }

    public static void checkHttpFrameError(boolean forceCloseSocket, List<ISpeedTestListener> listenerList, HttpStates httFrameState) {
        if (httFrameState != HttpStates.HTTP_FRAME_OK && !forceCloseSocket) {
            for (int i = 0; i < listenerList.size(); ++i) {
                listenerList.get(i).onError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error occurred while parsing http frame");
            }
        }
    }

    public static void checkHttpHeaderError(boolean forceCloseSocket, List<ISpeedTestListener> listenerList, HttpStates httpHeaderState) {
        if (httpHeaderState != HttpStates.HTTP_FRAME_OK && !forceCloseSocket) {
            for (int i = 0; i < listenerList.size(); ++i) {
                listenerList.get(i).onError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error occurred while parsing http headers");
            }
        }
    }

    public static void checkHttpContentLengthError(boolean forceCloseSocket, List<ISpeedTestListener> listenerList, HttpFrame httpFrame) {
        if (httpFrame.getContentLength() <= 0 && !forceCloseSocket) {
            for (int i = 0; i < listenerList.size(); ++i) {
                listenerList.get(i).onError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error content length is inconsistent");
            }
        }
    }
}

