/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.log;

import android.util.Log;
import com.yy.yylivekit.log.ILog;

public final class YLKLog {
    private static final String TAG = "[YLK]";
    private static ILog yLKLogger;

    public static void registerLogger(ILog logger) {
        yLKLogger = logger;
    }

    public static void v(String tag, String msg) {
        if (yLKLogger != null) {
            yLKLogger.verbose(tag, msg);
        } else {
            Log.v((String)tag, (String)msg);
        }
    }

    public static void v(Object obj, String msg) {
        YLKLog.v(TAG + obj.getClass().getSimpleName(), msg);
    }

    public static void d(String tag, String msg) {
        if (yLKLogger != null) {
            yLKLogger.debug(tag, msg);
        } else {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void d(Object obj, String msg) {
        YLKLog.d(TAG + obj.getClass().getSimpleName(), msg);
    }

    public static void i(String tag, String msg) {
        if (yLKLogger != null) {
            yLKLogger.info(tag, msg);
        } else {
            Log.i((String)tag, (String)msg);
        }
    }

    public static void i(Object obj, String msg) {
        YLKLog.i(TAG + obj.getClass().getSimpleName(), msg);
    }

    public static void w(String tag, String msg) {
        if (yLKLogger != null) {
            yLKLogger.warn(tag, msg);
        } else {
            Log.w((String)tag, (String)msg);
        }
    }

    public static void w(Object obj, String msg) {
        YLKLog.w(TAG + obj.getClass().getSimpleName(), msg);
    }

    public static void e(String tag, String msg) {
        if (yLKLogger != null) {
            yLKLogger.error(tag, msg);
        } else {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void e(String tag, String msg, Throwable throwable) {
        if (yLKLogger != null) {
            yLKLogger.error(tag, msg, throwable);
        } else {
            YLKLog.printStackTraces(tag, throwable.getStackTrace());
        }
    }

    public static void e(Object obj, String msg) {
        YLKLog.e(TAG + obj.getClass().getSimpleName(), msg);
    }

    private static void printStackTraces(String tag, StackTraceElement[] traces) {
        Log.e((String)tag, (String)"------------------Start StackTrace------------------");
        for (StackTraceElement e : traces) {
            String info = e.toString();
            Log.e((String)tag, (String)info);
        }
        Log.e((String)tag, (String)"------------------ End StackTrace ------------------");
    }

    public static class YMFLogger
    implements com.yy.mediaframework.utils.ILog {
        public void verbose(String tag, String msg) {
            YLKLog.v(tag, msg);
        }

        public void debug(String tag, String msg) {
            YLKLog.d(tag, msg);
        }

        public void info(String tag, String msg) {
            YLKLog.i(tag, msg);
        }

        public void warn(String tag, String msg) {
            YLKLog.w(tag, msg);
        }

        public void error(String tag, String msg) {
            YLKLog.e(tag, msg);
        }

        public void error(String tag, String msg, Throwable t) {
            YLKLog.e(tag, msg, t);
        }
    }

    public static class Logger
    implements com.yyproto.report.ILog,
    com.yy.videoplayer.utils.ILog {
        public void verbose(String tag, String msg) {
            YLKLog.v(tag, msg);
        }

        public void debug(String tag, String msg) {
            YLKLog.d(tag, msg);
        }

        public void info(String tag, String msg) {
            YLKLog.i(tag, msg);
        }

        public void warn(String tag, String msg) {
            YLKLog.w(tag, msg);
        }

        public void error(String tag, String msg) {
            YLKLog.e(tag, msg);
        }

        public void error(String tag, String msg, Throwable t) {
            YLKLog.e(tag, msg, t);
        }
    }
}

