/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.utils;

import com.yy.yylivekit.Env;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.services.core.MarshalContainer;
import com.yy.yylivekit.services.core.Pack;
import com.yy.yylivekit.services.core.Uint16;
import com.yy.yylivekit.services.core.UnmarshalContainer;
import com.yy.yylivekit.services.core.Unpack;
import com.yy.yylivekit.utils.RuntimeKit;
import java.util.HashMap;
import java.util.Map;

public class Mob {
    private static final String TAG = "Mob";
    private static final Uint16 SubChannelIdKey = new Uint16(1);
    private static final Uint16 PlatformKey = new Uint16(2);
    private static final Uint16 DeviceIDKey = new Uint16(3);
    private static final Uint16 AppDataKey = new Uint16(5);
    private static final Uint16 VersionKey = new Uint16(6);
    private static final Uint16 AppIDKey = new Uint16(65012);
    private static final String PlatformAndroid = "1";

    public static byte[] encodeRequest(int majorType, int minorType, final long subCID, final String appData, byte[] payload) {
        Pack pack = new Pack();
        pack.push(new Uint16(majorType)).push(new Uint16(minorType));
        MarshalContainer.marshalMapUint16String(pack, (Map<Uint16, String>)new HashMap<Uint16, String>(){
            {
                this.put(AppDataKey, appData);
                this.put(SubChannelIdKey, String.valueOf(subCID));
                this.put(PlatformKey, Mob.PlatformAndroid);
                this.put(DeviceIDKey, Mob.getDeviceId());
                this.put(VersionKey, Mob.getVersion());
                this.put(AppIDKey, String.valueOf(Env.instance().appIDs().ent));
            }
        });
        pack.push(payload);
        return pack.toBytes();
    }

    public static void decodeResponse(byte[] bytes, ResponseHandler handler) {
        try {
            Unpack unpack = new Unpack(bytes);
            int majorType = unpack.popUint16().intValue();
            int minorType = unpack.popUint16().intValue();
            HashMap<Uint16, String> fields = new HashMap<Uint16, String>();
            UnmarshalContainer.unmarshalMapUint16String(unpack, fields);
            String appData = (String)fields.get(AppDataKey);
            if (appData != null && appData.isEmpty()) {
                appData = null;
            }
            byte[] payload = unpack.popBytes();
            handler.onDecodeSuccess(majorType, minorType, appData, payload);
        }
        catch (Exception e) {
            YLKLog.e(TAG, "[decodeResponse] throwable " + e);
            handler.onDecodeFailed();
        }
    }

    public static void decodeResponseUri(byte[] bytes, ResponseUriHandler handler) {
        try {
            Unpack unpack = new Unpack(bytes);
            int len = unpack.popUint32().intValue();
            int uri = unpack.popUint32().intValue();
            int resCode = unpack.popUint16().intValue();
            if (bytes.length > 10) {
                byte[] payload = new byte[bytes.length - 10];
                System.arraycopy(bytes, 10, payload, 0, payload.length);
                handler.onDecodeSuccess(uri, payload);
                YLKLog.i(TAG, String.format("decodeResponseUri len=%d, uri=%d, resCode=%d, payload.length=%d", len, uri, resCode, payload.length));
            } else {
                handler.onDecodeFailed();
            }
        }
        catch (Throwable e) {
            YLKLog.e(TAG, "[decodeResponseUri] throwable " + e);
            handler.onDecodeFailed();
        }
    }

    private static String getDeviceId() {
        String id = RuntimeKit.uniqueID(Env.instance().context());
        return id == null ? "" : id;
    }

    private static String getVersion() {
        return RuntimeKit.appVersion(Env.instance().context());
    }

    public static interface ResponseUriHandler {
        public void onDecodeSuccess(int var1, byte[] var2);

        public void onDecodeFailed();
    }

    public static interface ResponseHandler {
        public void onDecodeSuccess(int var1, int var2, String var3, byte[] var4);

        public void onDecodeFailed();
    }
}

