/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.utils;

import com.yy.yylivekit.log.YLKLog;
import com.yyproto.utils.FP;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import junit.framework.Assert;

public class Cleanup {
    private static final String TAG = "Cleanup";
    private final String groupName;
    private final Stack<Operation> cleanings = new Stack();
    private final Set<String> filterSet = new HashSet<String>();

    public Cleanup(String groupName) {
        this.groupName = groupName;
    }

    public void push(String desc, Runnable runnable) {
        Assert.assertNotNull((Object)runnable);
        this.cleanings.push(new Operation(desc, runnable));
    }

    public void addFilter(String name) {
        this.filterSet.add(name);
    }

    public void flush(FlushCallback callback) {
        YLKLog.i(TAG, "flush() called with: cleanings = [" + FP.size(this.cleanings) + "]");
        while (!this.cleanings.isEmpty()) {
            Operation op = this.cleanings.pop();
            String cleanupName = op.name;
            if (op.name == null) {
                cleanupName = "";
            }
            YLKLog.i("YLK", this.groupName + " | " + cleanupName);
            if (this.filterSet.contains(cleanupName)) continue;
            op.runnable.run();
            if (callback == null) continue;
            callback.onFlushOperation(op.name);
        }
        this.filterSet.clear();
    }

    private class Operation {
        private final String name;
        private final Runnable runnable;

        Operation(String name, Runnable runnable) {
            this.name = name;
            this.runnable = runnable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Operation operation = (Operation)o;
            return this.name.equals(operation.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static interface FlushCallback {
        public void onFlushOperation(String var1);
    }
}

