/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.observables;

import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.threading.Dispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;

public class ObservableValue<ValueType> {
    private static final String TAG = "ObservableValue";
    private static Dispatcher directDispatcher = new Dispatcher(){

        @Override
        public void dispatch(Runnable runnable) {
            runnable.run();
        }
    };
    private Map<Object, List<Observer<ValueType>>> groups = new HashMap<Object, List<Observer<ValueType>>>();
    private List<Observer<ValueType>> observers = new ArrayList<Observer<ValueType>>();
    private ValueType value;
    private List<Observer<ValueType>> nullGroup = new ArrayList<Observer<ValueType>>();

    public ObservableValue(ValueType initial) {
        this.value = initial;
    }

    public ValueType get() {
        return this.value;
    }

    public void set(final ValueType newValue) {
        if (newValue == this.value) {
            YLKLog.i(TAG, "set same value, ignore: oldValue = [" + this.value + "] newValue = [" + newValue + "] this\uff1a" + this);
            return;
        }
        YLKLog.i(TAG, "set called with: newValue = " + newValue + " oldValue = " + this.value + " this: " + this);
        ArrayList<Observer<ValueType>> cpy = new ArrayList<Observer<ValueType>>(this.observers);
        final ValueType oldValue = this.value;
        for (final Observer observer : cpy) {
            observer.dispatcher.dispatch(new Runnable(){

                @Override
                public void run() {
                    observer.willChange(oldValue, newValue);
                }
            });
        }
        this.value = newValue;
        for (final Observer observer : cpy) {
            observer.dispatcher.dispatch(new Runnable(){

                @Override
                public void run() {
                    observer.updated(false, oldValue, newValue);
                }
            });
        }
    }

    public void addObserver(Object group, boolean wantsInitial, Dispatcher dispatcher, final Observer<ValueType> observer) {
        List<Observer<ValueType>> obsGroup;
        ((Observer)observer).dispatcher = dispatcher == null ? ObservableValue.directDispatcher : dispatcher;
        if (group == null) {
            obsGroup = this.nullGroup;
        } else {
            obsGroup = this.groups.get(group);
            if (obsGroup == null) {
                obsGroup = new ArrayList<Observer<ValueType>>();
                this.groups.put(group, obsGroup);
            }
        }
        ((Observer)observer).group = obsGroup;
        obsGroup.add(observer);
        this.observers.add(observer);
        if (wantsInitial) {
            ((Observer)observer).dispatcher.dispatch(new Runnable(){

                @Override
                public void run() {
                    observer.updated(true, ObservableValue.this.value, ObservableValue.this.value);
                }
            });
        }
    }

    public void addObserver(Object group, boolean wantsInitial, Observer<ValueType> observer) {
        this.addObserver(group, wantsInitial, directDispatcher, observer);
    }

    public void removeObserver(Object group) {
        List<Observer<ValueType>> obsGroup = this.groups.get(group);
        if (obsGroup == null) {
            return;
        }
        this.observers.removeAll(obsGroup);
        obsGroup.clear();
        this.groups.remove(group);
    }

    public void removeObserver(Observer<ValueType> observer) {
        Assert.assertTrue((String)"\u65e0\u6cd5\u79fb\u9664\u4e00\u4e2a\u5df2\u7ecf\u4e0d\u5b58\u5728\u7684\u89c2\u5bdf\u8005", (boolean)this.observers.contains(observer));
        ((Observer)observer).group.remove(observer);
        this.observers.remove(observer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeGroupString(this.nullGroup, ""));
        for (Object g : this.groups.keySet()) {
            List<Observer<ValueType>> group = this.groups.get(g);
            String groupName = g.getClass().getSimpleName();
            sb.append(", ").append(this.makeGroupString(group, groupName));
        }
        return sb.toString();
    }

    private String makeGroupString(List<Observer<ValueType>> group, String groupName) {
        return "{" + groupName + ": " + String.valueOf(group.size()) + "}";
    }

    public void onlySave(ValueType newValue) {
        if (newValue == this.value) {
            YLKLog.i(TAG, "onlySave() called with: oldValue = [" + this.value + "]" + newValue + "[" + newValue + "]");
            return;
        }
        this.value = newValue;
    }

    public static abstract class Observer<InnerType> {
        private Dispatcher dispatcher;
        private List<Observer<InnerType>> group;

        public void willChange(InnerType from, InnerType to) {
        }

        public void updated(boolean isInitial, InnerType from, InnerType to) {
        }
    }
}

