/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.transfer;

import com.yy.yycloud.bs2.BS2ClientException;
import com.yy.yycloud.bs2.auth.BS2SessionCredentials;
import com.yy.yycloud.bs2.dns.DnsResolver;
import com.yy.yycloud.bs2.event.TransferStateChangeListener;
import com.yy.yycloud.bs2.model.BS2WebServiceRequest;
import com.yy.yycloud.bs2.model.DeleteRequest;
import com.yy.yycloud.bs2.transfer.BS2;
import com.yy.yycloud.bs2.transfer.Transfer;
import com.yy.yycloud.bs2.transfer.model.DeleteResult;
import com.yy.yycloud.bs2.utility.Logger;
import java.util.Map;
import java.util.concurrent.Callable;

class DeleteCallable
implements Callable<DeleteResult> {
    private static Logger log = Logger.getLogger(DeleteCallable.class);
    private BS2 bs2Client;
    private String bucket;
    private String key;
    private BS2SessionCredentials requestCredentials;
    private Integer retryTimes;
    private Integer retryInterval;
    private Integer connectTimeout;
    private Integer readTimeout;
    private Integer writeTimeout;
    private Map<String, String> customQueryParameters;
    private Map<String, String> customRequestHeaders;
    private DnsResolver dnsResolver;
    private TransferStateChangeListener transferStateChangeListener;
    private Transfer.TransferState state = Transfer.TransferState.Waiting;
    private BS2ClientException exception;

    public DeleteCallable(BS2 bs2Client, String bucket, String key, BS2SessionCredentials requestCredentials, Integer retryTimes, Integer retryInterval, Integer connectTimeout, Integer readTimeout, Integer writeTimeout, Map<String, String> customQueryParameters, Map<String, String> customRequestHeaders, DnsResolver dnsResolver, TransferStateChangeListener transferStateChangeListener) {
        this.bs2Client = bs2Client;
        this.bucket = bucket;
        this.key = key;
        this.requestCredentials = requestCredentials;
        this.retryTimes = retryTimes;
        this.retryInterval = retryInterval;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.customQueryParameters = customQueryParameters;
        this.customRequestHeaders = customRequestHeaders;
        this.dnsResolver = dnsResolver;
        this.transferStateChangeListener = transferStateChangeListener;
    }

    private void info(String msg, Object ... array) {
        log.info(String.format("[%d] ", this.hashCode()) + String.format(msg, array), new Object[0]);
    }

    private void warn(String msg, Object ... array) {
        log.warn(String.format("[%d] ", this.hashCode()) + String.format(msg, array), new Object[0]);
    }

    private void handleStart() throws InterruptedException {
        this.state = Transfer.TransferState.InProgress;
        this.transferStateChangeListener.transferStateChanged(this.state);
    }

    private void handleComplete() throws InterruptedException {
        this.state = Transfer.TransferState.Completed;
        this.transferStateChangeListener.transferStateChanged(this.state);
    }

    private void handleFailed() {
        this.state = Transfer.TransferState.Failed;
        this.transferStateChangeListener.transferStateChanged(this.state);
    }

    private void setCommonParam(BS2WebServiceRequest<? extends BS2WebServiceRequest> request) {
        if (this.customRequestHeaders != null) {
            for (Map.Entry<String, String> entry : this.customRequestHeaders.entrySet()) {
                request.putCustomRequestHeader(entry.getKey(), entry.getValue());
            }
        }
        if (this.customQueryParameters != null) {
            for (Map.Entry<String, String> entry : this.customQueryParameters.entrySet()) {
                request.putCustomQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (this.retryTimes != null) {
            request.withRetryTimes(this.retryTimes);
        }
        if (this.retryInterval != null) {
            request.withRetryInterval(this.retryInterval);
        }
        if (this.connectTimeout != null) {
            request.withConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout != null) {
            request.withReadTimeout(this.readTimeout);
        }
        if (this.writeTimeout != null) {
            request.withWriteTimeout(this.writeTimeout);
        }
        request.withRequestCredentials(this.requestCredentials).withDnsResolver(this.dnsResolver);
    }

    private void setException(Exception e) {
        if (e instanceof BS2ClientException) {
            this.exception = (BS2ClientException)e;
        }
        this.exception = new BS2ClientException(e.toString(), e);
    }

    @Override
    public DeleteResult call() throws Exception {
        this.info("bucket :%s, key :%s, retryTimes : %d, retryInterval : %d, connectTimeout :%d, readTimeout :%d, writeTimeout :%d", this.bucket, this.key, this.retryTimes, this.retryInterval, this.connectTimeout, this.readTimeout, this.writeTimeout);
        try {
            return this.Delete();
        }
        catch (Exception e) {
            this.warn("deletecallable throws exception, e :%s", e.toString());
            this.setException(e);
            this.handleFailed();
            throw e;
        }
    }

    private DeleteResult Delete() throws InterruptedException {
        this.handleStart();
        this.info("delete starts", new Object[0]);
        DeleteRequest deleteRequest = new DeleteRequest();
        this.setCommonParam(deleteRequest);
        deleteRequest.withBucketName(this.bucket).withKeyName(this.key);
        this.bs2Client.delete(deleteRequest);
        this.info("delete complete", new Object[0]);
        this.handleComplete();
        return new DeleteResult();
    }

    public Transfer.TransferState getState() {
        return this.state;
    }

    public BS2ClientException getException() {
        return this.exception;
    }
}

