/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.transfer;

import com.yy.yycloud.bs2.BS2ClientException;
import com.yy.yycloud.bs2.BS2ServiceException;
import com.yy.yycloud.bs2.auth.BS2SessionCredentials;
import com.yy.yycloud.bs2.conf.ConfigYYDomain;
import com.yy.yycloud.bs2.dns.DnsResolver;
import com.yy.yycloud.bs2.model.BS2WebServiceRequest;
import com.yy.yycloud.bs2.model.CompleteMultiPartUploadRequest;
import com.yy.yycloud.bs2.model.CompleteMultiPartUploadResult;
import com.yy.yycloud.bs2.model.DeleteRequest;
import com.yy.yycloud.bs2.model.DeleteResult;
import com.yy.yycloud.bs2.model.GetLastPartRequest;
import com.yy.yycloud.bs2.model.GetLastPartResult;
import com.yy.yycloud.bs2.model.InitMultiPartUploadRequest;
import com.yy.yycloud.bs2.model.InitMultiPartUploadResult;
import com.yy.yycloud.bs2.model.UploadOnceRequest;
import com.yy.yycloud.bs2.model.UploadOnceResult;
import com.yy.yycloud.bs2.model.UploadPartRequest;
import com.yy.yycloud.bs2.model.UploadPartResult;
import com.yy.yycloud.bs2.stat.StatReporter;
import com.yy.yycloud.bs2.stat.model.BS2ClientStat;
import com.yy.yycloud.bs2.stat.model.RequestStat;
import com.yy.yycloud.bs2.transfer.BS2;
import com.yy.yycloud.bs2.utility.Logger;
import com.yy.yycloud.bs2.utility.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

class BS2Client
implements BS2 {
    private static final String AUTH_HEADER = "Authorization";
    private static final String HOST_HEADER = "Host";
    private static final String CONTENTTYPE_HEADER = "Content-Type";
    private static final String CONTENTMD5_HEADER = "Content-MD5";
    private static final String ERRCODE_HEADER = "error-code";
    private static final String ETAG_HEADER = "ETag";
    private static final String BS2FILENAME_HEADER = "x-bs2-filename";
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final long MAX_SIZE_PER_REQUEST = 0x1000000L;
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final int DEFAULT_RETRY_TIMES = 2;
    private static final int DEFAULT_RETRY_INTERVAL = 2000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_READ_TIMEOUT = 120000;
    private static final int DEFAULT_WRITE_TIMEOUT = 120000;
    private OkHttpClient client;
    private BS2SessionCredentials credentials;
    private DnsResolver clientResolver;
    private static Logger log = Logger.getLogger(BS2Client.class);

    public BS2Client() {
        this(null, null);
    }

    public BS2Client(DnsResolver resolver) {
        this(null, resolver);
    }

    public BS2Client(BS2SessionCredentials credentials) {
        this(credentials, null);
    }

    public BS2Client(BS2SessionCredentials credentials, DnsResolver resolver) {
        this.credentials = credentials;
        this.clientResolver = resolver;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.proxy(Proxy.NO_PROXY);
        this.client = builder.build();
    }

    private void throwHttpClientException(Exception e) {
        log.warn("throw http client exception : %s", e.toString());
        BS2ServiceException bs2Exception = new BS2ServiceException(e.toString(), e);
        bs2Exception.setErrorType(BS2ServiceException.ErrorType.Service);
        throw bs2Exception;
    }

    private void throwHttpReponseException(int statusCode, String errorCode, String rawResponseContent) {
        log.warn("throw http response exception : statusCode = %d, errorCode = %s", statusCode, errorCode);
        BS2ServiceException bs2Exception = new BS2ServiceException("server http response code invalid");
        bs2Exception.setErrorType(BS2ServiceException.ErrorType.Service);
        bs2Exception.setStatusCode(statusCode);
        bs2Exception.setErrorCode(errorCode);
        bs2Exception.setRawResponseContent(rawResponseContent);
        throw bs2Exception;
    }

    private void addCustomHeaders(Request.Builder builder, Map<String, String> customHeaders) {
        if (customHeaders == null) {
            return;
        }
        for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
            if (entry.getKey().length() == 0) continue;
            builder.header(entry.getKey(), entry.getValue());
        }
    }

    private String addCustomQueryString(String queryString, Map<String, String> customQueryParam, String exclusiveKeys) {
        if (customQueryParam == null) {
            return queryString;
        }
        String[] exclusiveKeysArray = exclusiveKeys.split("\\|");
        for (Map.Entry<String, String> entry : customQueryParam.entrySet()) {
            if (entry.getKey().length() == 0) continue;
            boolean isExclusive = false;
            for (String s : exclusiveKeysArray) {
                if (!s.toLowerCase().equals(entry.getKey().toLowerCase())) continue;
                isExclusive = true;
                break;
            }
            if (isExclusive) continue;
            if (queryString.length() == 0) {
                queryString = queryString + String.format("?%s=%s", URLEncoder.encode(entry.getKey()), URLEncoder.encode(entry.getValue()));
                continue;
            }
            queryString = queryString + String.format("&%s=%s", URLEncoder.encode(entry.getKey()), URLEncoder.encode(entry.getValue()));
        }
        return queryString;
    }

    private List<String> getIpList(String host, DnsResolver resovler) {
        if (resovler == null) {
            return null;
        }
        List<String> iplist = null;
        try {
            iplist = resovler.resovle(host);
            if (iplist == null || iplist.size() == 0) {
                throw new BS2ClientException("iplist from dns resolver is empty, check implemention");
            }
            Collections.shuffle(iplist);
            return iplist;
        }
        catch (BS2ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BS2ClientException(e.toString(), e);
        }
    }

    private String getAddr(String host, List<String> iplist, String lastAddr) {
        if (iplist == null) {
            return host;
        }
        if (iplist.size() == 1) {
            return iplist.get(0);
        }
        int nextIndex = iplist.indexOf(lastAddr) + 1;
        if (nextIndex >= iplist.size()) {
            nextIndex = 0;
        }
        return iplist.get(nextIndex);
    }

    private void sleep(int milliSeconds) {
        try {
            TimeUnit.MILLISECONDS.sleep(milliSeconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Response execute(String bucket, String key, BS2WebServiceRequest<? extends BS2WebServiceRequest> request, String method, String host, String path, String queryString, String exclusiveKeys, byte[] data) {
        String txRequestId = request.getCustomQueryParameters() == null ? null : request.getCustomQueryParameters().get("txrequestid");
        String bcRequestId = Utility.generateRequestId();
        request.putCustomQueryParameter("bcrequestid", bcRequestId);
        queryString = this.addCustomQueryString(queryString, request.getCustomQueryParameters(), exclusiveKeys);
        BS2SessionCredentials credentials = request.getRequestCredentials() == null ? this.credentials : request.getRequestCredentials();
        Utility.rejectNull(credentials, "credentials is not setted");
        Integer userRetryTimes = request.getRetryTimes();
        int retryTimes = userRetryTimes == null ? 2 : userRetryTimes;
        Integer userRetryInterval = request.getRetryInterval();
        int retryInterval = userRetryInterval == null ? 2000 : userRetryInterval;
        Integer userConnectTimeout = request.getConnectTimeout();
        int connectTimeout = userConnectTimeout == null ? 30000 : userConnectTimeout;
        Integer userReadTimeout = request.getReadTimeout();
        int readTimeout = userReadTimeout == null ? 120000 : userReadTimeout;
        Integer userWriteTimeout = request.getWriteTimeout();
        int writeTimeout = userWriteTimeout == null ? 120000 : userWriteTimeout;
        String userContentType = request.getCustomRequestHeaders() == null ? null : request.getCustomRequestHeaders().get(CONTENTTYPE_HEADER);
        String contentType = userContentType == null ? DEFAULT_CONTENT_TYPE : userContentType;
        BS2ClientStat bcStat = new BS2ClientStat();
        bcStat.txRequestId = txRequestId;
        bcStat.bcRequestId = bcRequestId;
        bcStat.bucketName = bucket;
        bcStat.keyName = key;
        bcStat.host = host;
        bcStat.method = method;
        bcStat.path = path;
        bcStat.queryString = queryString;
        bcStat.confRetryTimes = retryTimes;
        bcStat.confRetryInterval = retryInterval;
        bcStat.confConnectTimeout = connectTimeout;
        bcStat.confReadTimeout = readTimeout;
        bcStat.confWriteTimeout = writeTimeout;
        bcStat.bodyLength = data == null ? null : Long.valueOf(data.length);
        OkHttpClient.Builder cloneBuilder = this.client.newBuilder();
        cloneBuilder.connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS);
        cloneBuilder.readTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        cloneBuilder.writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS);
        OkHttpClient clientPerRequest = cloneBuilder.build();
        String md5_64_code = "";
        if (data.length > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.reset();
                md.update(data);
                md5_64_code = Utility.encodeBase64(md.digest());
            }
            catch (NoSuchAlgorithmException e) {
                log.error(" content data md5 error %s", e);
            }
        }
        try {
            bcStat.startTick = System.currentTimeMillis();
            long dnsStartTick = System.currentTimeMillis();
            DnsResolver resovler = request.getDnsResolver() == null ? this.clientResolver : request.getDnsResolver();
            List<String> iplist = this.getIpList(host, resovler);
            bcStat.dnsTime = System.currentTimeMillis() - dnsStartTick;
            bcStat.resovledIp = iplist == null ? host : Utility.joinString(",", iplist);
            int triedTimes = 0;
            String addr = "";
            while (triedTimes <= retryTimes) {
                bcStat.statusCode = null;
                bcStat.errorCode = null;
                RequestStat reqStat = new RequestStat();
                reqStat.txRequestId = txRequestId;
                reqStat.bcRequestId = bcRequestId;
                reqStat.bucketName = bucket;
                reqStat.keyName = key;
                reqStat.host = host;
                reqStat.method = method;
                reqStat.path = path;
                reqStat.queryString = queryString;
                reqStat.bodyLength = data == null ? null : Long.valueOf(data.length);
                try {
                    RequestBody body;
                    reqStat.startTick = System.currentTimeMillis();
                    bcStat.triedTimes = ++triedTimes;
                    long tokenStartTick = System.currentTimeMillis();
                    String token = credentials.getSessionToken(bucket, key, method);
                    reqStat.tokenTime = System.currentTimeMillis() - tokenStartTick;
                    Request.Builder builder = new Request.Builder();
                    this.addCustomHeaders(builder, request.getCustomRequestHeaders());
                    if (method.equals(GET_METHOD)) {
                        builder.get();
                    } else if (method.equals(POST_METHOD)) {
                        Utility.rejectNull(data, "data is not setted");
                        body = RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])data);
                        builder.post(body);
                    } else if (method.equals(PUT_METHOD)) {
                        Utility.rejectNull(data, "data is not setted");
                        body = RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])data);
                        builder.put(body);
                    } else if (method.equals(DELETE_METHOD)) {
                        builder.delete();
                    } else {
                        throw new IllegalArgumentException("invalid method name");
                    }
                    reqStat.serverIp = addr = this.getAddr(host, iplist, addr);
                    String url = String.format("http://%s/%s%s", addr, path, queryString);
                    if (data.length > 0) {
                        builder.header(CONTENTMD5_HEADER, md5_64_code);
                    }
                    Request httpRequest = builder.url(url).header(AUTH_HEADER, token).header(HOST_HEADER, host).build();
                    log.info("execute request , method:%s, url: %s, host: %s, path: %s , token: %s , triedTimes: %d , contentType: %s", method, url, host, path, token, triedTimes, contentType);
                    long requestStartTick = System.currentTimeMillis();
                    Response response = clientPerRequest.newCall(httpRequest).execute();
                    reqStat.requestTime = System.currentTimeMillis() - requestStartTick;
                    log.info("execute request statuscode:%d , method:%s, url: %s , path : %s ", response.code(), method, url, path);
                    reqStat.statusCode = String.valueOf(response.code());
                    reqStat.errorCode = response.header(ERRCODE_HEADER);
                    bcStat.statusCode = reqStat.statusCode;
                    bcStat.errorCode = reqStat.errorCode;
                    if (response.isSuccessful()) {
                        Response response2 = response;
                        return response2;
                    }
                    if (response.code() >= 500 && triedTimes <= retryTimes) {
                        log.warn("execute request server internal error,try again. statuscode:%d , method:%s, url: %s , path: %s ", response.code(), method, url, path);
                        this.sleep(retryInterval);
                        continue;
                    }
                    this.throwHttpReponseException(response.code(), response.header(ERRCODE_HEADER), response.body().string());
                }
                catch (BS2ClientException e) {
                    reqStat.exception = Utility.getStackTrace(e);
                    throw e;
                }
                catch (ProtocolException e) {
                    reqStat.exception = Utility.getStackTrace(e);
                    this.throwHttpClientException(e);
                }
                catch (IOException e) {
                    reqStat.exception = Utility.getStackTrace(e);
                    if (triedTimes <= retryTimes) {
                        log.warn("execute request server connect error,try again. exception %s, host: %s , path: %s ", e.toString(), host, path);
                        this.sleep(retryInterval);
                        continue;
                    }
                    this.throwHttpClientException(e);
                }
                catch (Exception e) {
                    reqStat.exception = Utility.getStackTrace(e);
                    e.printStackTrace();
                    log.warn("execute request client exception. exception %s, host: %s , path: %s ", e.toString(), host, path);
                    throw new BS2ClientException(e.toString(), e);
                }
                finally {
                    reqStat.endTick = System.currentTimeMillis();
                    StatReporter.report(reqStat);
                }
            }
        }
        catch (Exception e) {
            bcStat.exception = Utility.getStackTrace(e);
            throw e;
        }
        finally {
            bcStat.endTick = System.currentTimeMillis();
            StatReporter.report(bcStat);
        }
        throw new IllegalStateException("unreachable code");
    }

    private byte[] readInput(InputStream input, int expectedSize) {
        byte[] data = new byte[expectedSize];
        try {
            int bytesRead;
            int ret;
            for (bytesRead = 0; bytesRead < expectedSize && (ret = input.read(data, bytesRead, expectedSize - bytesRead)) != -1; bytesRead += ret) {
            }
            if (bytesRead < expectedSize) {
                data = Arrays.copyOf(data, bytesRead);
            }
            return data;
        }
        catch (IOException e) {
            log.warn("read inputstream exception %s, uploadId: %d", e.toString(), expectedSize);
            BS2ClientException bs2Exception = new BS2ClientException(e.toString(), e);
            throw bs2Exception;
        }
    }

    private UploadToken parseUploadToken(String uploadToken) {
        Utility.rejectNull(uploadToken, "upload token can't be null");
        Utility.rejectEmptyValue(uploadToken, "upload token can't be empty string");
        String[] components = uploadToken.split("/");
        if (components.length != 3 || !components[0].equals("v1")) {
            throw new IllegalArgumentException("upload token format error");
        }
        String zone = components[1];
        String uploadId = components[2];
        Utility.rejectEmptyValue(uploadId, "uploadId can't be empty string");
        Utility.rejectEmptyValue(zone, "zone can't be empty string");
        UploadToken token = new UploadToken();
        token.zone = zone;
        token.uploadId = uploadId;
        return token;
    }

    private String uploadToken(String zone, String uploadId) {
        return String.format("v1/%s/%s", zone, uploadId);
    }

    @Override
    public UploadOnceResult uploadOnce(UploadOnceRequest request) throws BS2ServiceException, BS2ClientException {
        Utility.rejectNull(request, "request can't be null");
        String bucket = request.getBucketName();
        String key = request.getKeyName();
        Long size = request.getSize();
        InputStream input = request.getInput();
        Utility.rejectNull(bucket, "bucketname is not setted");
        Utility.rejectNull(key, "keyname is not setted");
        Utility.rejectNull(size, "size is not setted");
        Utility.rejectNull(input, "input is not setted");
        Utility.rejectEmptyValue(bucket, "bucketname can't be empty string");
        Utility.rejectEmptyValue(size, "size can't be 0");
        if (size > 0x1000000L) {
            throw new IllegalArgumentException("size is too large for one request");
        }
        byte[] content = this.readInput(input, size.intValue() + 1);
        UploadOnceResult result = new UploadOnceResult();
        if ((long)content.length != size) {
            throw new IllegalArgumentException("input stream size not equals to size param");
        }
        String host = bucket + ConfigYYDomain.getBs2UploadDomain();
        Response response = this.execute(bucket, key, request, PUT_METHOD, host, key, "", "", content);
        try {
            String etag = response.header(ETAG_HEADER);
            Utility.rejectNull(etag, "etag is null");
            Utility.rejectEmptyValue(etag, "etag is empty");
            String bs2FileName = response.header(BS2FILENAME_HEADER);
            if (key.length() == 0) {
                Utility.rejectNull(bs2FileName, "bs2filename is null");
                Utility.rejectEmptyValue(bs2FileName, "bs2filename is empty");
            }
            String downloadUrl = String.format("http://%s/%s", bucket + ConfigYYDomain.getBs2DownloadDomain(), key.length() != 0 ? key : bs2FileName);
            log.info("onceupload request response. etag: %s, bs2filename: %s, host: %s , path: %s , downloadUrl: %s ", etag, bs2FileName, host, key, downloadUrl);
            result.setBytesTransfered(content.length);
            result.setETag(etag);
            result.setDownloadUrl(downloadUrl);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("onceupload request result exception. exception %s, host: %s , path: %s ", e.toString(), host, key);
            BS2ServiceException bs2Exception = new BS2ServiceException(e.toString(), e);
            bs2Exception.setErrorType(BS2ServiceException.ErrorType.Service);
            throw bs2Exception;
        }
    }

    @Override
    public InitMultiPartUploadResult initMultiPartUpload(InitMultiPartUploadRequest request) throws BS2ServiceException, BS2ClientException {
        Utility.rejectNull(request, "request can't be null");
        String bucket = request.getBucketName();
        String key = request.getKeyName();
        Utility.rejectNull(bucket, "bucketname is not setted");
        Utility.rejectNull(key, "keyname is not setted");
        Utility.rejectEmptyValue(bucket, "bucketname can't be empty string");
        Utility.rejectEmptyValue(key, "keyname can't be empty string");
        String host = bucket + ConfigYYDomain.getBs2UploadDomain();
        String content = "";
        Response response = this.execute(bucket, key, request, POST_METHOD, host, key, "?uploads", "uploads", content.getBytes());
        try {
            String body = response.body().string();
            log.info("initmultipartupload request response. body: %s, host: %s , path: %s ", body, host, key);
            JSONObject json = new JSONObject(body.trim());
            String zone = json.getString("zone");
            String uploadId = json.getString("uploadid");
            Utility.rejectEmptyValue(zone, "zone is empty");
            Utility.rejectEmptyValue(uploadId, "uploadId is empty");
            InitMultiPartUploadResult result = new InitMultiPartUploadResult();
            result.setUploadId(this.uploadToken(zone, uploadId));
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("initmultipartupload request result exception. exception %s, host: %s , path: %s ", e.toString(), host, key);
            BS2ServiceException bs2Exception = new BS2ServiceException(e.toString(), e);
            bs2Exception.setErrorType(BS2ServiceException.ErrorType.Service);
            throw bs2Exception;
        }
    }

    @Override
    public GetLastPartResult getLastPart(GetLastPartRequest request) throws BS2ServiceException, BS2ClientException {
        String zone;
        Utility.rejectNull(request, "request can't be null");
        String bucket = request.getBucketName();
        String key = request.getKeyName();
        Utility.rejectNull(bucket, "bucketname is not setted");
        Utility.rejectNull(key, "keyname is not setted");
        Utility.rejectEmptyValue(bucket, "bucketname can't be empty string");
        Utility.rejectEmptyValue(key, "keyname can't be empty string");
        UploadToken uploadToken = this.parseUploadToken(request.getUploadId());
        String uploadId = uploadToken.uploadId;
        String host = zone = uploadToken.zone;
        String queryString = String.format("?getlastpart&uploadid=%s", uploadId);
        String content = "";
        Response response = this.execute(bucket, key, request, GET_METHOD, host, key, queryString, "getlastpart|uploadid", content.getBytes());
        try {
            String body = response.body().string();
            log.info("getlastpart request response. body: %s, host: %s , path: %s ", body, host, key);
            JSONObject json = new JSONObject(body.trim());
            String lastZone = json.getString("zone");
            String lastUploadId = json.getString("uploadid");
            int partNumber = json.getInt("partnumber");
            long currentSize = json.getLong("currentsize");
            Utility.rejectEmptyValue(lastZone, "zone is empty");
            Utility.rejectEmptyValue(lastUploadId, "uploadId is empty");
            GetLastPartResult result = new GetLastPartResult();
            result.setUploadId(this.uploadToken(lastZone, lastUploadId));
            result.setPartNumber(partNumber);
            result.setCurrentSize(currentSize);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("getlastpart request result exception. exception %s, host: %s , path: %s ", e.toString(), host, key);
            BS2ServiceException bs2Exception = new BS2ServiceException(e.toString(), e);
            bs2Exception.setErrorType(BS2ServiceException.ErrorType.Service);
            throw bs2Exception;
        }
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws BS2ServiceException, BS2ClientException {
        Utility.rejectNull(request, "request can't be null");
        String bucket = request.getBucketName();
        String key = request.getKeyName();
        Integer partNumber = request.getPartNumber();
        Long partSize = request.getPartSize();
        InputStream input = request.getInput();
        Utility.rejectNull(bucket, "bucketname is not setted");
        Utility.rejectNull(key, "keyname is not setted");
        Utility.rejectNull(partNumber, "partNumber is not setted");
        Utility.rejectNull(partSize, "partSize is not setted");
        Utility.rejectNull(input, "input is not setted");
        Utility.rejectEmptyValue(bucket, "bucketname can't be empty string");
        Utility.rejectEmptyValue(key, "keyname can't be empty string");
        Utility.rejectEmptyValue(partSize, "partSize can't be 0");
        UploadToken uploadToken = this.parseUploadToken(request.getUploadId());
        String uploadId = uploadToken.uploadId;
        String zone = uploadToken.zone;
        if (partSize > 0x1000000L) {
            throw new IllegalArgumentException("size is too large for one request");
        }
        UploadPartResult result = new UploadPartResult();
        byte[] content = this.readInput(input, partSize.intValue());
        log.info("partupload . content.length: %d , partSize: %d ", content.length, partSize);
        if (content.length == 0) {
            result.setBytesTransfered(0L);
            return result;
        }
        String host = zone;
        String queryString = String.format("?uploadid=%s&partnumber=%d", uploadId, (int)partNumber);
        this.execute(bucket, key, request, PUT_METHOD, host, key, queryString, "uploadid|partnumber", content);
        result.setBytesTransfered(content.length);
        return result;
    }

    @Override
    public CompleteMultiPartUploadResult completeMultiPartUpload(CompleteMultiPartUploadRequest request) throws BS2ServiceException, BS2ClientException {
        String zone;
        Utility.rejectNull(request, "request can't be null");
        String bucket = request.getBucketName();
        String key = request.getKeyName();
        Long partCount = request.getPartCount();
        Utility.rejectNull(bucket, "bucketname is not setted");
        Utility.rejectNull(key, "keyname is not setted");
        Utility.rejectNull(partCount, "partCount is not setted");
        Utility.rejectEmptyValue(bucket, "bucketname can't be empty string");
        Utility.rejectEmptyValue(key, "keyname can't be empty string");
        Utility.rejectEmptyValue(partCount, "partCount can't be 0");
        UploadToken uploadToken = this.parseUploadToken(request.getUploadId());
        String uploadId = uploadToken.uploadId;
        String host = zone = uploadToken.zone;
        String content = String.format("{ \"partcount\": %d }", partCount.intValue());
        String queryString = String.format("?uploadid=%s", uploadId);
        Response response = this.execute(bucket, key, request, POST_METHOD, host, key, queryString, "uploadid", content.getBytes());
        try {
            String etag = response.header(ETAG_HEADER);
            Utility.rejectNull(etag, "etag is null");
            Utility.rejectEmptyValue(etag, "etag is empty");
            String downloadUrl = String.format("http://%s/%s", bucket + ConfigYYDomain.getBs2DownloadDomain(), key);
            log.info("completemultipartupload request response. etag: %s, host: %s , path: %s , downloadUrl: %s", etag, host, key, downloadUrl);
            CompleteMultiPartUploadResult result = new CompleteMultiPartUploadResult();
            result.setETag(etag);
            result.setDownloadUrl(downloadUrl);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("completemultipartupload request result exception. exception %s, host: %s , path: %s ", e.toString(), host, key);
            BS2ServiceException bs2Exception = new BS2ServiceException(e.toString(), e);
            bs2Exception.setErrorType(BS2ServiceException.ErrorType.Service);
            throw bs2Exception;
        }
    }

    @Override
    public DeleteResult delete(DeleteRequest request) throws BS2ServiceException, BS2ClientException {
        Utility.rejectNull(request, "request can't be null");
        String bucket = request.getBucketName();
        String key = request.getKeyName();
        Utility.rejectNull(bucket, "bucketname is not setted");
        Utility.rejectNull(key, "keyname is not setted");
        Utility.rejectEmptyValue(bucket, "bucketname can't be empty string");
        Utility.rejectEmptyValue(key, "keyname can't be empty string");
        String host = bucket + ConfigYYDomain.getBs2Domain();
        String content = "";
        this.execute(bucket, key, request, DELETE_METHOD, host, key, "", "", content.getBytes());
        return new DeleteResult();
    }

    private static class UploadToken {
        public String zone;
        public String uploadId;

        private UploadToken() {
        }
    }
}

