/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.downloader.impl;

import com.yy.yycloud.bs2.downloader.impl.DownloadTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DownloaderThreadPool {
    private static final int core_pool_size = 5;
    private static final int max_pool_size = 5;
    private static final int keep_alive_time = 1;
    private static final TimeUnit keep_alive_time_unit = TimeUnit.SECONDS;
    private ExecutorService m_executor_server;
    private final BlockingQueue<Runnable> mDownloadWorkQueue = new LinkedBlockingQueue<Runnable>();

    public boolean run() {
        if (null != this.m_executor_server) {
            return true;
        }
        this.m_executor_server = new ThreadPoolExecutor(5, 5, 1L, keep_alive_time_unit, this.mDownloadWorkQueue);
        return true;
    }

    public boolean addTask(DownloadTask r) {
        if (null == this.m_executor_server) {
            return false;
        }
        this.m_executor_server.execute(r);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseTask(DownloadTask task) {
        DownloaderThreadPool downloaderThreadPool = this;
        synchronized (downloaderThreadPool) {
            Thread thread = task.getThread();
            if (null != thread) {
                thread.suspend();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resumeTask(DownloadTask task) {
        DownloaderThreadPool downloaderThreadPool = this;
        synchronized (downloaderThreadPool) {
            Thread thread = task.getThread();
            if (null != thread) {
                thread.resume();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopTask(DownloadTask task) {
        DownloaderThreadPool downloaderThreadPool = this;
        synchronized (downloaderThreadPool) {
            Thread thread = task.getThread();
            if (null != thread) {
                thread.interrupt();
            }
            this.mDownloadWorkQueue.remove(task);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelAll() {
        DownloaderThreadPool downloaderThreadPool = this;
        synchronized (downloaderThreadPool) {
            DownloadTask[] taskArray = new DownloadTask[this.mDownloadWorkQueue.size()];
            this.mDownloadWorkQueue.toArray(taskArray);
            int len = taskArray.length;
            for (int taskArrayIndex = 0; taskArrayIndex < len; ++taskArrayIndex) {
                Thread thread = taskArray[taskArrayIndex].getThread();
                if (null == thread) continue;
                thread.interrupt();
            }
        }
        return true;
    }
}

