/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.yyanchor.facedetection;

import android.annotation.SuppressLint;
import android.content.Context;
import com.unionyy.mobile.yyanchor.facedetection.FaceDetectionManager;
import com.unionyy.mobile.yyanchor.facedetection.VenusAdapter;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import tv.athena.util.toast.ToastUtil;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/unionyy/mobile/yyanchor/facedetection/FaceDetectionManager;", "", "()V", "Companion", "yyanchor_release"})
public final class FaceDetectionManager {
    private static final String TAG = "FaceDetectionManager";
    public static final int FD_TYPE_UNKNOWN = 0;
    public static final int FD_TYPE_ST = 1;
    public static final int FD_TYPE_VENUS = 2;
    private static final String VENUS_MODEL_NAME = "venus_model/venus_cpu_data_model.zip";
    private static final String VENUS_MODEL_BASE_DIR;
    private static final String VENUS_MODEL_DIR;
    private static int mCurrentSdk;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        StringBuilder stringBuilder = new StringBuilder();
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        Context context = basicConfig.getAppContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"BasicConfig.getInstance().appContext");
        File file = context.getFilesDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"BasicConfig.getInstance().appContext.filesDir");
        VENUS_MODEL_BASE_DIR = stringBuilder.append(file.getAbsolutePath()).append(File.separator).append("venus_model").toString();
        VENUS_MODEL_DIR = VENUS_MODEL_BASE_DIR + File.separator + "venus_face_data" + File.separator;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0015\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0004J\b\u0010\u001a\u001a\u00020\u000eH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/unionyy/mobile/yyanchor/facedetection/FaceDetectionManager$Companion;", "", "()V", "FD_TYPE_ST", "", "FD_TYPE_UNKNOWN", "FD_TYPE_VENUS", "TAG", "", "VENUS_MODEL_BASE_DIR", "VENUS_MODEL_DIR", "VENUS_MODEL_NAME", "mCurrentSdk", "checkFile", "", "models", "", "([Ljava/lang/String;)V", "getModelFileDir", "Ljava/io/File;", "modelFileExist", "", "prepareVenusModelFile", "()[Ljava/lang/String;", "setFDSdk", "fdSdk", "unzipModelFileAndSetPath", "yyanchor_release"})
    public static final class Companion {
        public final void setFDSdk(int fdSdk) {
            BasicConfig basicConfig = BasicConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
            if (basicConfig.isDebuggable()) {
                ToastUtil.showToast((String)(fdSdk == 2 ? "\u4f7f\u7528venus" : "\u4f7f\u7528\u5546\u6c64"));
            }
            MLog.info((Object)FaceDetectionManager.TAG, (String)("setFDSdk called, fdSdk = " + fdSdk + ", mCurrentSdk = " + mCurrentSdk), (Object[])new Object[0]);
            if (fdSdk == 0 || mCurrentSdk == fdSdk) {
                return;
            }
            mCurrentSdk = fdSdk;
            if (mCurrentSdk == 2) {
                if (this.modelFileExist()) {
                    VenusAdapter.INSTANCE.switchFaceDetectionSdk(true, this.prepareVenusModelFile());
                } else {
                    this.unzipModelFileAndSetPath();
                }
            } else {
                VenusAdapter.INSTANCE.switchFaceDetectionSdk(false, null);
            }
        }

        @SuppressLint(value={"CheckResult"})
        private final void unzipModelFileAndSetPath() {
            Flowable.just((Object)FaceDetectionManager.VENUS_MODEL_NAME).subscribeOn(Schedulers.io()).map((Function)unzipModelFileAndSetPath.1.INSTANCE).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)unzipModelFileAndSetPath.2.INSTANCE, RxUtils.errorConsumer((String)FaceDetectionManager.TAG));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean modelFileExist() {
            String[] contents = new File(VENUS_MODEL_DIR).list();
            if (contents == null) return false;
            String[] stringArray = contents;
            boolean bl = false;
            String[] stringArray2 = stringArray;
            boolean bl2 = false;
            if (stringArray2.length != 0) return true;
            return false;
        }

        private final String[] prepareVenusModelFile() {
            String[] paths = new String[]{VENUS_MODEL_DIR + "model0.vnmodel", VENUS_MODEL_DIR + "model1.vnmodel", VENUS_MODEL_DIR + "model2.vnmodel", VENUS_MODEL_DIR + "model3.vnmodel", VENUS_MODEL_DIR + "model4.vnmodel", VENUS_MODEL_DIR + "model5.vnmodel", VENUS_MODEL_DIR + "model6.vnmodel"};
            this.checkFile(paths);
            return paths;
        }

        private final void checkFile(String[] models) {
            MLog.info((Object)FaceDetectionManager.TAG, (String)"checkFile called", (Object[])new Object[0]);
            for (String model : models) {
                File f = new File(model);
                MLog.info((Object)FaceDetectionManager.TAG, (String)("checkFile called, f.exists() = " + f.exists() + ", path = " + model), (Object[])new Object[0]);
            }
        }

        private final File getModelFileDir() {
            File modelFileDir = new File(VENUS_MODEL_BASE_DIR);
            if (!modelFileDir.exists()) {
                modelFileDir.mkdirs();
            }
            return modelFileDir;
        }

        private Companion() {
        }

        public static final /* synthetic */ File access$getModelFileDir(Companion $this) {
            return $this.getModelFileDir();
        }

        public static final /* synthetic */ String[] access$prepareVenusModelFile(Companion $this) {
            return $this.prepareVenusModelFile();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

