/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.translianmai.viewmodel;

import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.ViewModel;
import android.os.Bundle;
import com.unionyy.mobile.translianmai.core.ITransLianmaiCore;
import com.unionyy.mobile.translianmai.core.TransLianmaiManager;
import com.unionyy.mobile.translianmai.data.LianmaiSession;
import com.unionyy.mobile.translianmai.data.TransAnchorInfo;
import com.unionyy.mobile.translianmai.viewmodel.YiQiBoConnectingViewModel;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\"H\u0014R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006*"}, d2={"Lcom/unionyy/mobile/translianmai/viewmodel/YiQiBoConnectingViewModel;", "Landroid/arch/lifecycle/ViewModel;", "()V", "accept", "Landroid/arch/lifecycle/MutableLiveData;", "", "getAccept", "()Landroid/arch/lifecycle/MutableLiveData;", "setAccept", "(Landroid/arch/lifecycle/MutableLiveData;)V", "disposable", "Lio/reactivex/disposables/CompositeDisposable;", "enterType", "", "getEnterType", "setEnterType", "remainingTime", "getRemainingTime", "()I", "setRemainingTime", "(I)V", "startTimeStamp", "", "getStartTimeStamp", "()J", "setStartTimeStamp", "(J)V", "transAnchorInfo", "Lcom/unionyy/mobile/translianmai/data/TransAnchorInfo;", "getTransAnchorInfo", "()Lcom/unionyy/mobile/translianmai/data/TransAnchorInfo;", "setTransAnchorInfo", "(Lcom/unionyy/mobile/translianmai/data/TransAnchorInfo;)V", "cancelLianmai", "", "cancelType", "", "getData", "bundle", "Landroid/os/Bundle;", "onCleared", "Companion", "translianmai_release"})
public final class YiQiBoConnectingViewModel
extends ViewModel {
    private final CompositeDisposable disposable = new CompositeDisposable();
    @Nullable
    private TransAnchorInfo transAnchorInfo;
    private int remainingTime = 15;
    @NotNull
    private MutableLiveData<Integer> enterType = new MutableLiveData();
    @NotNull
    private MutableLiveData<Boolean> accept = new MutableLiveData();
    private long startTimeStamp = -1L;
    @NotNull
    public static final String TAG = "YiQiBoConnectingViewModel";
    @NotNull
    public static final String CONNECTING_ANCHOR_INFO = "CONNECTING_ANCHOR_INFO";
    @NotNull
    public static final String REMAINING_TIME_TO_CONNECT = "REMAINING_TIME_TO_CONNECT";
    @NotNull
    public static final String CONNECTING_START_TIMESTAMP = "CONNECTING_TIMESTAMP";
    public static final int DEFAULT_COUNT_DOWN_TIME = 15;
    @NotNull
    public static final String ENTER_TYPE = "ENTER_TYPE";
    public static final int START_INVITING = 0;
    public static final int REFUSE_BY_OTHER = 1;
    public static final int NOT_RESPONDING = 2;
    public static final int IS_CONNECTING = 3;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final TransAnchorInfo getTransAnchorInfo() {
        return this.transAnchorInfo;
    }

    public final void setTransAnchorInfo(@Nullable TransAnchorInfo transAnchorInfo) {
        this.transAnchorInfo = transAnchorInfo;
    }

    public final int getRemainingTime() {
        return this.remainingTime;
    }

    public final void setRemainingTime(int n) {
        this.remainingTime = n;
    }

    @NotNull
    public final MutableLiveData<Integer> getEnterType() {
        return this.enterType;
    }

    public final void setEnterType(@NotNull MutableLiveData<Integer> mutableLiveData) {
        Intrinsics.checkParameterIsNotNull(mutableLiveData, (String)"<set-?>");
        this.enterType = mutableLiveData;
    }

    @NotNull
    public final MutableLiveData<Boolean> getAccept() {
        return this.accept;
    }

    public final void setAccept(@NotNull MutableLiveData<Boolean> mutableLiveData) {
        Intrinsics.checkParameterIsNotNull(mutableLiveData, (String)"<set-?>");
        this.accept = mutableLiveData;
    }

    public final long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    public final void setStartTimeStamp(long l) {
        this.startTimeStamp = l;
    }

    protected void onCleared() {
        super.onCleared();
        this.disposable.dispose();
    }

    public final void getData(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        this.transAnchorInfo = (TransAnchorInfo)bundle.getParcelable(CONNECTING_ANCHOR_INFO);
        this.remainingTime = bundle.getInt(REMAINING_TIME_TO_CONNECT);
        this.enterType.setValue((Object)bundle.getInt(ENTER_TYPE, 0));
        this.startTimeStamp = bundle.getLong(CONNECTING_START_TIMESTAMP);
        MLog.info((Object)TAG, (String)("getData: transAnchorInfo = " + this.transAnchorInfo + ", remainingTime = " + this.remainingTime + ", enterType = " + (Integer)this.enterType.getValue() + ", startTimeStamp = " + this.startTimeStamp), (Object[])new Object[0]);
    }

    public final void cancelLianmai(@NotNull String cancelType) {
        Intrinsics.checkParameterIsNotNull((Object)cancelType, (String)"cancelType");
        if (this.transAnchorInfo == null) {
            return;
        }
        MLog.info((Object)TAG, (String)("cancelLianmai: cancelType = " + cancelType), (Object[])new Object[0]);
        ITransLianmaiCore iTransLianmaiCore = (ITransLianmaiCore)ICoreManagerBase.getCore(ITransLianmaiCore.class);
        TransAnchorInfo transAnchorInfo = this.transAnchorInfo;
        if (transAnchorInfo == null) {
            Intrinsics.throwNpe();
        }
        long l = transAnchorInfo.getUid();
        TransAnchorInfo transAnchorInfo2 = this.transAnchorInfo;
        if (transAnchorInfo2 == null) {
            Intrinsics.throwNpe();
        }
        long l2 = transAnchorInfo2.getTopSid();
        TransAnchorInfo transAnchorInfo3 = this.transAnchorInfo;
        if (transAnchorInfo3 == null) {
            Intrinsics.throwNpe();
        }
        this.disposable.add(iTransLianmaiCore.cancel(l, l2, transAnchorInfo3.getSubSid(), cancelType).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)cancelLianmai.1.INSTANCE, RxUtils.errorConsumer((String)TAG)));
    }

    public YiQiBoConnectingViewModel() {
        this.accept.setValue((Object)false);
        this.disposable.add(TransLianmaiManager.INSTANCE.getWaittingForAnswer().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<LianmaiSession>(){

            public final void accept(LianmaiSession it) {
                MLog.info((Object)YiQiBoConnectingViewModel.TAG, (String)("waittingForAnswer: onNext -> " + it), (Object[])new Object[0]);
                if (it.getTargetUid() == 0L || it.getTargetSid() == 0L) {
                    return;
                }
                switch (it.getOperation()) {
                    case 2: {
                        this.getEnterType().setValue((Object)1);
                        break;
                    }
                    case 3: {
                        this.getAccept().setValue((Object)true);
                    }
                }
            }
        }, RxUtils.errorConsumer((String)TAG)));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/unionyy/mobile/translianmai/viewmodel/YiQiBoConnectingViewModel$Companion;", "", "()V", "CONNECTING_ANCHOR_INFO", "", "CONNECTING_START_TIMESTAMP", "DEFAULT_COUNT_DOWN_TIME", "", "ENTER_TYPE", "IS_CONNECTING", "NOT_RESPONDING", "REFUSE_BY_OTHER", "REMAINING_TIME_TO_CONNECT", "START_INVITING", "TAG", "translianmai_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

