/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.RelativeLayout;
import com.yy.mobile.plugin.pluginunionlive.R;
import java.util.ArrayList;

public class RippleBackground
extends RelativeLayout {
    private static final int DEFAULT_RIPPLE_COUNT = 6;
    private static final int DEFAULT_DURATION_TIME = 3000;
    private static final float DEFAULT_SCALE = 6.0f;
    private static final int DEFAULT_FILL_TYPE = 0;
    private int rippleColor;
    private float rippleStrokeWidth;
    private float rippleRadius;
    private int rippleDurationTime;
    private int rippleAmount;
    private int rippleDelay;
    private float rippleScale;
    private int rippleType;
    private boolean isAnimation;
    private Paint paint;
    private AnimatorSet animatorSet;
    private ArrayList<Animator> animatorList;
    private RelativeLayout.LayoutParams rippleParams;
    private ArrayList<RippleView> rippleViewList = new ArrayList();

    public RippleBackground(Context context) {
        super(context);
    }

    public RippleBackground(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RippleBackground(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        if (null == attrs) {
            throw new IllegalArgumentException("Attributes should be provided to this view,");
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RippleBackground);
        this.rippleColor = typedArray.getColor(R.styleable.RippleBackground_rb_color, this.getResources().getColor(R.color.rippleColor));
        this.rippleStrokeWidth = typedArray.getDimension(R.styleable.RippleBackground_rb_strokeWidth, this.getResources().getDimension(R.dimen.moblielive_rippleStrokeWidth));
        this.rippleRadius = typedArray.getDimension(R.styleable.RippleBackground_rb_radius, this.getResources().getDimension(R.dimen.moblielive_rippleRadius));
        this.rippleDurationTime = typedArray.getInt(R.styleable.RippleBackground_rb_duration, 3000);
        this.rippleAmount = typedArray.getInt(R.styleable.RippleBackground_rb_rippleAmount, 6);
        this.rippleScale = typedArray.getFloat(R.styleable.RippleBackground_rb_scale, 6.0f);
        this.rippleType = typedArray.getInt(R.styleable.RippleBackground_rb_type, 0);
        typedArray.recycle();
        this.rippleDelay = 400;
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        if (this.rippleType == 0) {
            this.rippleStrokeWidth = 0.0f;
            this.paint.setStyle(Paint.Style.FILL);
        } else {
            this.paint.setStyle(Paint.Style.STROKE);
        }
        this.paint.setColor(this.rippleColor);
        this.rippleParams = new RelativeLayout.LayoutParams((int)(2.0f * (this.rippleRadius + this.rippleStrokeWidth)), (int)(2.0f * (this.rippleRadius + this.rippleStrokeWidth)));
        this.rippleParams.addRule(13, -1);
        this.animatorSet = new AnimatorSet();
        this.animatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.animatorList = new ArrayList();
        for (int i = 0; i < this.rippleAmount; ++i) {
            RippleView rippleView = new RippleView(this.getContext());
            this.addView(rippleView, (ViewGroup.LayoutParams)this.rippleParams);
            this.rippleViewList.add(rippleView);
            rippleView.setScaleX(1.0f);
            rippleView.setScaleY(1.0f);
            rippleView.setAlpha(1.0f);
            PropertyValuesHolder pvhsX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{this.rippleScale});
            PropertyValuesHolder pvhsY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{this.rippleScale});
            PropertyValuesHolder pvhA = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.0f});
            ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)rippleView), (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhsX, pvhsY, pvhA});
            objectAnimator.setRepeatCount(-1);
            objectAnimator.setRepeatMode(1);
            objectAnimator.setRepeatMode(1);
            objectAnimator.setStartDelay((long)(i * this.rippleDelay));
            objectAnimator.setDuration((long)this.rippleDurationTime);
            this.animatorList.add((Animator)objectAnimator);
        }
        this.animatorSet.playTogether(this.animatorList);
    }

    public void startRippleAnimation() {
        if (!this.isAnimation) {
            for (RippleView rippleView : this.rippleViewList) {
                rippleView.setVisibility(0);
            }
            this.animatorSet.start();
            this.isAnimation = true;
        }
    }

    public void closeRippleAnimation() {
        if (this.isAnimation) {
            for (RippleView rippleView : this.rippleViewList) {
                rippleView.setVisibility(8);
            }
            this.animatorSet.end();
            this.isAnimation = false;
        }
    }

    public boolean isAnimation() {
        return this.isAnimation;
    }

    private class RippleView
    extends View {
        RippleView(Context context) {
            super(context);
            this.setVisibility(4);
        }

        protected void onDraw(Canvas canvas) {
            int radius = Math.min(this.getWidth(), this.getHeight()) / 2;
            canvas.drawCircle((float)radius, (float)radius, (float)radius - RippleBackground.this.rippleStrokeWidth, RippleBackground.this.paint);
        }
    }
}

