/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.image.PauseOnScrollListener;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onQueryRecordListInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.PagerFragment;
import com.yy.mobile.ui.common.MobileLiveNoDataFragment;
import com.yy.mobile.ui.mobilelive.AnchorReplayAdapter;
import com.yy.mobile.ui.mobilelive.AnchorReplayFragment$$EventBinder;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.mobilelive.AnchorReplayInfo;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import java.util.ArrayList;
import java.util.Collection;

public class AnchorReplayFragment
extends PagerFragment {
    private static final String TAG = "AnchorReplayFragment";
    public static final String KEY_IS_LAST_PAGE = "KEY_IS_LAST_PAGE";
    public static final String KEY_PAGE_NO = "KEY_PAGE_NO";
    public static final String PARAM_UID = "anchorReplayFragment_param_uid";
    private static final String REPLAY_LIST = "replay_list";
    private static final int PAGER_SIZE = 20;
    private View mFootView;
    private PullToRefreshListView mListView;
    private EndlessListScrollListener mEndlessListScrollListener;
    private AnchorReplayAdapter mAdapter;
    private int index = 0;
    private int mPageNo = 1;
    private ArrayList<AnchorReplayInfo.AnchorReplayPageInfo> mReplayList = new ArrayList();
    private boolean isLastPage = false;
    private boolean isFirstLoadData = true;
    private long mUid;
    View.OnClickListener mOnclick = new View.OnClickListener(){

        public void onClick(View v) {
            AnchorReplayFragment.this.loadFirstPage(true, AnchorReplayFragment.this.getView());
        }
    };
    private EventBinder mAnchorReplayFragmentSniperEventBinder;

    public static AnchorReplayFragment newInstance(long uid) {
        AnchorReplayFragment fragment = new AnchorReplayFragment();
        Bundle bundle = new Bundle();
        bundle.putLong(PARAM_UID, uid);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mUid = this.getArguments().getLong(PARAM_UID, this.mUid);
        } else if (savedInstanceState != null) {
            this.mUid = savedInstanceState.getLong(PARAM_UID, this.mUid);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.isFirstLoadData = true;
        View view = inflater.inflate(R.layout.fragment_anchor_replay, container, false);
        this.mFootView = inflater.inflate(R.layout.item_anchor_replay_footer, null, false);
        this.mListView = (PullToRefreshListView)view.findViewById(R.id.lvbc_listview_h);
        this.mListView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<ListView>(){

            public void onRefresh(PullToRefreshBase<ListView> refreshView) {
                AnchorReplayFragment.this.loadFirstPage(false, AnchorReplayFragment.this.getView());
            }
        });
        this.mAdapter = new AnchorReplayAdapter((Context)this.getActivity());
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mEndlessListScrollListener = new EndlessListScrollListener((StatusLayout)view.findViewById(R.id.lvbc_container_h));
        this.mEndlessListScrollListener.setVisibleThreshold(3);
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                if (AnchorReplayFragment.this.checkNetToast()) {
                    AnchorReplayFragment.this.mPageNo++;
                    ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).queryRecordListInfoHistory(AnchorReplayFragment.this.mUid, (AnchorReplayFragment.this.mPageNo - 1) * 20, 20);
                } else {
                    AnchorReplayFragment.this.mEndlessListScrollListener.onLoadComplete();
                    AnchorReplayFragment.this.mListView.onRefreshComplete();
                }
            }

            public boolean shouldLoadData() {
                if (AnchorReplayFragment.this.checkNetToast()) {
                    return !AnchorReplayFragment.this.isLastPage;
                }
                return false;
            }
        });
        this.mEndlessListScrollListener.setParentOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)new PauseOnScrollListener(true, true, (AbsListView.OnScrollListener)this.mEndlessListScrollListener));
        if (savedInstanceState != null) {
            this.isFirstLoadData = false;
            this.mReplayList = savedInstanceState.getParcelableArrayList(REPLAY_LIST);
            this.mPageNo = savedInstanceState.getInt(KEY_PAGE_NO, 1);
            this.isLastPage = savedInstanceState.getBoolean(KEY_IS_LAST_PAGE, false);
            this.mAdapter.setData(this.mReplayList, true);
        } else if (this.isFirstLoadData) {
            this.isFirstLoadData = false;
            this.loadFirstPage(true, view);
        }
        view.setId(this.index);
        ((TextView)this.mFootView.findViewById(R.id.home_footer_tips)).setTextColor(-2130706433);
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelableArrayList(REPLAY_LIST, this.mReplayList);
        outState.putBoolean(KEY_IS_LAST_PAGE, this.isLastPage);
        outState.putInt(KEY_PAGE_NO, this.mPageNo);
    }

    public void onDestroyView() {
        super.onDestroyView();
        Object var2_1 = null;
        if (this.mAnchorReplayFragmentSniperEventBinder != null) {
            this.mAnchorReplayFragmentSniperEventBinder.unBindEvent();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mListView.isRefreshing()) {
            this.mListView.onRefreshComplete();
        }
    }

    public void onResume() {
        super.onResume();
    }

    public void onPageScrollComplete(int position) {
        super.onPageScrollComplete(position);
        if ((this.isFirstLoadData || this.mAdapter != null && this.mAdapter.getCount() == 0) && this.isNetworkAvailable()) {
            this.loadFirstPage(true, this.getView());
        }
        this.isFirstLoadData = false;
    }

    private void loadFirstPage(boolean isShow, View view) {
        this.mPageNo = 1;
        if (isShow) {
            this.showLoading(view, 0, 0);
        }
        if (this.mListView != null && this.mListView.getRefreshableView() != null && this.mFootView != null) {
            ((ListView)this.mListView.getRefreshableView()).removeFooterView(this.mFootView);
        }
        ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).queryRecordListInfoHistory(this.mUid, this.mPageNo - 1, 20);
    }

    @BusEvent(sync=true)
    public void onQueryRecordListInfo(IMobileLiveClient_onQueryRecordListInfo_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        AnchorReplayInfo data = busEventArgs.getRecordlist();
        this.mEndlessListScrollListener.onLoadComplete();
        this.mListView.onRefreshComplete();
        this.hideStatus();
        if (result == 0 && data != null) {
            if (this.mPageNo == 1) {
                if (FP.empty((Collection)data.replayList)) {
                    this.mAdapter.clearData();
                    this.showNoData();
                } else {
                    this.mAdapter.setData(data.replayList, true);
                }
                this.mReplayList.clear();
            } else {
                this.mAdapter.setData(data.replayList, false);
            }
            this.mReplayList.addAll(data.replayList);
            this.isLastPage = data.isLastPage();
        } else if (this.mPageNo == 1) {
            if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
                this.checkNetToast();
            } else if (this.isNetworkAvailable()) {
                this.showNoData();
            } else {
                this.showNetworkErr();
            }
        } else {
            --this.mPageNo;
            this.checkNetToast();
        }
        if (this.isLastPage && this.mFootView != null && this.mListView != null && this.mListView.getRefreshableView() != null && this.mAdapter != null && this.mAdapter.getCount() > 0) {
            ((ListView)this.mListView.getRefreshableView()).removeFooterView(this.mFootView);
            ((ListView)this.mListView.getRefreshableView()).addFooterView(this.mFootView, null, false);
        }
    }

    public View.OnClickListener getLoadListener() {
        return this.mOnclick;
    }

    public View.OnClickListener getNoMobileLiveDataListener() {
        return this.mOnclick;
    }

    public void onSelected(int position) {
        super.onSelected(position);
    }

    public void onUnSelected(int position) {
        super.onUnSelected(position);
    }

    public void showNoData() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showNoData view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = this.getView().findViewById(R.id.status_layout);
        if (status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        MobileLiveNoDataFragment fragment = new MobileLiveNoDataFragment();
        fragment.setListener(this.getLoadListener());
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, "STATUS_TAG").commitAllowingStateLoss();
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mAnchorReplayFragmentSniperEventBinder == null) {
            this.mAnchorReplayFragmentSniperEventBinder = new AnchorReplayFragment$$EventBinder();
        }
        this.mAnchorReplayFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }
}

