/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.chatemotion;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.liveapi.chatemotion.uicore.IChatEmotionCore;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.chatemotion.data.ChatConstants;
import com.yy.mobile.ui.commontip.core.CommonTipInfo;
import com.yy.mobile.ui.utils.AbstractViewController;
import com.yy.mobile.ui.utils.DateUtils;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.LinkUriProvider;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.Calendar;
import java.util.Date;

public class CharacterValuesTipController
extends AbstractViewController {
    private static final String TAG = "CharacterValuesTipController";
    private TextView mTipInfo;
    private FragmentActivity mContext;
    private ViewGroup mParent;
    private CommonTipInfo mCommonTipInfo;
    private OnMakeChatComponentDismissListener onMakeChatComponentDismissListener;
    private Runnable delayHide = new Runnable(){

        @Override
        public void run() {
            CharacterValuesTipController.this.hide();
            if (CharacterValuesTipController.this.mParent != null) {
                CharacterValuesTipController.this.mParent.setVisibility(8);
            }
        }
    };

    public CharacterValuesTipController(FragmentActivity mContext, ViewGroup parent) {
        this.mContext = mContext;
        this.mParent = parent;
        ICoreManagerBase.addClient((Object)((Object)this));
    }

    public void setOnMakeChatComponentDismissListener(OnMakeChatComponentDismissListener listener2) {
        this.onMakeChatComponentDismissListener = listener2;
    }

    protected void onCreatePrepare(Bundle savedInstanceState) {
        super.onCreatePrepare(savedInstanceState);
        this.isInitHidden = true;
    }

    protected View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.layout_common_tip, container, false);
        this.mTipInfo = (TextView)rootView.findViewById(R.id.tv_tip_info);
        this.mTipInfo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CharacterValuesTipController.this.mCommonTipInfo != null && ((CharacterValuesTipController)CharacterValuesTipController.this).mCommonTipInfo.level == 1) {
                    return;
                }
                CharacterValuesTipController.this.hide();
                if (CharacterValuesTipController.this.onMakeChatComponentDismissListener != null) {
                    CharacterValuesTipController.this.onMakeChatComponentDismissListener.onMakeChatComponentDismiss();
                }
                if (CoreApiManager.getInstance().getApi(NavigationUtilApi.class) != null) {
                    ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toJSSupportedWebView((Activity)CharacterValuesTipController.this.mContext, LinkUriProvider.LINK_CHARACTER_VALUE_URL);
                }
                ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51021", "0002");
            }
        });
        rootView.findViewById(R.id.iv_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CharacterValuesTipController.this.delayHide != null) {
                    CharacterValuesTipController.this.getHandler().removeCallbacks(CharacterValuesTipController.this.delayHide);
                }
                CharacterValuesTipController.this.hide();
                if (CharacterValuesTipController.this.mParent != null) {
                    CharacterValuesTipController.this.mParent.setVisibility(8);
                }
                ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51021", "0003");
            }
        });
        return rootView;
    }

    protected void onDestroy() {
        this.mCommonTipInfo = null;
        ICoreManagerBase.removeClient((Object)((Object)this));
        this.mContext = null;
    }

    protected void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (this.mRootView != null && this.mRootView.getParent() != null) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mRootView.getLayoutParams();
            params.addRule(12);
            params.addRule(14);
            params.bottomMargin = isLandscape ? DensityUtil.dip2px((Context)this.mContext, (float)75.0f) : DensityUtil.dip2px((Context)this.mContext, (float)0.0f);
            this.mRootView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void showMoralQualityRspTip() {
        super.show();
        if (this.mParent != null) {
            this.mParent.setVisibility(0);
        }
        this.getHandler().removeCallbacks(this.delayHide);
        this.getHandler().postDelayed(this.delayHide, 8000L);
    }

    public void onUpateCharacterValuesTip(CommonTipInfo info) {
        if (info != null && info.txt != null && !info.txt.isEmpty()) {
            int nStart = info.txt.indexOf("\u67e5\u770b\u8be6\u60c5>>");
            SpannableString spannableString = new SpannableString((CharSequence)info.txt.toString());
            spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffffff")), 0, nStart, 33);
            spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#fac200")), nStart + 1, info.txt.length() - 1, 33);
            this.mTipInfo.setText((CharSequence)spannableString);
            this.mCommonTipInfo = info;
            this.showMoralQualityRspTip();
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51021", "0001");
        }
    }

    private void showMoralQualityPreTip() {
        super.show();
        if (this.mParent != null) {
            this.mParent.setVisibility(0);
        }
        this.getHandler().removeCallbacks(this.delayHide);
        this.getHandler().postDelayed(this.delayHide, 8000L);
    }

    public void onTypeCViolationNotice(String noticeInfo) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[onMoralQualityNotice] noticeInfo=" + noticeInfo), (Object[])new Object[0]);
        }
        if (((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).shouldShowMoralQualityToastTime()) {
            SpannableString spannableString = new SpannableString((CharSequence)noticeInfo);
            CommonTipInfo commonTipInfo = new CommonTipInfo();
            commonTipInfo.txt = spannableString.toString();
            commonTipInfo.level = 1;
            this.mCommonTipInfo = commonTipInfo;
            ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).updateLastMoralQualityToastTime();
            this.mTipInfo.setText((CharSequence)spannableString);
            this.showMoralQualityPreTip();
        }
    }

    public void onToastMoralQualityStateNotice() {
        boolean canShow;
        int moralQualityState = CommonPref.instance().getInt(ChatConstants.getUserMoralQualityStateKey(), -1);
        int moralQualityFlag = CommonPref.instance().getInt(ChatConstants.getUserMoralQualityFlagKey(), 0);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[onToastMoralQualityStateNotice] moralQualityState = " + moralQualityState), (Object[])new Object[0]);
        }
        String month = DateUtils.dateToString((Date)Calendar.getInstance().getTime(), (String)"yyyy-MM");
        boolean bl = canShow = !CommonPref.instance().getString(ChatConstants.getUserMoralQualityNoticeToastKey((int)moralQualityState), "").equals(month);
        if (canShow && moralQualityFlag == 0) {
            if (moralQualityState == 1 || moralQualityState == 2 || moralQualityState == 3) {
                this.onUpateMoralQualityTip(1);
                CommonPref.instance().putString(ChatConstants.getUserMoralQualityNoticeToastKey((int)moralQualityState), month);
            } else if (moralQualityState == 4) {
                this.onUpateMoralQualityTip(2);
                CommonPref.instance().putString(ChatConstants.getUserMoralQualityNoticeToastKey((int)moralQualityState), month);
            }
        }
    }

    private void onUpateMoralQualityTip(int state) {
        if (this.checkActivityValid()) {
            if (state == 1) {
                String txt = this.getString(R.string.str_tip_moral_quality_state_middle);
                int nStart = txt.indexOf("\u67e5\u770b\u8be6\u60c5>>");
                SpannableString spannableString = new SpannableString((CharSequence)txt.toString());
                spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffffff")), 0, nStart, 33);
                spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#fac200")), nStart + 1, txt.length() - 1, 33);
                CommonTipInfo commonTipInfo = new CommonTipInfo();
                commonTipInfo.isFullScreenWeb = true;
                commonTipInfo.txt = spannableString.toString();
                commonTipInfo.url = LinkUriProvider.LINK_CHARACTER_VALUE_URL;
                commonTipInfo.level = 2;
                this.mCommonTipInfo = commonTipInfo;
                ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).updateLastMoralQualityToastTime();
                this.mTipInfo.setText((CharSequence)spannableString);
                this.showMoralQualityPreTip();
            } else if (state == 2) {
                String txt = this.getString(R.string.str_tip_moral_quality_state_high);
                int nStart = txt.indexOf("\u65e0\u6cd5\u5728\u516c\u5c4f\u53d1\u8a00\u3002");
                int nStart2 = txt.indexOf("\u67e5\u770b\u8be6\u60c5>>");
                SpannableString spannableString = new SpannableString((CharSequence)txt.toString());
                spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffffff")), 0, nStart, 33);
                spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ff4f4f")), nStart, nStart2, 33);
                spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#fac200")), nStart2, txt.length(), 33);
                CommonTipInfo commonTipInfo = new CommonTipInfo();
                commonTipInfo.isFullScreenWeb = true;
                commonTipInfo.txt = spannableString.toString();
                commonTipInfo.url = LinkUriProvider.LINK_CHARACTER_VALUE_URL;
                commonTipInfo.level = 2;
                this.mCommonTipInfo = commonTipInfo;
                ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).updateLastMoralQualityToastTime();
                this.mTipInfo.setText((CharSequence)spannableString);
                this.showMoralQualityPreTip();
            }
        }
    }

    public static interface OnMakeChatComponentDismissListener {
        public void onMakeChatComponentDismiss();
    }
}

