/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.anchorInfoCard;

import android.content.Context;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.ANCHORVIVO;
import com.unionyy.mobile.spdt.annotation.SpdtActual;
import com.unionyy.mobile.spdt.annotation.SpdtExpect;
import com.unionyy.mobile.spdt.annotation.VIVO;
import com.yy.mobile.ui.anchorInfoCard.userview.IUserInfoView;
import com.yy.mobile.ui.anchorInfoCard.userview.UserInfoView;
import com.yy.mobile.ui.anchorInfoCard.userview.VivoUserInfoView;
import com.yy.mobile.ui.anchorInfoCard.userview.YYAnchorUserInfoView;

@SpdtExpect
public interface UserInfoViewFactory {
    public static final UserInfoViewFactory INSTANCE = (UserInfoViewFactory)Spdt.of(UserInfoViewFactory.class);

    public IUserInfoView build(Context var1);

    public IUserInfoView build(Context var1, IUserInfoView.OnHeadClickListener var2);

    @SpdtActual(value=ANCHORVIVO.class)
    public static class AnchorVivoFactory
    extends DefaultFactory
    implements UserInfoViewFactory {
        @Override
        public IUserInfoView build(Context context, IUserInfoView.OnHeadClickListener headIconClickListener) {
            YYAnchorUserInfoView uv = new YYAnchorUserInfoView(context);
            uv.addOnHeadClickListener(headIconClickListener);
            return uv;
        }
    }

    @SpdtActual(value=VIVO.class)
    public static class VivoFactory
    extends DefaultFactory
    implements UserInfoViewFactory {
        @Override
        public IUserInfoView build(Context context, IUserInfoView.OnHeadClickListener headIconClickListener) {
            VivoUserInfoView uv = new VivoUserInfoView(context);
            uv.addOnHeadClickListener(headIconClickListener);
            return uv;
        }
    }

    @SpdtActual
    public static class DefaultFactory
    implements UserInfoViewFactory {
        @Override
        public IUserInfoView build(Context ctx) {
            return this.build(ctx, null);
        }

        @Override
        public IUserInfoView build(Context context, IUserInfoView.OnHeadClickListener headIconClickListener) {
            UserInfoView uv = new UserInfoView(context);
            uv.addOnHeadClickListener(headIconClickListener);
            return uv;
        }
    }
}

