/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.treasure;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.ui.streamlight.core.EntIdentityIconSetBase;
import com.yy.mobile.ui.truelove.TreasureMedal;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.truelove.TrueLoveMessage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TrueLoveSpannableUtils {
    private Context context;

    public TrueLoveSpannableUtils(Context context) {
        this.context = context;
    }

    public TrueLoveMessage setTureLoveOpenChannelMessage(SpannableBeanInfo info) {
        if (info == null) {
            return null;
        }
        TrueLoveMessage message = new TrueLoveMessage();
        message.channelMessageType = ChannelMessage.ChannelMsgType.TURE_LOVE_TYPE;
        message.nickname = info.nick;
        message.uid = info.uid;
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append("medelIcon");
        sb.append(info.nick);
        sb.append("\u5b8c\u6210\u4e86\u73cd\u7231\u56e2\u4efb\u52a1\uff0c\u8d21\u732e\u4e86");
        sb.append(info.score);
        sb.append("\u79ef\u5206");
        message.text = sb.toString();
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)message.text);
        int nobleIconSize = (int)ResolutionUtils.convertDpToPixel((float)18.0f, (Context)BasicConfig.getInstance().getAppContext());
        int nobleLv = info.nobleLevel;
        if (nobleLv > 0) {
            BitmapDrawable d = ImageLoader.getBitmapDrawableFromResource((int)((EntIdentityIconSetBase)CoreApiManager.getInstance().getApi(EntIdentityIconSetBase.class)).getIconResId(nobleLv), (ImageConfig)ImageConfig.smallImageConfig());
            d.setBounds(0, 0, nobleIconSize, nobleIconSize);
            CustomImageSpan imageSpanNoble = new CustomImageSpan((Drawable)d, 2.0f);
            if (imageSpanNoble != null) {
                spannable.setSpan((Object)imageSpanNoble, 0, 1, 33);
            }
        }
        Pattern p1 = Pattern.compile("medelIcon");
        Matcher m1 = p1.matcher(message.text);
        int nickNameStart = 0;
        while (m1.find()) {
            Drawable drawable2 = TreasureMedal.instance().getTrueloveLvBg(1, this.context);
            Drawable d = TreasureMedal.instance().getTrueloveBg(drawable2, null, info.medalName, this.context);
            d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
            CustomImageSpan imageSpanMedal = new CustomImageSpan(d, 2.0f);
            if (imageSpanMedal == null) continue;
            spannable.setSpan((Object)imageSpanMedal, m1.start(), m1.end(), 33);
            nickNameStart = m1.end();
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#6DEAFF")), nickNameStart, message.nickname.length() + nickNameStart, 33);
        message.spannable = spannable;
        return message;
    }

    public static class SpannableBeanInfo {
        public long uid;
        public String nick = "";
        public String medalName = "";
        public String score;
        public int nobleLevel;
        public boolean isCBA;
    }
}

