/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.ylink;

import android.content.Context;
import android.text.TextUtils;
import com.yy.mobile.RxBus;
import com.yy.mobile.event.perf.CancleMonitorAction;
import com.yy.mobile.event.perf.EndMonitorAction;
import com.yy.mobile.event.perf.StartMonitorAction;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoQuality;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChannelInfo;

public class ChannelUtils {
    private static String TAG = "ChannelUtils";

    public static String parseJoinError(Context context, int code) {
        String result;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("parseJoinError code = " + code), (Object[])new Object[0]);
        }
        switch (code) {
            case 0: {
                result = context.getString(R.string.str_user_kick_off);
                break;
            }
            case 1: {
                result = context.getString(R.string.str_user_ban_id);
                break;
            }
            case 2: {
                result = context.getString(R.string.str_user_ban_ip);
                break;
            }
            case 3: {
                result = context.getString(R.string.str_user_ban_pc);
                break;
            }
            case 4: {
                result = context.getString(R.string.str_user_login_success);
                break;
            }
            case 5: {
                result = context.getString(R.string.str_forbid_other_join_channel);
                break;
            }
            case 6: {
                result = context.getString(R.string.str_user_need_passwd);
                break;
            }
            case 7: {
                result = context.getString(R.string.str_user_mutijoin);
                break;
            }
            case 8: {
                result = context.getString(R.string.str_user_mutijoin_err_mode);
                break;
            }
            case 9: {
                result = context.getString(R.string.str_user_mutijoin_timeout);
                break;
            }
            case 11: {
                result = context.getString(R.string.str_channel_congest);
                break;
            }
            case 12: {
                result = context.getString(R.string.str_channel_not_exist);
                break;
            }
            case 13: {
                result = context.getString(R.string.str_channel_frozen);
                break;
            }
            case 14: {
                result = context.getString(R.string.str_channel_locked);
                break;
            }
            case 15: {
                result = context.getString(R.string.str_channel_asid_recyled);
                break;
            }
            case 16: {
                result = context.getString(R.string.str_user_login_topsid_limit);
                break;
            }
            case 10: 
            case 17: 
            case 405: {
                result = context.getString(R.string.str_channel_full_title);
                break;
            }
            case 18: {
                result = context.getString(R.string.str_channel_subsid_limit);
                break;
            }
            case 19: {
                result = context.getString(R.string.str_guset_access_limit);
                break;
            }
            case 20: {
                result = context.getString(R.string.str_channel_vip_limit);
                break;
            }
            case 21: {
                result = context.getString(R.string.str_channel_charge_limit);
                break;
            }
            case 22: {
                result = context.getString(R.string.str_channel_app_limit);
                break;
            }
            case 1000: {
                result = context.getString(R.string.str_network_error);
                break;
            }
            case 1001: {
                result = context.getString(R.string.str_db_error);
                break;
            }
            case 1002: {
                result = context.getString(R.string.str_timeout_error);
                break;
            }
            case 1003: {
                result = context.getString(R.string.str_server_error);
                break;
            }
            case 2000: {
                result = context.getString(R.string.str_auth_user_not_exist_error);
                break;
            }
            case 2002: {
                result = context.getString(R.string.str_auth_user_banned_error);
                break;
            }
            case 2001: {
                result = context.getString(R.string.str_auth_password_error);
                break;
            }
            case 3000: {
                result = context.getString(R.string.str_no_channel_error);
                break;
            }
            case 4000: {
                result = context.getString(R.string.str_channel_password_error);
                break;
            }
            case 4001: {
                result = context.getString(R.string.str_user_banned_error);
                break;
            }
            case 4002: {
                result = context.getString(R.string.str_user_not_exist_error);
                break;
            }
            case 1004: {
                result = context.getString(R.string.str_unknown_error);
                break;
            }
            case 403: {
                result = context.getString(R.string.str_join_channel_error_forbid_guest);
                break;
            }
            case 404: {
                result = context.getString(R.string.str_join_subchannel_nochanenl_error);
                break;
            }
            default: {
                result = context.getString(R.string.str_other_error);
            }
        }
        return result;
    }

    public static String parseKickoffString(int kickType, Context context, String reason) {
        String reasonString;
        switch (kickType) {
            case 0: {
                if (!TextUtils.isEmpty((CharSequence)reason)) {
                    reasonString = context.getString(R.string.str_channel_kickoff_admin_reason) + reason;
                    break;
                }
                reasonString = context.getString(R.string.str_channel_kickoff_admin);
                break;
            }
            case 1: {
                if (!TextUtils.isEmpty((CharSequence)reason)) {
                    reasonString = context.getString(R.string.str_user_ban_id) + context.getString(R.string.str_channel_kickoff_admin_reason) + reason;
                    break;
                }
                reasonString = context.getString(R.string.str_channel_kickoff_admin) + context.getString(R.string.str_user_ban_id);
                break;
            }
            case 3: {
                if (!TextUtils.isEmpty((CharSequence)reason)) {
                    reasonString = context.getString(R.string.str_user_ban_ip) + context.getString(R.string.str_channel_kickoff_admin_reason) + reason;
                    break;
                }
                reasonString = context.getString(R.string.str_channel_kickoff_admin) + context.getString(R.string.str_user_ban_ip);
                break;
            }
            case 2: {
                if (!TextUtils.isEmpty((CharSequence)reason)) {
                    reasonString = context.getString(R.string.str_user_ban_ip) + context.getString(R.string.str_channel_kickoff_admin_reason) + reason;
                    break;
                }
                reasonString = context.getString(R.string.str_channel_kickoff_admin) + context.getString(R.string.str_user_ban_ip);
                break;
            }
            default: {
                reasonString = !TextUtils.isEmpty((CharSequence)reason) ? context.getString(R.string.str_channel_kickoff_admin_reason) + reason : context.getString(R.string.str_channel_kickoff_admin);
            }
        }
        return reasonString;
    }

    public static class MobileLivePerfCollectUtil {
        public static long sLastJMobileLiveTime;

        public static void onMobileLiveStopped() {
            if (System.currentTimeMillis() - sLastJMobileLiveTime < 10000L) {
                CancleMonitorAction cancleMonitorAction = new CancleMonitorAction();
                cancleMonitorAction.bussiness = "live";
                RxBus.getDefault().post((Object)cancleMonitorAction);
            } else {
                EndMonitorAction endMonitorAction = new EndMonitorAction();
                endMonitorAction.bussiness = "live";
                RxBus.getDefault().post((Object)endMonitorAction);
            }
        }

        public static void onMobileLiveStarted() {
            sLastJMobileLiveTime = System.currentTimeMillis();
            StartMonitorAction action = new StartMonitorAction();
            action.scode = 50037;
            action.bussiness = "live";
            RxBus.getDefault().post((Object)action);
        }
    }

    public static class AddChannelPerfCollect {
        public static long sLastJoinChannelSuccessTime = 0L;
        public static String sLastJoinChannelBusiness = null;

        public static void onCurrentChannelLeaved(ChannelInfo info) {
            if (System.currentTimeMillis() - sLastJoinChannelSuccessTime < 10000L) {
                CancleMonitorAction cancleMonitorAction = new CancleMonitorAction();
                cancleMonitorAction.bussiness = sLastJoinChannelBusiness;
                sLastJoinChannelBusiness = null;
                sLastJoinChannelSuccessTime = 0L;
                RxBus.getDefault().post((Object)cancleMonitorAction);
                MLog.debug((Object)TAG, (String)"Leave, < 10, cancel, biz=%s", (Object[])new Object[]{cancleMonitorAction.bussiness});
            } else if (sLastJoinChannelBusiness != null) {
                EndMonitorAction endMonitorAction = new EndMonitorAction();
                endMonitorAction.bussiness = sLastJoinChannelBusiness;
                sLastJoinChannelBusiness = null;
                sLastJoinChannelSuccessTime = 0L;
                RxBus.getDefault().post((Object)endMonitorAction);
                MLog.debug((Object)TAG, (String)"Leave, normal end, biz=%s", (Object[])new Object[]{endMonitorAction.bussiness});
            } else {
                MLog.debug((Object)TAG, (String)"Leave, end, biz=null", (Object[])new Object[0]);
            }
        }

        public static void onJoinChannelSuccess(VideoQuality quality) {
            String biz = "";
            switch (quality) {
                case Standard: {
                    biz = "standard_definition_channel";
                    break;
                }
                case HD: {
                    biz = "high_definition_channel";
                    break;
                }
                case Super: {
                    biz = "super_definition_channel";
                    break;
                }
                case BlueRay: {
                    biz = "blue_definition_channel";
                    break;
                }
            }
            if (biz.equals("")) {
                return;
            }
            if (sLastJoinChannelBusiness == null) {
                sLastJoinChannelBusiness = biz;
                sLastJoinChannelSuccessTime = System.currentTimeMillis();
                StartMonitorAction action = new StartMonitorAction();
                action.bussiness = sLastJoinChannelBusiness;
                action.scode = 50036;
                RxBus.getDefault().post((Object)action);
                MLog.debug((Object)TAG, (String)"Join, clean start: biz=%s", (Object[])new Object[]{biz});
            } else if (!biz.equals(sLastJoinChannelBusiness)) {
                if (System.currentTimeMillis() - sLastJoinChannelSuccessTime < 10000L) {
                    CancleMonitorAction cancleMonitorAction = new CancleMonitorAction();
                    cancleMonitorAction.bussiness = sLastJoinChannelBusiness;
                    RxBus.getDefault().post((Object)cancleMonitorAction);
                    MLog.debug((Object)TAG, (String)"Join, < 10, changed biz, cancel: biz=%s", (Object[])new Object[]{biz});
                } else {
                    EndMonitorAction endMonitorAction = new EndMonitorAction();
                    endMonitorAction.bussiness = sLastJoinChannelBusiness;
                    sLastJoinChannelBusiness = null;
                    sLastJoinChannelSuccessTime = 0L;
                    RxBus.getDefault().post((Object)endMonitorAction);
                    MLog.debug((Object)TAG, (String)"Join, > 10, changed biz, end: biz=%s", (Object[])new Object[]{biz});
                }
                sLastJoinChannelBusiness = biz;
                sLastJoinChannelSuccessTime = System.currentTimeMillis();
                StartMonitorAction action = new StartMonitorAction();
                action.bussiness = sLastJoinChannelBusiness;
                action.scode = 50036;
                RxBus.getDefault().post((Object)action);
                MLog.debug((Object)TAG, (String)"   Join, new start: biz=%s", (Object[])new Object[]{biz});
            } else {
                MLog.debug((Object)TAG, (String)"Join, same biz, no act, biz=%s", (Object[])new Object[]{biz});
            }
        }
    }
}

