/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.swipeloadingview;

import android.content.Context;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.yy.mobile.ui.widget.swipeloadingview.ISwipe;

public class SwipeDetector
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener {
    private GestureDetector mGestureDetector;
    private boolean isVerticalScroll;
    private boolean isScrollFinish = true;
    private boolean isFirstScrollAfterDown;
    private int dragMode;
    private ISwipe iSwipe;
    private int mMinFlingVelocity;

    public SwipeDetector(Context context, ISwipe iSwipe) {
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.iSwipe = iSwipe;
        this.mMinFlingVelocity = ViewConfiguration.getMinimumFlingVelocity();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean ret = this.mGestureDetector.onTouchEvent(event);
        switch (event.getAction()) {
            case 1: 
            case 3: {
                if (this.iSwipe == null) break;
                this.iSwipe.onDragCancel(this.dragMode);
                break;
            }
        }
        return ret;
    }

    public boolean onDown(MotionEvent e) {
        this.isFirstScrollAfterDown = true;
        return this.iSwipe != null && this.iSwipe.onDown(e);
    }

    public void onShowPress(MotionEvent e) {
        if (this.iSwipe != null) {
            this.iSwipe.onShowPress(e);
        }
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return this.iSwipe != null && this.iSwipe.onSingleTapUp(e);
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.isFirstScrollAfterDown) {
            boolean vertical;
            this.isFirstScrollAfterDown = false;
            boolean bl = vertical = Math.abs(distanceY) >= Math.abs(distanceX);
            int mode = vertical ? (distanceY < 0.0f ? 3 : 1) : (distanceX < 0.0f ? 2 : 0);
            this.dragMode = mode;
            if (this.isVerticalScroll != vertical) {
                Log.i((String)"wuziyi", (String)("isFirstScrollAfterDown isVerticalScroll:" + vertical + " isScrollFinish:" + this.isScrollFinish));
                if (!this.isScrollFinish && this.iSwipe != null) {
                    this.iSwipe.interuptByScrollOrientationChange(vertical);
                }
                this.isVerticalScroll = vertical;
            }
        }
        if (this.isVerticalScroll) {
            distanceX = 0.0f;
        } else {
            distanceY = 0.0f;
        }
        boolean ret = false;
        if (this.iSwipe != null) {
            ret = this.iSwipe.onScroll(e1, e2, distanceX, distanceY);
            if (this.isScrollFinish && ret) {
                this.iSwipe.onDragStart();
            }
            this.isScrollFinish = !ret;
        }
        return ret;
    }

    public void onLongPress(MotionEvent e) {
        if (this.iSwipe != null) {
            this.iSwipe.onLongPress(e);
        }
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        boolean ret = false;
        if (this.iSwipe != null) {
            if (this.isVerticalScroll && Math.abs(velocityY) > (float)(this.mMinFlingVelocity * 50)) {
                ret = this.iSwipe.onFling(e1, e2, velocityX, velocityY);
            } else if (!this.isVerticalScroll && Math.abs(velocityX) > (float)this.mMinFlingVelocity) {
                ret = this.iSwipe.onFling(e1, e2, velocityX, velocityY);
            } else {
                this.iSwipe.onDragCancel(this.dragMode);
                ret = false;
            }
            this.isScrollFinish = !ret;
        }
        return ret;
    }

    public void onFlingFinish() {
        this.isScrollFinish = true;
    }

    public boolean isVerticalScroll() {
        return this.isVerticalScroll;
    }

    public void setVerticalScroll(boolean verticalScroll) {
        this.isVerticalScroll = verticalScroll;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        if (this.iSwipe != null) {
            return this.iSwipe.onSingleTapConfirmed(e);
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (this.iSwipe != null) {
            this.iSwipe.onDoubleTap(e);
        }
        return false;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        if (this.iSwipe != null) {
            this.iSwipe.onDoubleTapEvent(e);
        }
        return false;
    }
}

