/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.treasurechest;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.duowan.mobile.entlive.events.IGiftClient_onSendPaidGift_EventArgs;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.model.Processor;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.plugin.homeapi.action.RollResponseAction;
import com.yy.mobile.ui.treasurechest.CountDownTimer;
import com.yy.mobile.ui.treasurechest.ITreasureChestComponent;
import com.yy.mobile.ui.treasurechest.TreasureChestModule;
import com.yy.mobile.ui.treasurechest.TreasureChestStatistic;
import com.yy.mobile.ui.utils.StringUtil;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.ent.protos.IEntProtocol;
import com.yymobile.core.statistic.IDataReportCore;
import com.yymobile.core.subscribe.ISubscribeCore;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import java.util.Locale;

public class TreasureChestPresenter
extends MvpPresenter<ITreasureChestComponent> {
    private TreasureChestModule mModule;
    private static final String TAG = "TreasureChestPresenter";
    @Nullable
    private CountDownTimer mTimer;
    private CountDownState mCountDownState = CountDownState.Idle;
    private int mCurrentInitCountDownTime = 0;
    private int mCurrentInitLeftNum = 0;
    private boolean hasSubscribe = false;
    private boolean hasSendGift = false;
    private boolean hasRollTime = true;
    private String mImageUrl = "";
    private String mSvgaUrl = "";
    private String mAction = "";
    private int mActionType;
    private boolean mOnlyPic = false;
    private static final int JUMP_CHANNEL = 100;
    private static final int JUMP_WEB = 200;
    private static final int MOBILE_YY_COMMAND = 500;
    private static final int OPEN_TREASURE_CHEST = 1200;
    private static final int JUMP_H5_DIALOG = 1300;
    private Processor processor = new Processor<RollResponseAction, Boolean>(){

        @NonNull
        public Class<RollResponseAction> getActionClass() {
            return RollResponseAction.class;
        }

        @Nullable
        public Boolean process(final RollResponseAction action) {
            MLog.info((Object)TreasureChestPresenter.TAG, (String)("registerAction: process: action = " + action), (Object[])new Object[0]);
            if (action.getRollSuccess()) {
                AndroidSchedulers.mainThread().scheduleDirect(new Runnable(){

                    @Override
                    public void run() {
                        TreasureChestPresenter.this.dealCountDown(action.getLeftNum(), action.getCountDown(), true);
                    }
                });
            }
            if (TreasureChestPresenter.this.getView() != null) {
                ((ITreasureChestComponent)TreasureChestPresenter.this.getView()).setIntercept(false);
            }
            return true;
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mModule = new TreasureChestModule(this);
        this.sendPreInitRequest();
        this.mModule.registerTerminateBroadcastReceiver(new Consumer<IEntProtocol>(){

            public void accept(IEntProtocol treasureTerminateProtocol) {
                TreasureChestPresenter.this.stopTreasureChest();
                TreasureChestPresenter.this.mCountDownState = CountDownState.Invalid;
                if (TreasureChestPresenter.this.getView() != null) {
                    ((ITreasureChestComponent)TreasureChestPresenter.this.getView()).stopTreasureAnimation();
                    ((ITreasureChestComponent)TreasureChestPresenter.this.getView()).setComponentVisibility(false);
                }
            }
        });
        this.registerAction();
    }

    protected void onStart() {
        super.onStart();
        if (this.mTimer != null && this.mCountDownState == CountDownState.Running) {
            this.mTimer.start();
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.mTimer != null && this.mCountDownState == CountDownState.Running) {
            this.mTimer.pause();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mModule != null) {
            this.mModule.unRegisterTerminateBroadcastReceiver();
            this.mModule.onDestroy();
            this.mModule = null;
        }
        if (this.mTimer != null) {
            this.mTimer.stop();
            this.mTimer = null;
        }
        YYStore.INSTANCE.unregisterProcessor(this.processor);
    }

    private void sendInitRequest() {
        if (this.mCurrentInitCountDownTime > 0) {
            this.onInitResponse(true, this.mCurrentInitLeftNum, this.mCurrentInitCountDownTime);
        } else if (this.mCountDownState == CountDownState.Idle) {
            this.mModule.sendInitRequest();
        }
    }

    void sendPreInitRequest() {
        this.mModule.sendPreInitRequest();
    }

    void sendTicketStatusRequest() {
        this.mModule.sendTicketStatusRequest();
    }

    void onInitResponse(boolean actValid, int leftNum, int countDown2) {
        if (!actValid) {
            this.mCountDownState = CountDownState.Invalid;
            return;
        }
        if (LoginUtil.isLogined()) {
            this.dealCountDown(leftNum, countDown2, false);
        } else if (this.getView() != null && !((ITreasureChestComponent)this.getView()).isLandScape()) {
            ((ITreasureChestComponent)this.getView()).setComponentVisibility(true);
        }
    }

    void onPreInitResponse(String imageUrl, String svgaUrl, int actionType, String action, int onlyPic, String title) {
        this.mImageUrl = imageUrl;
        this.mSvgaUrl = StringUtil.isNullOrEmpty((CharSequence)svgaUrl) ? "https://github.com/YvesCheung/SVGAPlayer-Android/raw/master/app/src/main/assets/treasurechest/treasurechest.svga" : svgaUrl;
        this.mAction = action;
        this.mOnlyPic = onlyPic == 0;
        this.mActionType = actionType;
        if (actionType == 1200) {
            this.sendInitRequest();
        } else {
            if (this.getView() != null) {
                ((ITreasureChestComponent)this.getView()).setComponentVisibility(true);
                ((ITreasureChestComponent)this.getView()).setTimerVisibility(true);
                ((ITreasureChestComponent)this.getView()).updateTimerView(title);
            }
            if (actionType == 1300 && this.mModule != null) {
                this.mModule.onSendPaidGift(new IGiftClient_onSendPaidGift_EventArgs(0, 0, 0));
            }
        }
    }

    void onTicketStatusResponse() {
        MLog.info((Object)TAG, (String)"onTicketStatusResponse() invoked.", (Object[])new Object[0]);
        if (this.getView() != null) {
            ((ITreasureChestComponent)this.getView()).showObtainTicketDialog();
        }
    }

    private void stopTreasureChest() {
        this.mCurrentInitCountDownTime = 0;
        this.mCountDownState = CountDownState.Idle;
        if (this.mTimer != null) {
            this.mTimer.stop();
        }
    }

    @SuppressLint(value={"CheckResult"})
    void onTreasureChestClick() {
        if (this.getView() == null) {
            return;
        }
        TreasureChestStatistic.clickTreasure(HiidoSDK.instance().getDeviceId(((ITreasureChestComponent)this.getView()).getMContext()), String.valueOf(LoginUtil.getUid()));
        if (ICoreManagerBase.getCore(IDataReportCore.class) != null) {
            ((IDataReportCore)ICoreManagerBase.getCore(IDataReportCore.class)).reportOnClickTreasureChest();
        }
        boolean isLogined = LoginUtil.isLogined();
        MLog.info((Object)TAG, (String)"onTreasureChestClick: action = %s, mActionType = %d", (Object[])new Object[]{this.mAction, this.mActionType});
        if (this.mActionType == 500 || this.mActionType == 200) {
            ((ITreasureChestComponent)this.getView()).navigation(this.mAction);
        } else if (this.mActionType == 1300) {
            ((ITreasureChestComponent)this.getView()).showH5Dialog(this.mAction);
        } else if (this.mActionType == 1200) {
            MLog.info((Object)TAG, (String)"onTreasureChestClick: isLogined = %b, countDownState = %s", (Object[])new Object[]{isLogined, this.mCountDownState});
            if (!isLogined) {
                ((ITreasureChestComponent)this.getView()).showIntroduceDialog(this.mAction);
            } else if (this.mCountDownState == CountDownState.Finish) {
                ((ITreasureChestComponent)this.getView()).showRollResultDialog(this.mAction);
            } else if (this.mCountDownState == CountDownState.Running) {
                long uid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
                ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).querySubscribeObservable(uid).subscribe((Consumer)new Consumer<Boolean>(){

                    public void accept(Boolean aBoolean) {
                        if (TreasureChestPresenter.this.getView() != null) {
                            ((ITreasureChestComponent)TreasureChestPresenter.this.getView()).showUnfinishedDialog(TreasureChestPresenter.this.mAction, aBoolean);
                        }
                    }
                }, RxUtils.errorConsumer((String)TAG));
            }
        }
    }

    private void dealCountDown(int leftNum, int countDown2, boolean fromRoll) {
        this.mCurrentInitCountDownTime = countDown2;
        this.mCurrentInitLeftNum = leftNum;
        if (fromRoll) {
            this.setHasSendGift(false);
            this.setHasSubscribe(false);
        }
        boolean bl = this.hasRollTime = leftNum > 0;
        if (!this.hasRollTime) {
            if (this.getView() != null) {
                ((ITreasureChestComponent)this.getView()).setComponentVisibility(false);
                if (fromRoll) {
                    ((ITreasureChestComponent)this.getView()).showToast("6\u6b21\u62bd\u5b9d\u7bb1\u673a\u4f1a\u7528\u5b8c\uff0c\u660e\u65e5\u7ee7\u7eed~");
                }
            }
            return;
        }
        if (this.getView() != null && !((ITreasureChestComponent)this.getView()).isLandScape()) {
            ((ITreasureChestComponent)this.getView()).stopTreasureAnimation();
            ((ITreasureChestComponent)this.getView()).setComponentVisibility(true);
        }
        if (LoginUtil.isLogined()) {
            if (this.mTimer == null) {
                this.initTimer();
            } else {
                this.mTimer.stop();
            }
            this.mTimer.setTime(countDown2);
            this.mTimer.start();
        }
    }

    private void initTimer() {
        this.mTimer = new CountDownTimer(){

            @Override
            void onDispose() {
                if (TreasureChestPresenter.this.getView() != null) {
                    ((ITreasureChestComponent)TreasureChestPresenter.this.getView()).setTimerVisibility(false);
                    ((ITreasureChestComponent)TreasureChestPresenter.this.getView()).updateTimerView("");
                }
            }

            @Override
            void onStart() {
                if (TreasureChestPresenter.this.getView() != null) {
                    ((ITreasureChestComponent)TreasureChestPresenter.this.getView()).setTimerVisibility(true);
                    TreasureChestPresenter.this.mCountDownState = CountDownState.Running;
                }
            }

            @Override
            void onTick(long l) {
                if (TreasureChestPresenter.this.getView() != null) {
                    ((ITreasureChestComponent)TreasureChestPresenter.this.getView()).updateTimerView(TreasureChestPresenter.this.secToMin(l));
                }
            }

            @Override
            void onFinish() {
                if (TreasureChestPresenter.this.getView() != null) {
                    ((ITreasureChestComponent)TreasureChestPresenter.this.getView()).setTimerVisibility(false);
                    ((ITreasureChestComponent)TreasureChestPresenter.this.getView()).updateTimerView("");
                    ((ITreasureChestComponent)TreasureChestPresenter.this.getView()).startTreasureAnimation();
                    TreasureChestPresenter.this.mCountDownState = CountDownState.Finish;
                }
            }
        };
    }

    private String secToMin(long l) {
        return String.format(Locale.CHINA, "%02d:%02d", l / 60L, l % 60L);
    }

    void reduceCountDown(long reduceTime) {
        if (this.mTimer != null) {
            this.mTimer.reduce(reduceTime);
        }
    }

    private void registerAction() {
        YYStore.INSTANCE.unregisterProcessor(this.processor);
        YYStore.INSTANCE.registerProcessor(this.processor);
    }

    void onChatInputSwitch(boolean chatInput) {
        if (this.getView() != null) {
            if (chatInput) {
                ((ITreasureChestComponent)this.getView()).setComponentVisibility(false, true);
            } else if (this.hasRollTime() && this.mCountDownState != CountDownState.Invalid) {
                ((ITreasureChestComponent)this.getView()).setComponentVisibility(true, true);
            }
        }
    }

    boolean hasSubscribe() {
        return this.hasSubscribe;
    }

    boolean hasSendGift() {
        return this.hasSendGift;
    }

    void setHasSubscribe(boolean hasSubscribe) {
        this.hasSubscribe = hasSubscribe;
    }

    void setHasSendGift(boolean hasSendGift) {
        this.hasSendGift = hasSendGift;
    }

    boolean hasRollTime() {
        return this.hasRollTime;
    }

    String getImageUrl() {
        return this.mImageUrl;
    }

    boolean isJumpH5Dialog() {
        return this.mActionType == 1300;
    }

    public String getSvgaUrl() {
        return this.mSvgaUrl;
    }

    boolean isOnlyPic() {
        return this.mOnlyPic;
    }

    void doOnPreInitError() {
        MLog.info((Object)TAG, (String)"doOnPreInitError", (Object[])new Object[0]);
        if (this.getView() != null) {
            ((ITreasureChestComponent)this.getView()).setComponentVisibility(false);
        }
    }

    private static enum CountDownState {
        Idle,
        Running,
        Finish,
        Invalid;

    }
}

