/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.treasurechest;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

abstract class CountDownTimer {
    private long mCountDown;
    private long mReduceTime;
    private long mCount;
    private Disposable mDisposable;
    private static final long MAX_COUNT = 9999L;

    CountDownTimer() {
    }

    void setTime(long countDown2) {
        this.mCountDown = countDown2;
        this.mReduceTime = 0L;
    }

    void start() {
        this.stop();
        Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.io()).take(9999L).map((Function)new Function<Long, Long>(){

            public Long apply(Long aLong) throws Exception {
                return CountDownTimer.this.mCountDown - aLong - CountDownTimer.this.mReduceTime;
            }
        }).observeOn(AndroidSchedulers.mainThread()).doOnDispose(new Action(){

            public void run() throws Exception {
                CountDownTimer.this.onDispose();
            }
        }).subscribe((Observer)new Observer<Long>(){

            public void onSubscribe(Disposable d) {
                CountDownTimer.this.mDisposable = d;
                CountDownTimer.this.onStart();
            }

            public void onNext(Long aLong) {
                CountDownTimer.this.mCount = aLong;
                CountDownTimer.this.onTick(aLong);
                if (aLong <= 0L) {
                    this.onComplete();
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
                CountDownTimer.this.onFinish();
                CountDownTimer.this.mDisposable.dispose();
            }
        });
    }

    void reduce(long reduceTime) {
        this.mReduceTime += reduceTime;
    }

    void pause() {
        this.mDisposable.dispose();
        this.mCountDown = this.mCount - 1L;
        this.mReduceTime = 0L;
    }

    void stop() {
        if (this.mDisposable != null) {
            this.mDisposable.dispose();
        }
    }

    abstract void onDispose();

    abstract void onStart();

    abstract void onTick(long var1);

    abstract void onFinish();
}

