/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.richtop.ui;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.richtop.core.RichTopLiveGiftInfo;
import com.yy.mobile.ui.richtop.ui.RichTopGiftRecordComponent;
import com.yy.mobile.ui.startask.TaskCommon;
import com.yy.mobile.ui.streamlight.EntIdentityIconSet;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.widget.ViewHolderAdapterCompatV2;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.gift.GiftConfigItemBase;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.noble.EntIdentity;
import java.util.Date;
import java.util.List;

public class RichTopGiftRecordAdapter
extends ViewHolderAdapterCompatV2 {
    private static final String TAG = "RichTopGiftRecordAdapter";
    private Context mContext;
    private int iconSize = 20;

    public RichTopGiftRecordAdapter(List list2) {
        super(list2);
    }

    public RichTopGiftRecordAdapter(List list2, Context context) {
        this(list2);
        this.mContext = context;
        this.iconSize = DensityUtil.dip2px((Context)this.mContext, (float)20.0f);
    }

    public int getItemViewType(int position) {
        if (this.getItem(position) instanceof RichTopLiveGiftInfo) {
            return 0;
        }
        if (this.getItem(position) instanceof RichTopGiftRecordComponent.DividerEntity) {
            return 2;
        }
        return 1;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public View onCreateView(ViewGroup viewGroup, int position) {
        if (this.getItemViewType(position) == 0) {
            return LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_richtop_gift_record_item, viewGroup, false);
        }
        if (this.getItemViewType(position) == 1) {
            return LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_richtop_nobal_record_item, viewGroup, false);
        }
        return LayoutInflater.from((Context)this.mContext).inflate(R.layout.divider, viewGroup, false);
    }

    public void onBindView(ViewHolderAdapterCompatV2.ViewHolder viewHolder, int position) {
        if (viewHolder.getViewType() == 0) {
            RichTopLiveGiftInfo giftInfo = (RichTopLiveGiftInfo)this.getItem(position);
            TextView nickname = (TextView)viewHolder.get(R.id.tv_nickname);
            RecycleImageView giftIcon = (RecycleImageView)viewHolder.get(R.id.iv_gift_icon);
            TextView giftNumber = (TextView)viewHolder.get(R.id.tv_gift_number);
            TextView time = (TextView)viewHolder.get(R.id.tv_time);
            if (giftInfo != null) {
                GiftConfigItemBase configItemBase;
                time.setText((CharSequence)this.timeToFormat(giftInfo.timeSpan * 1000L));
                nickname.setText((CharSequence)(giftInfo.nick != null ? giftInfo.nick : ""));
                BitmapDrawable bd = giftInfo.nobleLevel > 0 ? ImageLoader.getBitmapDrawableFromResource((int)EntIdentityIconSet.getIconResId((int)giftInfo.nobleLevel), (ImageConfig)ImageConfig.defaultImageConfig()) : ImageLoader.getBitmapDrawableFromResource((int)TaskCommon.vulgarResIds(giftInfo.nobleV2Type, giftInfo.nobleV2Level), (ImageConfig)ImageConfig.defaultImageConfig());
                if (bd != null) {
                    bd.setBounds(0, 0, this.iconSize, this.iconSize);
                    nickname.setCompoundDrawables((Drawable)bd, null, null, null);
                }
                if ((configItemBase = GiftConfigParser.getInstance().getGiftConfigItemByType(giftInfo.giftId)) != null) {
                    ImageLoader.loadImage((String)configItemBase.iconPath, (RecycleImageView)giftIcon, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.lr_ic_default_gift);
                }
                giftNumber.setText((CharSequence)this.mContext.getString(R.string.channel_contribution_send_gift_number, new Object[]{giftInfo.giftNumber}));
            }
        } else if (viewHolder.getViewType() == 1) {
            EntIdentity.SaleNobelCommissionWarn warnInfo = null;
            try {
                warnInfo = (EntIdentity.SaleNobelCommissionWarn)this.getItem(position);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            TextView time = (TextView)viewHolder.get(R.id.tv_time);
            TextView context = (TextView)viewHolder.get(R.id.tv_context);
            if (null == warnInfo) {
                return;
            }
            time.setText((CharSequence)warnInfo.time);
            String nick = null == warnInfo.nick ? "" : (warnInfo.nick.length() > 80 ? warnInfo.nick.substring(0, 80) + "..." : warnInfo.nick);
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)nick);
            spannableStringBuilder.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#000000")), 0, nick.length(), 33);
            spannableStringBuilder.setSpan((Object)new StyleSpan(1), 0, nick.length(), 33);
            spannableStringBuilder.append((CharSequence)"\u4e3a\u60a8\u5f00\u901a\u4e86");
            String nobal = EntIdentity.getNobleName((int)warnInfo.uNobleType);
            int start = spannableStringBuilder.length();
            int end = start + nobal.length();
            spannableStringBuilder.append((CharSequence)nobal);
            spannableStringBuilder.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ff4f4f")), start, end, 33);
            spannableStringBuilder.setSpan((Object)new StyleSpan(1), start, end, 33);
            spannableStringBuilder.append((CharSequence)"\uff0c\u60a8\u83b7\u5f97");
            String comiss = String.valueOf(warnInfo.uCommissions);
            start = spannableStringBuilder.length();
            end = start + comiss.length();
            spannableStringBuilder.append((CharSequence)comiss);
            spannableStringBuilder.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ff4f4f")), start, end, 33);
            spannableStringBuilder.append((CharSequence)"\u4f63\u91d1");
            context.setText((CharSequence)spannableStringBuilder);
            if (Build.VERSION.SDK_INT >= 17) {
                context.setTextDirection(3);
            }
        }
    }

    private String timeToFormat(long time) {
        if (time > 0L) {
            return CommonUtils.getSimpleDateFormat((String)"HH:mm:ss").format(new Date(time));
        }
        return "";
    }
}

