/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat.model.dispatcher;

import com.yy.mobile.ui.publicchat.model.dispatcher.IDispatcher;
import com.yy.mobile.ui.publicchat.model.parser.IParser;
import com.yy.mobile.ui.publicchat.model.queue.ChannelMessageQueue;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChannelMessage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0002\u0013\u0014B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/yy/mobile/ui/publicchat/model/dispatcher/ParseDispatcher;", "Ljava/lang/Thread;", "Lcom/yy/mobile/ui/publicchat/model/dispatcher/IDispatcher;", "defaultParser", "Lcom/yy/mobile/ui/publicchat/model/parser/IParser;", "waitQueue", "Lcom/yy/mobile/ui/publicchat/model/queue/ChannelMessageQueue;", "listener", "Lcom/yy/mobile/ui/publicchat/model/dispatcher/ParseDispatcher$ParseResultListener;", "(Lcom/yy/mobile/ui/publicchat/model/parser/IParser;Lcom/yy/mobile/ui/publicchat/model/queue/ChannelMessageQueue;Lcom/yy/mobile/ui/publicchat/model/dispatcher/ParseDispatcher$ParseResultListener;)V", "()V", "isStop", "", "queue", "isWorking", "run", "", "startWork", "stopWork", "Companion", "ParseResultListener", "pluginunionlive_release"})
public final class ParseDispatcher
extends Thread
implements IDispatcher {
    private IParser defaultParser;
    private ChannelMessageQueue queue;
    private ParseResultListener listener;
    private boolean isStop;
    @NotNull
    public static final String TAG = "ParseDispatcher";
    public static final Companion Companion = new Companion(null);

    @Override
    public void startWork() {
        MLog.info((Object)TAG, (String)"parseThread start work", (Object[])new Object[0]);
        if (this.isStop) {
            this.start();
            this.isStop = false;
        }
    }

    @Override
    public void stopWork() {
        this.isStop = true;
        this.interrupt();
        MLog.info((Object)TAG, (String)"parseThread stop work", (Object[])new Object[0]);
    }

    @Override
    public boolean isWorking() {
        return super.isAlive() && !this.isStop;
    }

    @Override
    public void run() {
        while (!this.isStop) {
            try {
                ChannelMessageQueue channelMessageQueue = this.queue;
                if (channelMessageQueue == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"queue");
                }
                ChannelMessage msg = channelMessageQueue.next();
                MLog.debug((Object)TAG, (String)"parse begin", (Object[])new Object[0]);
                IParser iParser = this.defaultParser;
                if (iParser == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"defaultParser");
                }
                boolean success = iParser.parse(msg);
                MLog.debug((Object)TAG, (String)"parse end", (Object[])new Object[0]);
                if (success) {
                    ParseResultListener parseResultListener = this.listener;
                    if (parseResultListener == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
                    }
                    if (parseResultListener != null) {
                        parseResultListener.onParseSuccess(msg);
                    }
                    continue;
                }
                MLog.warn((Object)TAG, (String)"parse message error", (Object[])new Object[0]);
            }
            catch (InterruptedException e) {
                if (!this.isStop) continue;
                MLog.info((Object)TAG, (String)"quit parseDispatcher thread", (Object[])new Object[0]);
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"parse message exception ", (Throwable)e, (Object[])new Object[0]);
            }
        }
        MLog.info((Object)TAG, (String)"quit parseDispatcher thread", (Object[])new Object[0]);
    }

    public ParseDispatcher() {
        this.isStop = true;
    }

    public ParseDispatcher(@NotNull IParser defaultParser, @NotNull ChannelMessageQueue waitQueue, @NotNull ParseResultListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)defaultParser, (String)"defaultParser");
        Intrinsics.checkParameterIsNotNull((Object)waitQueue, (String)"waitQueue");
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this();
        this.defaultParser = defaultParser;
        this.queue = waitQueue;
        this.listener = listener2;
        MLog.info((Object)TAG, (String)"parseThread created", (Object[])new Object[0]);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/yy/mobile/ui/publicchat/model/dispatcher/ParseDispatcher$ParseResultListener;", "", "onParseSuccess", "", "message", "Lcom/yymobile/core/channel/ChannelMessage;", "pluginunionlive_release"})
    public static interface ParseResultListener {
        public void onParseSuccess(@NotNull ChannelMessage var1);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/mobile/ui/publicchat/model/dispatcher/ParseDispatcher$Companion;", "", "()V", "TAG", "", "pluginunionlive_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

