/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat.model;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.duowan.mobile.entlive.events.IPublicChatBroadcastClient_appendRevenueMessage_EventArgs;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.liveapi.chatemotion.uicore.IChatEmotionCore;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.richtext.ChannelTicketFilter;
import com.yy.mobile.richtext.YGroupTicketFilter;
import com.yy.mobile.sdkwrapper.yylive.event.ReceiveChannelHistoryMsgEventArgs;
import com.yy.mobile.ui.gift.message.ArGiftUpgradeMessage;
import com.yy.mobile.ui.publicchat.EnterChannelMessage;
import com.yy.mobile.ui.publicchat.MergeChannelMessage;
import com.yy.mobile.ui.publicchat.MergeMessageManager;
import com.yy.mobile.ui.publicchat.PublicChatEventReceiver;
import com.yy.mobile.ui.publicchat.PublicChatRevenueController;
import com.yy.mobile.ui.publicchat.TailManager;
import com.yy.mobile.ui.publicchat.core.IPublicChatBroadcastCore;
import com.yy.mobile.ui.publicchat.core.IPublicChatBroadcastCoreEx;
import com.yy.mobile.ui.publicchat.handler.ParserUtil;
import com.yy.mobile.ui.publicchat.handler.PublicChatSettingPref;
import com.yy.mobile.ui.publicchat.model.PublicChatBaseModel;
import com.yy.mobile.ui.publicchat.model.event.AppendChannelMessageEvent;
import com.yy.mobile.ui.publicchat.model.parser.PublicChatBaseParser;
import com.yy.mobile.ui.publicchat.model.parser.PublicChatParser;
import com.yy.mobile.ui.sharebroadcast.ShareMessage;
import com.yy.mobile.ui.swivelChair.TurnChairMessage;
import com.yy.mobile.ui.turntable.info.TurnTableTurMessage;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.LiveRxBus;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.cavalier.TaskMessage;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.PublicChatMessage;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.noble.NobleLevelUpgradeChannelMessage;
import com.yymobile.core.truelove.TrueLoveMessage;
import com.yymobile.liveapi.plugincenter.PluginPublicMessage;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class PublicChatLiveModel
extends PublicChatBaseModel
implements EventCompat {
    private static final String TAG = "PublicChatLiveModel";
    private static String tinyVideoResInfo = null;
    private static String from = null;
    private Disposable mHistoryEventDisposable;
    private Handler handler = new Handler();
    private PublicChatSettingPref settingPref = PublicChatSettingPref.Companion.getInstance();
    private PublicChatEventReceiver publicChatEventReceiver = PublicChatEventReceiver.instance();
    private MergeMessageManager enterMergeManager = MergeMessageManager.Companion.getInstance();

    public PublicChatLiveModel() {
        this(0, 1);
    }

    public PublicChatLiveModel(int historyType) {
        this(historyType, 1);
    }

    public PublicChatLiveModel(int historyType, int type2) {
        super(historyType, type2);
    }

    @Override
    @NonNull
    protected PublicChatBaseParser onCreateParser() {
        return new PublicChatParser();
    }

    @Override
    public void initModel(Context context) {
        super.initModel(context);
        this.settingPref.onCreate(this.generateHostActivityName());
        this.enterMergeManager.onCreate(this.generateHostActivityName());
        this.publicChatEventReceiver.mChatFilterType = this.getChatFilterType();
        this.publicChatEventReceiver.mHistoryType = this.getHistoryType();
        this.publicChatEventReceiver.onCreate(this.generateHostActivityName());
        MLog.info((Object)TAG, (String)"post enter notice event", (Object[])new Object[0]);
        this.requestNotice();
        this.requestHistoryMsgAndSendEnterMsg();
    }

    private void requestHistoryMsgAndSendEnterMsg() {
        this.handler.removeCallbacksAndMessages(null);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                PublicChatLiveModel.this.enterChannelTextRequest();
                PublicChatLiveModel.this.requestHistoryMsg();
            }
        }, 100L);
    }

    @Override
    public void deInitModel() {
        super.deInitModel();
        if (this.mHistoryEventDisposable != null && !this.mHistoryEventDisposable.isDisposed()) {
            this.mHistoryEventDisposable.dispose();
        }
        this.handler.removeCallbacksAndMessages(null);
        this.settingPref.onDestroy(this.generateHostActivityName());
        this.publicChatEventReceiver.onDestroy(this.generateHostActivityName());
        this.enterMergeManager.onDestroy(this.generateHostActivityName());
    }

    @Override
    public boolean onInterceptBeforeShow(@NonNull ChannelMessage message) {
        if (message instanceof EnterChannelMessage) {
            return this.enterMergeManager.mergeMessage(message, MergeChannelMessage.MergeMessageType.ENTER);
        }
        if (message instanceof TrueLoveMessage) {
            return true;
        }
        return super.onInterceptBeforeShow(message);
    }

    @Override
    public boolean onInterceptBeforeParse(@NotNull ChannelMessage message) {
        if (message == null || message.text == null) {
            return true;
        }
        boolean isIcnShow = ParserUtil.isShowIcon(message);
        if (message instanceof EnterChannelMessage) {
            if (TextUtils.isEmpty((CharSequence)message.nickname.trim())) {
                return true;
            }
            if (this.getChatFilterType() == 2) {
                return true;
            }
            if (!this.settingPref.getShowApproach()) {
                return true;
            }
        } else if (message instanceof TurnTableTurMessage) {
            if (YGroupTicketFilter.isYGroupTicketMessage((CharSequence)message.text) || !isIcnShow) {
                return true;
            }
            if (ChannelTicketFilter.isChannelTicketMessage((CharSequence)message.text)) {
                PluginBus.INSTANCE.get().post((Object)new IPublicChatBroadcastClient_appendRevenueMessage_EventArgs(message, PublicChatRevenueController.Priority.PLANE_TURN_TABLE));
            } else {
                PluginBus.INSTANCE.get().post((Object)new IPublicChatBroadcastClient_appendRevenueMessage_EventArgs(message, PublicChatRevenueController.Priority.TURN_TABLE));
            }
        } else if (message instanceof NobleLevelUpgradeChannelMessage) {
            if (!isIcnShow) {
                return true;
            }
        } else if (message instanceof TrueLoveMessage) {
            if (!isIcnShow) {
                return true;
            }
            PluginBus.INSTANCE.get().post((Object)new IPublicChatBroadcastClient_appendRevenueMessage_EventArgs(message, PublicChatRevenueController.Priority.TRUE_LOVE));
        } else if (message instanceof TaskMessage) {
            if (!isIcnShow) {
                return true;
            }
            PluginBus.INSTANCE.get().post((Object)new IPublicChatBroadcastClient_appendRevenueMessage_EventArgs(message, PublicChatRevenueController.Priority.TASK));
        } else if (message instanceof TurnChairMessage) {
            if (!isIcnShow) {
                return true;
            }
            PluginBus.INSTANCE.get().post((Object)new IPublicChatBroadcastClient_appendRevenueMessage_EventArgs(message, PublicChatRevenueController.Priority.TURN_CHAIR));
        } else if (message instanceof PluginPublicMessage) {
            if (!isIcnShow) {
                return true;
            }
            PluginBus.INSTANCE.get().post((Object)new IPublicChatBroadcastClient_appendRevenueMessage_EventArgs(message, PublicChatRevenueController.Priority.PLANE));
        } else if (message instanceof ShareMessage) {
            if (!this.settingPref.getShowShare()) {
                return true;
            }
        } else if (message instanceof ArGiftUpgradeMessage) {
            if (!isIcnShow) {
                return true;
            }
            PluginBus.INSTANCE.get().post((Object)new IPublicChatBroadcastClient_appendRevenueMessage_EventArgs(message, PublicChatRevenueController.Priority.PLANE));
        } else if (message.channelMessageType == ChannelMessage.ChannelMsgType.SUBSCRIBE_MESSAGE_TYPE && !this.settingPref.getShowFollow()) {
            return true;
        }
        return false;
    }

    @Override
    public void onJoinChannelSuccess() {
        RxBus.getDefault().post((Object)new AppendChannelMessageEvent((ChannelMessage)this.createRuleNoticeMessage("\u5e73\u53f0\u6b63\u5bf9\u76f4\u64ad\u5185\u5bb9\u8fdb\u884c24\u5c0f\u65f6\u5de1\u67e5\uff0c\u4efb\u4f55\u4f20\u64ad\u8fdd\u6cd5\u3001\u8fdd\u89c4\u3001\u4f4e\u4fd7\u3001\u8272\u60c5\u3001\u66b4\u529b\u7b49\u4e0d\u826f\u4fe1\u606f\u5c06\u4f1a\u88ab\u5c01\u505c\u8d26\u53f7\uff1b\u8bf7\u52ff\u8f7b\u4fe1\u4ed6\u4eba\uff0c\u8c28\u9632\u4e0a\u5f53\u53d7\u9a97\u3002")));
        this.requestHistoryMsgAndSendEnterMsg();
        this.enterMergeManager.onCreate(this.generateHostActivityName());
    }

    @Override
    public void onLeaveChannelSuccess() {
        if (this.mHistoryEventDisposable != null && !this.mHistoryEventDisposable.isDisposed()) {
            this.mHistoryEventDisposable.dispose();
        }
        this.enterMergeManager.onDestroy(this.generateHostActivityName());
        tinyVideoResInfo = null;
        from = null;
    }

    private void enterChannelTextRequest() {
        if (!((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
            HashMap extendInfo = ICoreManagerBase.getChannelLinkCore().getExtendInfo();
            if (tinyVideoResInfo == null && extendInfo.containsKey("TinyVideoData")) {
                tinyVideoResInfo = (String)extendInfo.get("TinyVideoData");
            }
            if (from == null && extendInfo.containsKey("channel_from")) {
                from = (String)extendInfo.get("channel_from");
            }
            if (TailManager.getInstatnce().isSongPrivilegeChannel()) {
                ((IPublicChatBroadcastCoreEx)ICoreManagerBase.getCore(IPublicChatBroadcastCore.class)).enterChannelTextRequest("\u70b9\u6b4c\u7279\u6743\u7528\u6237\uff0c\u6b22\u8fce\u6765\u5230\u76f4\u64ad\u95f4", tinyVideoResInfo, from);
            } else {
                ((IPublicChatBroadcastCoreEx)ICoreManagerBase.getCore(IPublicChatBroadcastCore.class)).enterChannelTextRequest(null, tinyVideoResInfo, from);
            }
        }
    }

    private void requestHistoryMsg() {
        if (this.getHistoryType() == 1) {
            IChannelLinkCore channelLinkCore = ICoreManagerBase.getChannelLinkCore();
            IChatEmotionCore chatEmotionCore = (IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class);
            if (channelLinkCore != null && chatEmotionCore != null) {
                chatEmotionCore.requestHistoryMsg(channelLinkCore.getCurrentChannelInfo().topSid, channelLinkCore.getCurrentChannelInfo().subSid);
                this.subscribeHistoryEvent();
            }
        }
    }

    private void subscribeHistoryEvent() {
        if (this.mHistoryEventDisposable != null && !this.mHistoryEventDisposable.isDisposed()) {
            return;
        }
        this.mHistoryEventDisposable = LiveRxBus.getInstance().register(ReceiveChannelHistoryMsgEventArgs.class).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<ReceiveChannelHistoryMsgEventArgs>(){

            public void accept(@io.reactivex.annotations.NonNull ReceiveChannelHistoryMsgEventArgs receiveChannelMsgEventArgs) throws Exception {
                if (FP.empty((Collection)receiveChannelMsgEventArgs.historyTexts)) {
                    return;
                }
                for (ReceiveChannelHistoryMsgEventArgs.MsgTextChat msgTextChat : receiveChannelMsgEventArgs.historyTexts) {
                    PublicChatMessage message = new PublicChatMessage();
                    message.uid = msgTextChat.uid;
                    message.sid = msgTextChat.sid;
                    message.nickname = msgTextChat.nickname;
                    message.text = msgTextChat.text;
                    RxBus.getDefault().post((Object)new AppendChannelMessageEvent((ChannelMessage)message));
                }
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"ReceiveChannelHistoryMsgEventArgs error"));
    }
}

