/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.base.ui.WrapperComponent;
import com.yy.mobile.base.utils.ViewUtil;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onAnchorStopLiveBroad_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.metadata.AudienceMetadataManager;
import com.yy.mobile.sdkwrapper.yylive.media.MediaVideoMsgWrapper;
import com.yy.mobile.sdkwrapper.yylive.media.event.MetaDataChangeEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoPlayDelayInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoViewLossNotifyInfoEventArgs;
import com.yy.mobile.ui.profile.CustomFunctionComponent$$EventBinder;
import com.yy.mobile.ui.touch.uicore.ITouchCore;
import com.yy.mobile.ui.widget.TipsPopupWindow;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.optional.Optional;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.pluginsconfig.IPluginPropertyCore;
import com.yymobile.core.pluginsconfig.PluginPropertyKey;
import com.yymobile.core.statistic.IHiidoStatisticCore;

public class CustomFunctionComponent
extends WrapperComponent {
    public static final String SHOW_NETWORK_TIP = "mShowNetWorkLossTips";
    private static final String TAG = "CustomFunctionComponent";
    private View mLeakNetworkIcon;
    private View ivAnchorStopPreviewIcon;
    private TextView mLeakNetworkText;
    private TextView tvAnchorStopPreview;
    private boolean isAnchorPreviewStop = false;
    private int lossCount = 0;
    private TipsPopupWindow tipsPopupWindow;
    private boolean mIsLandscape = false;
    private boolean mShowNetWorkLossTips;
    private Runnable mDismissTipsRunable = new Runnable(){

        @Override
        public void run() {
            if (CustomFunctionComponent.this.mLeakNetworkIcon != null) {
                CustomFunctionComponent.this.mLeakNetworkIcon.setVisibility(8);
            }
            if (CustomFunctionComponent.this.mLeakNetworkText != null) {
                CustomFunctionComponent.this.mLeakNetworkText.setVisibility(8);
            }
        }
    };
    private View.OnClickListener mLeakNetworkIconClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (CustomFunctionComponent.this.checkActivityValid() && CustomFunctionComponent.this.mLeakNetworkText != null && CustomFunctionComponent.this.mLeakNetworkText.getVisibility() != 0) {
                SpannableString sbStr = new SpannableString((CharSequence)CustomFunctionComponent.this.getString(R.string.sty_video_publisher_loss));
                sbStr.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#FFFFFF")), 0, sbStr.length(), 33);
                CustomFunctionComponent.this.mLeakNetworkText.setText((CharSequence)sbStr);
                CustomFunctionComponent.this.mLeakNetworkText.setVisibility(0);
                Handler handler = CustomFunctionComponent.this.getHandler();
                if (handler != null) {
                    handler.removeCallbacks(CustomFunctionComponent.this.mDismissTipsRunable);
                    handler.postDelayed(CustomFunctionComponent.this.mDismissTipsRunable, 1000L);
                }
            }
        }
    };
    private int playDelay = 0;
    private Runnable hideTipsPopWindowRunnable = new Runnable(){

        @Override
        public void run() {
            CustomFunctionComponent.this.hideTipsPopWindow();
        }
    };
    private EventBinder mCustomFunctionComponentSniperEventBinder;

    public int getLayout() {
        return R.layout.cp_custom_func;
    }

    public void initVariable(@Nullable Bundle savedInstanceState) {
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mShowNetWorkLossTips = this.getArguments().getBoolean(SHOW_NETWORK_TIP, true);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void initViewAndData() {
        this.mLeakNetworkIcon = this.f(R.id.basic_live_leak_network_icon);
        this.mLeakNetworkIcon.setOnClickListener(this.mLeakNetworkIconClickListener);
        this.mLeakNetworkText = (TextView)this.f(R.id.live_leak_network_text_tips);
        this.tvAnchorStopPreview = (TextView)this.f(R.id.tv_live_anchor_network_tips);
        this.ivAnchorStopPreviewIcon = this.f(R.id.iv_live_anchor_network_icon);
    }

    public void initListener() {
    }

    private void initLeakNetWorkTips() {
        Handler handler;
        if (this.mLeakNetworkIcon != null) {
            this.mLeakNetworkIcon.setVisibility(8);
        }
        if (this.mLeakNetworkText != null) {
            this.mLeakNetworkText.setVisibility(8);
        }
        if ((handler = this.getHandler()) != null) {
            handler.removeCallbacks(this.mDismissTipsRunable);
        }
    }

    private void onAnchorLoss() {
        if (this.mLeakNetworkIcon != null && this.isLossCanShow()) {
            this.mLeakNetworkIcon.setVisibility(0);
            if (this.mLeakNetworkText != null) {
                this.mLeakNetworkText.setVisibility(0);
                SpannableString sbStr = new SpannableString((CharSequence)this.getString(R.string.sty_video_publisher_loss));
                sbStr.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#FFFFFF")), 0, sbStr.length(), 33);
                this.mLeakNetworkText.setText((CharSequence)sbStr);
                ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51803", "0002");
            }
            if (this.getHandler() != null) {
                this.getHandler().removeCallbacks(this.mDismissTipsRunable);
                this.getHandler().postDelayed(this.mDismissTipsRunable, 3000L);
            }
        } else {
            MLog.info((Object)TAG, (String)"on Anchor Loss : layout is null", (Object[])new Object[0]);
        }
    }

    @BusEvent
    public void onAnchorStopPreview(MetaDataChangeEventArgs args) {
        if (args != null) {
            this.isAnchorPreviewStop = AudienceMetadataManager.getInstance().isAnchorPreviewStop();
            int delay = this.isAnchorPreviewStop ? this.playDelay : 0;
            MLog.info((Object)TAG, (String)("[onAnchorStopPreview] isPreviewStop=" + this.isAnchorPreviewStop + ",delay=" + delay), (Object[])new Object[0]);
            this.tvAnchorStopPreview.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CustomFunctionComponent.this.setAnchorStopPreviewUI(CustomFunctionComponent.this.isAnchorPreviewStop);
                }
            }, (long)delay);
        } else {
            MLog.error((Object)TAG, (String)"unexcepted result", (Object[])new Object[0]);
        }
    }

    private void setAnchorStopPreviewUI(boolean isAnchorPreviewStop) {
        ViewUtil.v((View)this.tvAnchorStopPreview, (int)(isAnchorPreviewStop ? 0 : 8));
        ViewUtil.v((View)this.ivAnchorStopPreviewIcon, (int)(isAnchorPreviewStop ? 0 : 8));
    }

    @BusEvent(busType=1, busName="Live")
    public void onVideoPlayDelayInfo(VideoPlayDelayInfoEventArgs args) {
        MLog.info((Object)TAG, (String)("[onVideoPlayDelayInfo] playDelay=" + args.playDelay), (Object[])new Object[0]);
        this.playDelay = args.playDelay;
    }

    @BusEvent
    public void recAnchorStopLiveBroadEvent(IMobileLiveClient_onAnchorStopLiveBroad_EventArgs args) {
        MLog.info((Object)TAG, (String)("receive recAnchorStopLiveBroadEvent args=" + args), (Object[])new Object[0]);
        this.setAnchorStopPreviewUI(false);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.initLeakNetWorkTips();
        this.hideTipsPopWindow();
        this.getHandler().removeCallbacks(this.mDismissTipsRunable);
        this.getHandler().removeCallbacks(this.hideTipsPopWindowRunnable);
        this.lossCount = 0;
        this.mIsLandscape = false;
        Object var2_1 = null;
        if (this.mCustomFunctionComponentSniperEventBinder != null) {
            this.mCustomFunctionComponentSniperEventBinder.unBindEvent();
        }
    }

    @BusEvent(sync=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        MLog.info((Object)TAG, (String)"onJoinChannelSuccess", (Object[])new Object[0]);
        this.initLeakNetWorkTips();
        this.initAnchorPause();
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"leaveCurrentChannel", (Object[])new Object[0]);
        this.initLeakNetWorkTips();
        this.setAnchorStopPreviewUI(false);
    }

    @BusEvent(sync=true)
    public void onVideoViewerLossNotifyInfo(VideoViewLossNotifyInfoEventArgs busEventArgs) {
        if (!(this.checkActivityValid() || this.isResumed() || this.isVisible())) {
            return;
        }
        int viewerLossValue = (Integer)Optional.of(busEventArgs.statMap.get(MediaVideoMsgWrapper.ViewerLossNotifyKeyWrapper.LNK_VIEWER_LOSS_NOTIFY)).orElse((Object)-1);
        if (ICoreManagerBase.getCore(ITouchCore.class) != null && !((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).getClearScreenSate()) {
            switch (viewerLossValue) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.isAnchorPreviewStop) break;
                    this.onAnchorLoss();
                    break;
                }
                case 2: {
                    this.onViewerLoss();
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    private void onViewerLoss() {
        boolean v = (Boolean)((IPluginPropertyCore)ICoreManagerBase.getCore(IPluginPropertyCore.class)).getCustomerConfig(PluginPropertyKey.NetWorkLossTips.getKey(), (Object)true);
        if (v && this.isLossCanShow()) {
            SpannableString sbStr = new SpannableString((CharSequence)this.getString(R.string.str_video_viewer_loss));
            sbStr.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#FFFFFF")), 0, sbStr.length(), 33);
            try {
                View mSlideMenuViewLandscape = this.getActivity().findViewById(R.id.live_audience_slide_menu_landscape);
                View mSlideMenuViewPortrait = this.getActivity().findViewById(R.id.live_audience_slide_menu_portrait);
                if (this.mIsLandscape && mSlideMenuViewLandscape != null) {
                    this.showTipsPopWindow(sbStr.toString(), mSlideMenuViewLandscape);
                    ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51803", "0002");
                } else if (mSlideMenuViewPortrait != null) {
                    this.showTipsPopWindow(sbStr.toString(), mSlideMenuViewPortrait);
                    ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51803", "0002");
                }
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, (Throwable)throwable);
            }
        }
    }

    private boolean isLossCanShow() {
        if (!this.mShowNetWorkLossTips) {
            return false;
        }
        if (this.lossCount >= 3) {
            return false;
        }
        ++this.lossCount;
        return true;
    }

    private void initAnchorPause() {
        boolean hasChannelVideo = ICoreManagerBase.getMediaCore().channelHasVideo();
        if (!hasChannelVideo) {
            this.setAnchorStopPreviewUI(false);
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        this.mIsLandscape = isLandscape;
    }

    private void showTipsPopWindow(String tips, View goalView) {
        if (this.checkActivityValid() && this.isResumed()) {
            if (this.tipsPopupWindow != null && this.tipsPopupWindow.isShowing()) {
                this.tipsPopupWindow.dismiss();
                this.tipsPopupWindow = null;
            }
            this.getHandler().removeCallbacks(this.hideTipsPopWindowRunnable);
            this.tipsPopupWindow = new TipsPopupWindow((Context)this.getActivity(), tips, 2);
            this.tipsPopupWindow.setText(tips);
            this.tipsPopupWindow.showAsDropDown(goalView, -((int)ResolutionUtils.convertDpToPixel((float)5.0f, (Context)this.getActivity())), -(goalView.getMeasuredHeight() + this.tipsPopupWindow.getTextHeight()));
            this.getHandler().postDelayed(this.hideTipsPopWindowRunnable, 3000L);
        }
    }

    private void hideTipsPopWindow() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.tipsPopupWindow != null) {
            if (this.tipsPopupWindow.isShowing()) {
                this.tipsPopupWindow.dismiss();
            }
            this.tipsPopupWindow = null;
        }
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mCustomFunctionComponentSniperEventBinder == null) {
            this.mCustomFunctionComponentSniperEventBinder = new CustomFunctionComponent$$EventBinder();
        }
        this.mCustomFunctionComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }
}

