/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.privatechat;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.richtext.EmoticonFilter;
import com.yy.mobile.richtext.RichTextManager;
import com.yy.mobile.richtext.media.ImVoiceFilter;
import com.yy.mobile.richtext.media.ImageFilter;
import com.yy.mobile.richtext.wrap.RichTextWrapper;
import com.yy.mobile.ui.privatechat.AbstractPrivateChatComponent;
import com.yy.mobile.ui.privatechat.uicore.IPrivateChatCore;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelOneChat0neMessage;
import com.yymobile.core.role.RoleMobuleUtil;
import com.yymobile.core.sensitivewords.ISensitiveWordsCore;
import java.util.ArrayList;
import java.util.List;

public class PrivateChatAdapter
extends BaseAdapter {
    private static final String TAG = "PrivateChatAdapter";
    public Activity mContext;
    private List<ChannelOneChat0neMessage> chatData = new ArrayList<ChannelOneChat0neMessage>();
    private List<RichTextManager.Feature> features = new ArrayList<RichTextManager.Feature>();
    private int maxWidth;
    private SendUid sendUid;
    private boolean isIcnShow = true;

    public PrivateChatAdapter(Activity context) {
        this.mContext = context;
        this.features.add(RichTextManager.Feature.CHANNELAIRTICKET);
        this.features.add(RichTextManager.Feature.EMOTICON);
        this.features.add(RichTextManager.Feature.GROUPTICKET);
    }

    public void setChatData(List<ChannelOneChat0neMessage> data) {
        if (data != null) {
            this.chatData.clear();
            this.chatData.addAll(data);
            this.notifyDataSetChanged();
        }
    }

    public void setSendUid(SendUid sendUid) {
        this.sendUid = sendUid;
    }

    public int getCount() {
        if (null != this.chatData && this.chatData.size() > 0) {
            return this.chatData.size();
        }
        return 0;
    }

    public ChannelOneChat0neMessage getItem(int position) {
        if (null != this.chatData && this.chatData.size() > position && position >= 0) {
            return this.chatData.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            viewHolder = new ViewHolder();
            viewHolder.leftHolder = new ChatHolder();
            viewHolder.rightHolder = new ChatHolder();
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.private_chat_item, null);
            viewHolder.tvSafeNotice = (TextView)convertView.findViewById(R.id.tv_safe_notice);
            this.initLeftHolder(viewHolder, convertView);
            this.initRightHolder(viewHolder, convertView);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        final ChannelOneChat0neMessage chat0neMessage = this.getItem(position);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("zs --- chat0neMessage " + chat0neMessage), (Object[])new Object[0]);
        }
        if (chat0neMessage.toUid == LoginUtil.getUid()) {
            this.onLayout(viewHolder, false);
        } else if (chat0neMessage.formUid == LoginUtil.getUid()) {
            this.onLayout(viewHolder, true);
        }
        if (chat0neMessage.formUid == LoginUtil.getUid()) {
            SpannableStringBuilder sb = new SpannableStringBuilder((CharSequence)"\u6211\u5bf9");
            Drawable drawable2 = RoleMobuleUtil.getModuleDrawable((long)chat0neMessage.toUid);
            if (null != drawable2 && this.isIcnShow) {
                int start = sb.length();
                sb.append((CharSequence)"/ ");
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                sb.setSpan((Object)new CustomImageSpan(drawable2), start, start + 1, 33);
            }
            sb.append((CharSequence)(AbstractPrivateChatComponent.getStageName(chat0neMessage.toUid, chat0neMessage.toNickname) + "\u8bf4"));
            viewHolder.rightHolder.tvName.setText((CharSequence)sb);
            viewHolder.rightHolder.tvName.setTextColor(Color.rgb((int)153, (int)153, (int)153));
            this.showMessage(viewHolder.rightHolder.richTextWrapper, StringUtils.narrow((String)chat0neMessage.text));
        } else if (chat0neMessage.toUid == LoginUtil.getUid()) {
            SpannableStringBuilder sp = new SpannableStringBuilder((CharSequence)AbstractPrivateChatComponent.getStageName(chat0neMessage.formUid, chat0neMessage.formNickname));
            Drawable drawable3 = RoleMobuleUtil.getModuleDrawable((long)chat0neMessage.formUid);
            if (null != drawable3 && this.isIcnShow) {
                sp.insert(0, (CharSequence)"/ ");
                drawable3.setBounds(0, 0, drawable3.getIntrinsicWidth(), drawable3.getIntrinsicHeight());
                sp.setSpan((Object)new CustomImageSpan(drawable3), 0, 1, 33);
            }
            viewHolder.leftHolder.tvName.setText((CharSequence)sp);
            viewHolder.leftHolder.tvName.setTextColor(Color.rgb((int)66, (int)164, (int)255));
            this.showMessage(viewHolder.leftHolder.richTextWrapper, StringUtils.narrow((String)chat0neMessage.text));
        }
        if (chat0neMessage.formUid != LoginUtil.getUid() && ((ISensitiveWordsCore)ICoreManagerBase.getCore(ISensitiveWordsCore.class)).containFinanceSensitiveWord(chat0neMessage.text)) {
            boolean isShow;
            if (position == this.chatData.size() - 1 && !((ChannelOneChat0neMessage)((IPrivateChatCore)ICoreManagerBase.getCore(IPrivateChatCore.class)).getChannelOneChat0neMessageList().get((int)position)).isShowYYSafeNotice && (isShow = ((IPrivateChatCore)ICoreManagerBase.getCore(IPrivateChatCore.class)).isShowYYSafeNotice())) {
                ((ChannelOneChat0neMessage)((IPrivateChatCore)ICoreManagerBase.getCore(IPrivateChatCore.class)).getChannelOneChat0neMessageList().get((int)position)).isShowYYSafeNotice = true;
            }
            if (((ChannelOneChat0neMessage)((IPrivateChatCore)ICoreManagerBase.getCore(IPrivateChatCore.class)).getChannelOneChat0neMessageList().get((int)position)).isShowYYSafeNotice) {
                viewHolder.tvSafeNotice.setVisibility(0);
            } else {
                viewHolder.tvSafeNotice.setVisibility(8);
            }
        } else {
            viewHolder.tvSafeNotice.setVisibility(8);
        }
        viewHolder.leftHolder.container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PrivateChatAdapter.this.sendUid != null) {
                    PrivateChatAdapter.this.sendUid.backData(v, position, chat0neMessage);
                }
            }
        });
        viewHolder.rightHolder.container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PrivateChatAdapter.this.sendUid != null) {
                    PrivateChatAdapter.this.sendUid.backData(v, position, chat0neMessage);
                }
            }
        });
        return convertView;
    }

    private void initLeftHolder(ViewHolder viewHolder, View view) {
        viewHolder.leftHolder.container = (ViewGroup)view.findViewById(R.id.left_container);
        if (viewHolder.leftHolder.container.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            int margin = DimenConverter.dip2px((Context)this.mContext, (float)55.0f);
            this.setMaxWidth(ResolutionUtils.getScreenWidth((Context)this.mContext) - 3 * margin - 10);
        }
        viewHolder.leftHolder.tvName = (TextView)view.findViewById(R.id.left_portrait);
        viewHolder.leftHolder.richTextWrapper = new RichTextWrapper((TextView)view.findViewById(R.id.left_message));
        viewHolder.leftHolder.richTextWrapper.setMaxWidth(this.maxWidth);
    }

    private void initRightHolder(ViewHolder viewHolder, View view) {
        viewHolder.rightHolder.container = (ViewGroup)view.findViewById(R.id.right_container);
        viewHolder.rightHolder.tvName = (TextView)view.findViewById(R.id.right_portrait);
        viewHolder.rightHolder.richTextWrapper = new RichTextWrapper((TextView)view.findViewById(R.id.right_message));
        viewHolder.rightHolder.richTextWrapper.setMaxWidth(this.maxWidth);
    }

    private void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    private ChatHolder onLayout(ViewHolder holder, boolean isMe) {
        if (isMe) {
            holder.leftHolder.container.setVisibility(8);
            holder.rightHolder.container.setVisibility(0);
            return holder.rightHolder;
        }
        holder.leftHolder.container.setVisibility(0);
        holder.rightHolder.container.setVisibility(8);
        return holder.leftHolder;
    }

    private void showMessage(RichTextWrapper richTextWrapper, String message) {
        if (ImVoiceFilter.isImVoiceMessage((String)message)) {
            message = this.mContext.getString(R.string.str_tips_voice_message);
        }
        if (ImageFilter.isImageMessage((String)message)) {
            richTextWrapper.getTextView().setPadding(0, 0, 0, 0);
        } else {
            richTextWrapper.getTextView().setPadding(20, 0, 20, 0);
        }
        if (message.length() >= 500) {
            message = EmoticonFilter.replaceEmoticonWithLimited((String)message, (int)500);
        }
        richTextWrapper.setText((CharSequence)message);
    }

    private static class ViewHolder {
        ChatHolder leftHolder;
        ChatHolder rightHolder;
        TextView tvSafeNotice;

        private ViewHolder() {
        }
    }

    private static class ChatHolder {
        ViewGroup container;
        TextView tvName;
        RichTextWrapper richTextWrapper;

        private ChatHolder() {
        }
    }

    public static interface SendUid {
        public void backData(View var1, int var2, ChannelOneChat0neMessage var3);
    }
}

