/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive;

import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.events.IArtistClient_onUserFansNumRsp_EventArgs;
import com.yy.mobile.plugin.main.events.IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthVClient_onGetAuthVList_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onGetReplayNum_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onRequestLiveShowStatus_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onQueryFansNum_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onSubscribeResultWithContext_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.plugin.main.events.IUserInfoClient_onQupaiInfoRsp_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BasePluginEntLiveActivity;
import com.yy.mobile.ui.common.MobileLiveNoDataFragment;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.ui.mobilelive.ReplayUserInfoPopupDialog$$EventBinder;
import com.yy.mobile.ui.pop.IGuidePop;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.provincecity.ProvinceCityUtil;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.artist.IArtistCore;
import com.yymobile.core.authv.IAuthVCore;
import com.yymobile.core.ent.v2.EntContextV2;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.mobilelive.MobileLiveInfo;
import com.yymobile.core.mobilelive.MobileLiveProtocol;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yymobile.core.subscribe.SubscribedNotifyOpenPushPermissionManager;
import com.yymobile.core.user.Gender;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.IUserInfoCore;
import com.yymobile.core.user.UserInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ReplayUserInfoPopupDialog
extends DialogFragment
implements EventCompat,
View.OnClickListener {
    public static final String EXTRA_UID = "extra_uid";
    public static final String TAG = "REPLAY_USER_INFO_POPUP_DIALOG";
    private static final String TAG_QUPAI = "TAG_QUPAI";
    private static final String TAG_TIEBA = "TAG_TIEBA";
    private IMobileLiveCore mobileLiveCore;
    private boolean isMyself = false;
    private boolean isAnonymousUser;
    private boolean isShowing;
    private long mUid;
    private EntUserInfo mEntUserInfo;
    private UserInfo mUserInfo;
    private boolean isFollowed = false;
    private boolean isFollowing = false;
    private int fansCount = 0;
    private int showingId = 0;
    private ViewGroup mRootView;
    private CircleImageView mPortraitIv;
    private RecycleImageView mAuthVIv;
    private TextView mNicknameTv;
    private TextView mFansCountTv;
    private TextView mFollowTv;
    private ProgressBar mPbFollowing;
    private View mCloseView;
    private TextView mSignTv;
    private View mDividerView;
    private TextView mLocationTv;
    private View mQupaiHeadView;
    private View mTiebaHeadView;
    private TextView mQupaiCountTv;
    private TextView mTiebaCountTv;
    private RadioButton rbQupai;
    private RadioButton rbTieba;
    private View indicatorView1;
    private View indicatorView2;
    private TextView mLandscapeTitle;
    private int mAnchorReplayCount;
    private int mWidth;
    private int mHeight;
    private LinearLayout mPortraitContainer;
    private FrameLayout mLandscapContainer;
    private int mOrientation;
    private String mScribeWithContext;
    private EventBinder mReplayUserInfoPopupDialogSniperEventBinder;

    public void onEventBind() {
        if (this.mReplayUserInfoPopupDialogSniperEventBinder == null) {
            this.mReplayUserInfoPopupDialogSniperEventBinder = new ReplayUserInfoPopupDialog$$EventBinder();
        }
        this.mReplayUserInfoPopupDialogSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mReplayUserInfoPopupDialogSniperEventBinder != null) {
            this.mReplayUserInfoPopupDialogSniperEventBinder.unBindEvent();
        }
    }

    public static ReplayUserInfoPopupDialog newInstance(long uid) {
        ReplayUserInfoPopupDialog fragment = new ReplayUserInfoPopupDialog();
        Bundle bundle = new Bundle();
        bundle.putLong(EXTRA_UID, uid);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ICoreManagerBase.addClient((Object)((Object)this));
        if (this.getArguments() != null) {
            this.mUid = this.getArguments().getLong(EXTRA_UID, this.mUid);
        } else if (savedInstanceState != null) {
            this.mUid = savedInstanceState.getLong(EXTRA_UID, this.mUid);
        }
        this.initData(this.mUid);
        this.mWidth = (int)((float)ResolutionUtils.getScreenWidth((Context)BasicConfig.getInstance().getAppContext()) * 0.95f);
        this.mHeight = -2;
        this.mobileLiveCore = (IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = (ViewGroup)inflater.inflate(R.layout.fragment_mobile_live_user_info_popup, container, false);
        this.mPortraitIv = (CircleImageView)this.mRootView.findViewById(R.id.iv_portrait);
        this.mAuthVIv = (RecycleImageView)this.mRootView.findViewById(R.id.iv_auth_v);
        this.mNicknameTv = (TextView)this.mRootView.findViewById(R.id.tv_nickname);
        this.mFansCountTv = (TextView)this.mRootView.findViewById(R.id.tv_fans_count);
        this.mFollowTv = (TextView)this.mRootView.findViewById(R.id.tv_follow);
        this.mPbFollowing = (ProgressBar)this.mRootView.findViewById(R.id.pb_following);
        this.mCloseView = this.mRootView.findViewById(R.id.iv_close);
        View landscapeClose = this.mRootView.findViewById(R.id.iv_landscape_close);
        this.mSignTv = (TextView)this.mRootView.findViewById(R.id.tv_sign);
        this.mDividerView = this.mRootView.findViewById(R.id.view_divider);
        this.mLocationTv = (TextView)this.mRootView.findViewById(R.id.tv_location);
        this.mQupaiHeadView = this.mRootView.findViewById(R.id.layout_qupai);
        this.mTiebaHeadView = this.mRootView.findViewById(R.id.layout_tieba);
        this.mQupaiCountTv = (TextView)this.mRootView.findViewById(R.id.tv_qupai_count);
        this.mTiebaCountTv = (TextView)this.mRootView.findViewById(R.id.tv_tieba_count);
        this.rbQupai = (RadioButton)this.mRootView.findViewById(R.id.rb_qupai);
        this.rbTieba = (RadioButton)this.mRootView.findViewById(R.id.rb_tieba);
        this.mLandscapeTitle = (TextView)this.mRootView.findViewById(R.id.tv_landscape_title);
        this.mPortraitIv.setOnClickListener((View.OnClickListener)this);
        this.mFollowTv.setOnClickListener((View.OnClickListener)this);
        this.mCloseView.setOnClickListener((View.OnClickListener)this);
        this.mQupaiHeadView.setOnClickListener((View.OnClickListener)this);
        this.mTiebaHeadView.setOnClickListener((View.OnClickListener)this);
        this.mLandscapeTitle.setOnClickListener((View.OnClickListener)this);
        landscapeClose.setOnClickListener((View.OnClickListener)this);
        this.indicatorView1 = this.mRootView.findViewById(R.id.view_indicator_1);
        this.indicatorView2 = this.mRootView.findViewById(R.id.view_indicator_2);
        this.mPortraitContainer = (LinearLayout)this.mRootView.findViewById(R.id.portrait_container);
        this.mLandscapContainer = (FrameLayout)this.mRootView.findViewById(R.id.landscape_container);
        return this.mRootView;
    }

    private void initView() {
        this.updateFollowState();
        if (this.isAnonymousUser) {
            this.mSignTv.setText(R.string.mobile_live_sign_not_login);
            this.mSignTv.setVisibility(0);
        }
        if (this.mUserInfo != null) {
            this.onRequestDetailUserInfo(this.mUserInfo.userId, this.mUserInfo, true, null);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.DialogAnimation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setFlags(1024, 1024);
        return dialog;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mOrientation = this.getActivity().getResources().getConfiguration().orientation;
        if (this.mOrientation == 2) {
            this.onOrientationChanged(true);
        }
    }

    public void onResume() {
        super.onResume();
        this.checkWindowSize(false);
        this.isShowing = true;
        this.requestData();
        this.initView();
    }

    public void onStop() {
        super.onStop();
        this.isShowing = false;
    }

    public void onDestroy() {
        ICoreManagerBase.removeClient((Object)((Object)this));
        super.onDestroy();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putLong(EXTRA_UID, this.mUid);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.onOrientationChanged(newConfig.orientation == 2);
    }

    public void onOrientationChanged(boolean isLandscape) {
        if (isLandscape) {
            this.mWidth = (int)ResolutionUtils.convertDpToPixel((float)355.0f, (Context)this.getActivity());
            if (this.showingId != 0) {
                this.changeLandscapeMode();
                String title = "";
                int titleCount = 0;
                if (this.showingId == R.id.layout_qupai) {
                    title = this.getResources().getString(R.string.short_video);
                    titleCount = Integer.parseInt(this.mQupaiCountTv.getText().toString());
                } else if (this.showingId == R.id.layout_tieba) {
                    title = this.getResources().getString(R.string.mobile_live_user_info_tab_replay);
                    titleCount = Integer.parseInt(this.mTiebaCountTv.getText().toString());
                }
                SpannableStringBuilder spanText = this.getLandscapeTitle(title, titleCount);
                this.mLandscapeTitle.setText((CharSequence)spanText);
            }
        } else {
            this.mWidth = (int)((float)ResolutionUtils.getScreenWidth((Context)BasicConfig.getInstance().getAppContext()) * 0.95f);
            this.changeProtraitMode();
        }
    }

    private void changeLandscapeMode() {
        this.mPortraitContainer.setVisibility(8);
        this.mLandscapContainer.setVisibility(0);
    }

    private void changeProtraitMode() {
        this.mPortraitContainer.setVisibility(0);
        this.mLandscapContainer.setVisibility(8);
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.tv_follow) {
            if (!this.isFollowed) {
                if (LoginUtil.isLogined()) {
                    if (this.mEntUserInfo != null) {
                        this.mScribeWithContext = ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).subscribeWithContext(this.mUid);
                        this.isFollowing = true;
                    }
                    ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1905", "0001");
                    this.mFollowTv.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ReplayUserInfoPopupDialog.this.updateFollowState();
                        }
                    }, 500L);
                } else {
                    ((BasePluginEntLiveActivity)this.getActivity()).showLoginDialog();
                }
            }
        } else if (viewId == R.id.iv_close || viewId == R.id.iv_landscape_close) {
            this.hide();
        } else if (viewId == R.id.layout_qupai) {
            this.toggleContent(v.getId());
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1905", "0002");
        } else if (viewId == R.id.layout_tieba) {
            this.toggleContent(v.getId());
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1905", "0009");
        } else if (viewId == R.id.tv_landscape_title) {
            this.toggleContent((Integer)v.getTag());
        } else if (viewId == R.id.iv_portrait) {
            if (this.getActivity() == null || this.getActivity().isFinishing() || Build.VERSION.SDK_INT >= 17 && this.getActivity().isDestroyed()) {
                return;
            }
            if (this.mEntUserInfo == null) {
                MLog.warn((Object)TAG, (String)("toProfile uid:" + this.mUid + ", mEntUserInfo:null"), (Object[])new Object[0]);
            }
            ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toProfile(this.getContext(), this.mUid, 0);
        }
    }

    public void hide() {
        MLog.info((Object)TAG, (String)("hide " + this.mUid), (Object[])new Object[0]);
        if (this.rbQupai != null && this.rbTieba != null) {
            this.rbQupai.setChecked(false);
            this.rbTieba.setChecked(false);
        }
        super.dismissAllowingStateLoss();
    }

    @BusEvent(sync=true)
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        long userId = busEventArgs.getUid();
        MLog.info((Object)TAG, (String)("onLoginSucceed userId = " + userId), (Object[])new Object[0]);
        if (this.isMyself) {
            this.mUid = userId;
        }
        this.requestData();
    }

    @BusEvent(sync=true)
    public void onRequestLiveShowStatus(IMobileLiveClient_onRequestLiveShowStatus_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        MobileLiveInfo info = busEventArgs.getInfo();
        this.onRequestLiveShowStatus(result, info);
    }

    public void onRequestLiveShowStatus(int result, MobileLiveInfo info) {
        MLog.info((Object)TAG, (String)("onRequestLiveShowStatus info=" + info), (Object[])new Object[0]);
        if (info != null && info.anchorUid == this.mUid && info.location != null && info.location.length() > 0) {
            this.mLocationTv.setText((CharSequence)info.location);
        }
    }

    @BusEvent(sync=true)
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        MLog.info((Object)TAG, (String)("onRequestProfile info=" + info), (Object[])new Object[0]);
        if (info != null && info.uid == this.mUid && this.mUid != 0L) {
            this.mEntUserInfo = info;
            this.requestFollowInfo(info.userType == 1);
        }
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        this.onRequestDetailUserInfo(userId, info, isLocalData, error);
    }

    public void onRequestDetailUserInfo(long userId, UserInfo info, boolean isLocalData, CoreError error) {
        MLog.info((Object)TAG, (String)("onRequestDetailUserInfo userId=" + userId + ",isLocalData=" + isLocalData), (Object[])new Object[0]);
        if (this.mUid == userId && this.mUid != 0L && info != null && error == null) {
            this.mUserInfo = info;
            if (info.gender == Gender.Female) {
                this.mNicknameTv.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.icon_personal_female, 0);
            } else if (info.gender == Gender.Male) {
                this.mNicknameTv.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.icon_personal_male, 0);
            }
            this.mNicknameTv.setText((CharSequence)info.nickName);
            String url = FaceHelperFactory.getFriendHeadUrl((String)info.iconUrl_100_100, (int)info.iconIndex);
            if (url != null && !url.equals(this.mPortraitIv.getTag())) {
                FaceHelperFactory.loadFace((String)info.iconUrl_100_100, (int)info.iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)this.mPortraitIv, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
                this.mPortraitIv.setTag((Object)url);
            }
            if (info.signature != null && info.signature.length() > 0) {
                this.mSignTv.setVisibility(0);
                this.mSignTv.setText((CharSequence)info.signature);
            }
            if (this.mUid != this.mobileLiveCore.getCurrentMobileLiveInfo().anchorUid || this.mUid == this.mobileLiveCore.getCurrentMobileLiveInfo().anchorUid && TextUtils.isEmpty((CharSequence)this.mobileLiveCore.getCurrentMobileLiveInfo().location)) {
                if (info.area == 156 && info.province >= 0 && info.city >= 0) {
                    this.mLocationTv.setText((CharSequence)(ProvinceCityUtil.instance((Context)this.getActivity()).getProvince(info.province) + " " + ProvinceCityUtil.instance((Context)this.getActivity()).getCity(info.province, info.city)));
                }
            } else {
                this.onRequestLiveShowStatus(MobileLiveProtocol.LiveShowStatusRsp.OK.intValue(), this.mobileLiveCore.getCurrentMobileLiveInfo());
            }
        }
    }

    @BusEvent(sync=true)
    public void onGetAuthVList(IAuthVClient_onGetAuthVList_EventArgs busEventArgs) {
        int resultCode = busEventArgs.getResultCode();
        HashMap authVInfo = busEventArgs.getAuthVInfo();
        Map extendInfo = busEventArgs.getExtendInfo();
        if (resultCode == 0 && authVInfo != null && authVInfo.size() > 0 && authVInfo.containsKey(this.mUid)) {
            if (((Uint32)authVInfo.get(this.mUid)).intValue() == 1) {
                ImageLoader.loadImageResource((int)R.drawable.common_portrait_auth_v_1, (RecycleImageView)this.mAuthVIv, (ImageConfig)ImageConfig.fullImageConfig());
                this.mAuthVIv.setVisibility(0);
            } else if (((Uint32)authVInfo.get(this.mUid)).intValue() == 2) {
                ImageLoader.loadImageResource((int)R.drawable.common_portrait_auth_v_10, (RecycleImageView)this.mAuthVIv, (ImageConfig)ImageConfig.fullImageConfig());
                this.mAuthVIv.setVisibility(0);
            }
        }
    }

    @BusEvent(sync=true)
    public void onQupaiInfoRsp(IUserInfoClient_onQupaiInfoRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        String url = busEventArgs.getUrl();
        Map contentInfo = busEventArgs.getContentInfo();
        MLog.info((Object)TAG, (String)("onQupaiInfoRsp result=" + result + ", uid=" + uid + ",url=" + url + ",contentInfo=" + contentInfo), (Object[])new Object[0]);
        if (result == 0 && uid == this.mUid && contentInfo != null && contentInfo.size() > 0) {
            int count = StringUtils.safeParseInt((String)((String)contentInfo.get("count")));
            this.mQupaiCountTv.setText((CharSequence)Integer.toString(count));
        }
    }

    @BusEvent(sync=true)
    public void onGetReplayNum(IMobileLiveClient_onGetReplayNum_EventArgs busEventArgs) {
        long uid = busEventArgs.getUid();
        int count = busEventArgs.getCount();
        MLog.info((Object)TAG, (String)("onGetReplayNum  uid=" + uid + ",count=" + count), (Object[])new Object[0]);
        if (uid == this.mUid) {
            this.mAnchorReplayCount = count;
            this.mTiebaCountTv.setText((CharSequence)Integer.toString(this.mAnchorReplayCount));
        }
    }

    @BusEvent(sync=true)
    public void onQueryFansNum(IProfileClient_onQueryFansNum_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long anchorId = busEventArgs.getAnchorUid();
        int count = busEventArgs.getCount();
        MLog.info((Object)TAG, (String)("onQueryFansNum result=" + result + ", anchorId=" + anchorId + ",count=" + count), (Object[])new Object[0]);
        if (result == 0 && anchorId == this.mUid && count >= 0) {
            this.fansCount = count;
            this.updateFansCount();
        }
    }

    @BusEvent(sync=true)
    public void onSubscribeResultWithContext(ISubscribeClient_onSubscribeResultWithContext_EventArgs busEventArgs) {
        long anchorUid = busEventArgs.getAnchorUid();
        boolean success = busEventArgs.getSuccess();
        EntContextV2 entContext = busEventArgs.getEntContext();
        if (this.mScribeWithContext != null && this.mScribeWithContext.equals(entContext.getMobPacket().head.getAppData())) {
            MLog.info((Object)TAG, (String)("onSubscribeResult anchorUid=" + anchorUid + ",success=" + success), (Object[])new Object[0]);
            if (anchorUid == this.mUid && this.mUid != 0L) {
                if (success) {
                    this.isFollowed = true;
                    this.isFollowing = false;
                    ++this.fansCount;
                    this.updateFansCount();
                    this.updateFollowState();
                    ((BasePluginEntLiveActivity)this.getActivity()).toast(R.string.str_subscribe_succed);
                    SubscribedNotifyOpenPushPermissionManager.showSubscribedNotifyDialog((Fragment)this, (long)this.mUid, (String)(this.mUserInfo != null ? this.mUserInfo.nickName : ""), (int)IGuidePop.Companion.getFROM_FOLLOW());
                } else {
                    this.isFollowing = false;
                    this.updateFollowState();
                    ((BasePluginEntLiveActivity)this.getActivity()).toast(R.string.str_subscribe_failed);
                }
            }
        }
    }

    @BusEvent(sync=true)
    public void onUserFansNumRsp(IArtistClient_onUserFansNumRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        int count = busEventArgs.getCount();
        MLog.info((Object)TAG, (String)("onUserFansNumRsp result=" + result + ",uid=" + uid + ",count=" + count), (Object[])new Object[0]);
        if (result == 0 && uid == this.mUid && count >= 0) {
            this.fansCount = count;
            this.updateFansCount();
        }
    }

    @BusEvent(sync=true)
    public void onQueryBookAnchorBatchResult(IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs busEventArgs) {
        long uid = busEventArgs.getAnchorUid();
        Map friendList = busEventArgs.getFriendList();
        MLog.info((Object)TAG, (String)("onQueryBookAnchorBatchResult uid:" + uid + ",friendList=" + friendList), (Object[])new Object[0]);
        if (uid != 0L && uid == LoginUtil.getUid() && friendList != null) {
            for (Map.Entry entry : friendList.entrySet()) {
                if ((Long)entry.getKey() != this.mUid) continue;
                this.isFollowed = (Boolean)entry.getValue();
                this.updateFollowState();
                return;
            }
        }
    }

    private void updateFollowState() {
        if (this.mFollowTv == null) {
            return;
        }
        if (this.isAnonymousUser || this.mUid != 0L && this.mUid == LoginUtil.getUid()) {
            this.mFollowTv.setVisibility(8);
            return;
        }
        if (this.isFollowing) {
            this.mPbFollowing.setVisibility(0);
            this.mFollowTv.setVisibility(4);
            return;
        }
        if (this.isFollowed) {
            this.mPbFollowing.setVisibility(8);
            this.mFollowTv.setText(R.string.str_gallery_guanzhu);
            this.mFollowTv.setTextColor(BasicConfig.getInstance().getAppContext().getResources().getColor(R.color.txt_color_four));
            this.mFollowTv.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            this.mFollowTv.setCompoundDrawablePadding(0);
            this.mFollowTv.setBackgroundResource(R.color.transparent);
        } else {
            this.mPbFollowing.setVisibility(8);
            this.mFollowTv.setText(R.string.str_gallery_no_guanzhu);
            this.mFollowTv.setTextColor(BasicConfig.getInstance().getAppContext().getResources().getColor(R.color.txt_color_two));
            this.mFollowTv.setCompoundDrawablesWithIntrinsicBounds(R.drawable.living_icon_follow_new, 0, 0, 0);
            this.mFollowTv.setCompoundDrawablePadding(BasicConfig.getInstance().getAppContext().getResources().getDimensionPixelSize(R.dimen.mobile_live_user_info_pop_follow_drawable_padding));
            this.mFollowTv.setBackgroundResource(R.drawable.bg_preview_btn_selector);
        }
        int padding = BasicConfig.getInstance().getAppContext().getResources().getDimensionPixelSize(R.dimen.mobile_live_user_info_pop_follow_padding);
        this.mFollowTv.setPadding(padding, 0, padding, 0);
        this.mFollowTv.setVisibility(0);
    }

    private void updateFansCount() {
        this.mFansCountTv.setText((CharSequence)this.getString(R.string.str_mobile_live_fans_count_format, new Object[]{this.fansCount}));
    }

    private void toggleContent(int id2) {
        FragmentManager fm = this.getChildFragmentManager();
        Object toShow = null;
        String tag = null;
        Fragment qupaiFragment = fm.findFragmentByTag(TAG_QUPAI);
        Fragment tiebaFragment = fm.findFragmentByTag(TAG_TIEBA);
        RadioButton rb = null;
        String title = "";
        int titleCount = 0;
        if (id2 == R.id.layout_qupai) {
            tag = TAG_QUPAI;
            rb = this.rbQupai;
            title = this.getResources().getString(R.string.short_video);
            titleCount = Integer.parseInt(this.mQupaiCountTv.getText().toString());
        } else if (id2 == R.id.layout_tieba) {
            if (this.mAnchorReplayCount == 0) {
                toShow = tiebaFragment == null ? new MobileLiveNoDataFragment() : tiebaFragment;
            }
            tag = TAG_TIEBA;
            rb = this.rbTieba;
            title = this.getResources().getString(R.string.mobile_live_user_info_tab_replay);
            titleCount = Integer.parseInt(this.mTiebaCountTv.getText().toString());
        }
        if (toShow == null || rb == null) {
            return;
        }
        FragmentTransaction ft = fm.beginTransaction();
        if (id2 == this.showingId) {
            ft.hide(toShow);
            this.changeProtraitMode();
            if (this.mUserInfo != null && this.mUserInfo.signature != null && this.mUserInfo.signature.length() > 0) {
                this.mSignTv.setVisibility(0);
            }
            this.mDividerView.setVisibility(0);
            this.mLocationTv.setVisibility(0);
            rb.setChecked(false);
            this.showingId = 0;
            this.getDialog().setCanceledOnTouchOutside(true);
        } else {
            if (toShow != qupaiFragment && qupaiFragment != null) {
                ft.hide(qupaiFragment);
            }
            if (toShow != tiebaFragment && tiebaFragment != null) {
                ft.hide(tiebaFragment);
            }
            if (toShow.isDetached()) {
                ft.attach(toShow);
            } else if (!toShow.isAdded()) {
                ft.add(R.id.layout_content, toShow, tag);
            } else if (toShow.isHidden()) {
                ft.show(toShow);
            }
            if (this.getActivity().getResources().getConfiguration().orientation == 1) {
                this.changeProtraitMode();
                this.mSignTv.setVisibility(8);
                this.mDividerView.setVisibility(8);
                this.mLocationTv.setVisibility(8);
            } else {
                this.changeLandscapeMode();
                SpannableStringBuilder spanText = this.getLandscapeTitle(title, titleCount);
                this.mLandscapeTitle.setText((CharSequence)spanText);
            }
            this.mLandscapeTitle.setTag((Object)id2);
            this.rbQupai.setChecked(false);
            this.rbTieba.setChecked(false);
            rb.setChecked(true);
            this.showingId = id2;
            this.getDialog().setCanceledOnTouchOutside(false);
        }
        if (ft.commitAllowingStateLoss() < 0) {
            fm.executePendingTransactions();
        }
        this.updateIndicatorView();
    }

    private SpannableStringBuilder getLandscapeTitle(String title, int titleCount) {
        SpannableStringBuilder spanText = new SpannableStringBuilder((CharSequence)title);
        spanText.append((CharSequence)"(");
        spanText.append((CharSequence)String.valueOf(titleCount));
        spanText.append((CharSequence)")");
        spanText.setSpan((Object)new ForegroundColorSpan(-30464), title.length(), spanText.length(), 17);
        return spanText;
    }

    private void updateIndicatorView() {
        if (this.showingId == 0) {
            this.indicatorView1.setVisibility(8);
            this.indicatorView2.setVisibility(8);
        }
        if (this.showingId == 0) {
            this.indicatorView1.setVisibility(8);
            this.indicatorView2.setVisibility(8);
        } else if (this.showingId == R.id.layout_qupai) {
            this.indicatorView1.setVisibility(0);
            this.indicatorView2.setVisibility(0);
            this.indicatorView1.setBackgroundResource(R.drawable.ind_live_user_selected);
            this.indicatorView2.setBackgroundResource(R.drawable.ind_live_user_unselect);
        } else if (this.showingId == R.id.layout_tieba) {
            this.indicatorView1.setVisibility(0);
            this.indicatorView2.setVisibility(0);
            this.indicatorView1.setBackgroundResource(R.drawable.ind_live_user_unselect);
            this.indicatorView2.setBackgroundResource(R.drawable.ind_live_user_selected);
        }
    }

    private void requestData() {
        if (this.isAnonymousUser) {
            return;
        }
        this.mEntUserInfo = ((IProfileCore)ICoreManagerBase.getCore(IProfileCore.class)).getCachedProfileInfo(this.mUid);
        if (this.mEntUserInfo == null) {
            ((IProfileCore)ICoreManagerBase.getCore(IProfileCore.class)).requestProfile(this.mUid);
        } else {
            this.requestFollowInfo(this.mEntUserInfo.userType == 1);
        }
        this.mUserInfo = ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).getCacheUserInfoByUid(this.mUid);
        ICoreManagerBase.getUserCore().requestDetailUserInfo(this.mUid, true);
        ((IUserInfoCore)ICoreManagerBase.getCore(IUserInfoCore.class)).requestQupaiInfo(this.mUid);
        ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).getReplayNum(this.mUid);
        ((IAuthVCore)ICoreManagerBase.getCore(IAuthVCore.class)).querySingerAuthVInfo(this.mUid, null);
    }

    private void requestFollowInfo(boolean isAnchor) {
        MLog.info((Object)TAG, (String)("requestFollowInfo isAnchor:" + isAnchor + ", mUid:" + this.mUid), (Object[])new Object[0]);
        if (isAnchor) {
            ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).querySubscribe(this.mUid);
            ((IProfileCore)ICoreManagerBase.getCore(IProfileCore.class)).queryFansNum(this.mUid);
        } else {
            ArrayList<Long> uids = new ArrayList<Long>();
            uids.add(this.mUid);
            ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).queryBookAnchorBatchReq(LoginUtil.getUid(), uids);
            ((IArtistCore)ICoreManagerBase.getCore(IArtistCore.class)).queryUserFansNum(this.mUid);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkWindowSize(boolean showAnimation) {
        try {
            Window window = this.getDialog().getWindow();
            if (window.getAttributes().width == this.mWidth && window.getAttributes().height == this.mHeight) return;
            window.setLayout(this.mWidth, this.mHeight);
            window.setGravity(17);
            if (!showAnimation) return;
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)("checkWindowSize error! " + throwable), (Object[])new Object[0]);
        }
    }

    private void initData(long uid) {
        MLog.info((Object)TAG, (String)("initData uid = " + uid), (Object[])new Object[0]);
        this.mUid = uid;
        this.showingId = 0;
        this.isAnonymousUser = ICoreManagerBase.getLoginCore().isAnonymousUser(uid);
        this.isMyself = LoginUtil.isLogined() ? this.mUid == LoginUtil.getUid() : this.mUid == LoginUtil.getAnoymousUid();
        this.mUserInfo = null;
        this.mEntUserInfo = null;
        this.mAnchorReplayCount = 0;
        this.isFollowing = false;
    }

    public void onDetach() {
        super.onDetach();
        try {
            Field f = Fragment.class.getDeclaredField("mChildFragmentManager");
            f.setAccessible(true);
            f.set((Object)this, null);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)("Error getting mChildFragmentManager field" + throwable), (Object[])new Object[0]);
        }
    }
}

